/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.Messages;
import com.ibm.team.workitem.common.model.IAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkItemDynamicActionProvider<T> {
    private static final String CREATE_TYPE_ACTION = "create/type";
    private static final String MODIFY_ACTION = "modify";
    private static final String ACTION_ACTION = "action";
    private final ProcessSpecificationModel fModel;
    private final List<IAttribute> fAttributes;
    private final LocalizationContext fLocalizationContext;

    public AbstractWorkItemDynamicActionProvider(ProcessSpecificationModel model, List<IAttribute> attributes, LocalizationContext lc) {
        this.fModel = model;
        this.fAttributes = attributes;
        this.fLocalizationContext = lc;
    }

    protected abstract T createDynamicAction(String var1, String var2, String var3);

    public List<T> computeActions(IPath actionPath, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fModel == null) {
            return Collections.emptyList();
        }
        if (MODIFY_ACTION.equals(actionPath.toString())) {
            return this.getCustomAttributeActions(monitor);
        }
        if (CREATE_TYPE_ACTION.equals(actionPath.toString())) {
            DataElement data = this.findConfigurationData();
            if (data == null) {
                return Collections.emptyList();
            }
            return this.getTypeActions(data);
        }
        if (ACTION_ACTION.equals(actionPath.toString())) {
            DataElement data = this.findConfigurationData();
            if (data == null) {
                return Collections.emptyList();
            }
            return this.getWorkflowActions(data);
        }
        return Collections.emptyList();
    }

    private DataElement findConfigurationData() throws TeamRepositoryException {
        ProjectConfigurationElement configuration = this.fModel.getProjectConfiguration();
        if (configuration == null) {
            return null;
        }
        DataElement data = configuration.getData();
        if (data == null) {
            return null;
        }
        return data;
    }

    private List<T> getCustomAttributeActions(IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<T> actions = new ArrayList<T>();
        DataElement data = this.findConfigurationData();
        if (data != null) {
            ConfigurationDataElement[] configurationDataElementArray = data.getConfigurationData();
            int n = configurationDataElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationDataElement typesData = configurationDataElementArray[n2];
                if ("com.ibm.team.workitem.configuration.workItemTypes".equals(typesData.getId())) {
                    IProcessConfigurationElement[] iProcessConfigurationElementArray = typesData.getElements();
                    int n3 = iProcessConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProcessConfigurationElement customAttributes = iProcessConfigurationElementArray[n4];
                        if ("customAttributes".equals(customAttributes.getName())) {
                            IProcessConfigurationElement[] iProcessConfigurationElementArray2 = customAttributes.getChildren();
                            int n5 = iProcessConfigurationElementArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String id;
                                IProcessConfigurationElement customAttribute = iProcessConfigurationElementArray2[n6];
                                if ("customAttribute".equals(customAttribute.getName()) && (id = customAttribute.getAttribute("id")) != null && id.length() > 0 && !ids.contains(id)) {
                                    String name = customAttribute.getAttribute("name");
                                    if (name == null || name.length() == 0) {
                                        name = id;
                                    }
                                    ids.add(id);
                                    actions.add(this.createDynamicAction(id, NLS.bind((String)Messages.getString(this.fLocalizationContext, "WorkItemDynamicActionProvider.MODIFY_ATTRIBUTE"), (Object)name, (Object[])new Object[0]), null));
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (IAttribute attribute : this.fAttributes) {
            String id = attribute.getIdentifier();
            if (attribute.isBuiltIn() || ids.contains(id)) continue;
            String name = attribute.getDisplayName();
            if (name.length() == 0) {
                name = id;
            }
            ids.add(id);
            actions.add(this.createDynamicAction(id, NLS.bind((String)Messages.getString(this.fLocalizationContext, "WorkItemDynamicActionProvider.MODIFY_ATTRIBUTE"), (Object)name, (Object[])new Object[0]), null));
        }
        return actions;
    }

    private List<T> getTypeActions(DataElement data) {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<T> actions = new ArrayList<T>();
        ConfigurationDataElement[] configurationDataElementArray = data.getConfigurationData();
        int n = configurationDataElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDataElement typesData = configurationDataElementArray[n2];
            if ("com.ibm.team.workitem.configuration.workItemTypes".equals(typesData.getId())) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray = typesData.getElements();
                int n3 = iProcessConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id;
                    IProcessConfigurationElement type = iProcessConfigurationElementArray[n4];
                    if ("type".equals(type.getName()) && (id = type.getAttribute("id")) != null && id.length() > 0 && !ids.contains(id)) {
                        String name = type.getAttribute("name");
                        if (name == null || name.length() == 0) {
                            name = id;
                        }
                        ids.add(id);
                        actions.add(this.createDynamicAction(id, NLS.bind((String)Messages.getString(this.fLocalizationContext, "WorkItemDynamicActionProvider.CREATE_TYPE"), (Object)name, (Object[])new Object[0]), null));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return actions;
    }

    private List<T> getWorkflowActions(DataElement data) {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<T> actions = new ArrayList<T>();
        ConfigurationDataElement[] configurationDataElementArray = data.getConfigurationData();
        int n = configurationDataElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDataElement workflowData = configurationDataElementArray[n2];
            if ("com.ibm.team.workitem.configuration.workflow".equals(workflowData.getId())) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray = workflowData.getElements();
                int n3 = iProcessConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcessConfigurationElement workflowDefinition = iProcessConfigurationElementArray[n4];
                    if ("workflowDefinition".equals(workflowDefinition.getName())) {
                        IProcessConfigurationElement[] iProcessConfigurationElementArray2 = workflowDefinition.getChildren();
                        int n5 = iProcessConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IProcessConfigurationElement workflow = iProcessConfigurationElementArray2[n6];
                            if ("workflow".equals(workflow.getName())) {
                                String workflowName = workflow.getAttribute("name");
                                if (workflowName == null || workflowName.length() == 0) {
                                    workflowDefinition.getAttribute("id");
                                }
                                if (workflowName == null || workflowName.length() == 0) {
                                    workflowName = Messages.getString(this.fLocalizationContext, "WorkItemDynamicActionProvider.UNNAMED_WORKFLOW");
                                }
                                IProcessConfigurationElement[] iProcessConfigurationElementArray3 = workflow.getChildren();
                                int n7 = iProcessConfigurationElementArray3.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    String id;
                                    IProcessConfigurationElement action = iProcessConfigurationElementArray3[n8];
                                    if (ACTION_ACTION.equals(action.getName()) && (id = action.getAttribute("id")) != null && id.length() > 0 && !ids.contains(id)) {
                                        String name = action.getAttribute("name");
                                        if (name == null || name.length() == 0) {
                                            name = id;
                                        }
                                        ids.add(id);
                                        actions.add(this.createDynamicAction(id, NLS.bind((String)Messages.getString(this.fLocalizationContext, "WorkItemDynamicActionProvider.ACTION_OF_WORKFLOW"), (Object)name, (Object[])new Object[]{workflowName}), null));
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return actions;
    }
}

