/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.impl;

import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.ExpressionSerializerFactory;
import com.ibm.team.workitem.common.internal.expression.IExpressionSerializer;
import com.ibm.team.workitem.common.internal.query.impl.Associations;
import com.ibm.team.workitem.common.internal.query.impl.DefaultSerializationContext;
import com.ibm.team.workitem.common.internal.query.impl.QueryDescriptorImpl;
import com.ibm.team.workitem.common.query.IAssociations;
import org.eclipse.core.runtime.Assert;

public class QueryDescriptorCustomImpl
extends QueryDescriptorImpl {
    private Expression fExpression;
    private Associations fAssociations;

    public Expression getExpression() throws SerializationException {
        if (this.getInternalExpression() == null) {
            return null;
        }
        if (this.fExpression == null) {
            IExpressionSerializer serializer = ExpressionSerializerFactory.getSerializer(this.getSerializationVersion());
            this.fExpression = serializer.deserialize(this.getInternalExpression(), new DefaultSerializationContext(this));
        }
        return this.fExpression;
    }

    public void setExpression(Expression newExpression) throws SerializationException {
        this.fExpression = newExpression;
        if (this.fExpression != null) {
            IExpressionSerializer serializer = ExpressionSerializerFactory.getSerializer("XML");
            String serialized = serializer.serialize(this.fExpression);
            Assert.isNotNull((Object)serialized);
            if (!serialized.equals(this.getInternalExpression())) {
                this.setInternalExpression(serialized);
            }
            if (!"XML".equals(this.getSerializationVersion())) {
                this.setSerializationVersion("XML");
            }
        } else {
            this.setInternalExpression(null);
        }
    }

    public IAssociations getAssociations() {
        if (this.fAssociations == null) {
            this.fAssociations = new Associations(this.getInternalAssociations());
        }
        return this.fAssociations;
    }

    public boolean isShared() {
        return !this.getInternalAssociations().isEmpty();
    }
}

