/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeRegistry;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericQueryAttributeFactory
implements IQueryableAttributeFactory,
IExecutableExtension {
    private IItemType fItemType;
    private String fAttributeType;
    private Set<String> fQueryableIdentifiers;

    public GenericQueryAttributeFactory() {
    }

    public GenericQueryAttributeFactory(IItemType itemType, String attributeType) {
        this.fItemType = itemType;
        this.fAttributeType = attributeType;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fItemType = QueryableAttributes.readItemTypeElement(config);
        this.fAttributeType = QueryableAttributes.readAttributeType(config);
    }

    @Override
    public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQueryableAttribute> queryableAttributes = new ArrayList<IQueryableAttribute>();
        for (IAttributeDescriptor attribute : AttributeRegistry.getInstance().getAttributes(this.fAttributeType)) {
            IQueryableAttribute queryableAttribute = this.createQueryableAttribute(attribute);
            if (queryableAttribute == null) continue;
            queryableAttributes.add(queryableAttribute);
        }
        return queryableAttributes;
    }

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttributeDescriptor attribute = AttributeRegistry.getInstance().getAttributeDescriptor(this.fAttributeType, attributeIdentifier);
        return attribute == null ? null : this.createQueryableAttribute(attribute);
    }

    private IQueryableAttribute createQueryableAttribute(IAttributeDescriptor attribute) {
        if (attribute instanceof AttributeDescriptor) {
            String identifier;
            String emfPath = ((AttributeDescriptor)attribute).getEMFPath();
            String string = identifier = emfPath == null ? attribute.getIdentifier() : emfPath;
            if (this.isQueryable(identifier)) {
                return new QueryableAttribute(identifier, attribute.getAttributeType(), attribute.getDisplayName());
            }
        }
        return null;
    }

    @Override
    public ItemProfile<? extends IAuditable> computeProfile(List<IQueryableAttribute> attributes) {
        return ItemProfile.createFullProfile(this.fItemType);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Collections.emptyList();
    }

    private boolean isQueryable(String identifier) {
        if (this.fQueryableIdentifiers == null) {
            HashSet<String> identifiers = new HashSet<String>();
            IDynamicItemQueryModel queryModel = this.fItemType.getQueryModel();
            identifiers.addAll(queryModel.getAllFields());
            identifiers.addAll(queryModel.getAllReferences());
            this.fQueryableIdentifiers = identifiers;
        }
        return this.fQueryableIdentifiers.contains(identifier);
    }
}

