/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IAttributeHandle;

public class AttributeTypeMapping {
    public static String getAttributeType(IItemHandle itemHandle) {
        if (itemHandle instanceof IAttachmentHandle) {
            return "attachment";
        }
        if (itemHandle instanceof IAttributeHandle) {
            return "attribute";
        }
        AttributeType attributeType = AttributeTypes.getAttributeType(itemHandle.getItemType());
        return attributeType != null ? attributeType.getIdentifier() : null;
    }

    public static String getAttributeType(IEndPointDescriptor endPoint) {
        IItemType itemType = endPoint.getReferencedItemType();
        if (itemType != null) {
            if (IAttachment.ITEM_TYPE == itemType) {
                return "attachment";
            }
            AttributeType type = AttributeTypes.getAttributeType(itemType);
            if (type != null) {
                return type.getIdentifier();
            }
        }
        return "reference";
    }
}

