/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.expression.IExpressionListener;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.CreateEditableStatementVisitor;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableSortColumn;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableStatement {
    private EditableTerm fRoot;
    private List<IQueryableAttribute> fColumns = new ArrayList<IQueryableAttribute>();
    private List<EditableSortColumn> fSortColumns = new ArrayList<EditableSortColumn>();
    private List<IExpressionListener> fListeners = new ArrayList<IExpressionListener>();

    public static EditableStatement createEditableStatement(Expression expression, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (expression == null) {
            return new EditableStatement(new EditableTerm(Term.Operator.AND));
        }
        CreateEditableStatementVisitor visitor = new CreateEditableStatementVisitor(context);
        expression.accept(visitor, monitor);
        return visitor.getEditableStatement();
    }

    EditableStatement(EditableTerm root) {
        Assert.isNotNull((Object)root);
        this.fRoot = root;
        this.fRoot.addToTree(null, this);
    }

    public void addListener(IExpressionListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IExpressionListener listener) {
        this.fListeners.remove(listener);
    }

    public void notify(ExpressionChangeEvent event) {
        for (IExpressionListener listener : this.fListeners) {
            listener.expressionChanged(event);
        }
    }

    public void notify(StatementChangeEvent event) {
        for (IExpressionListener listener : this.fListeners) {
            listener.statementChanged(event);
        }
    }

    public Statement createStatement() {
        return this.createStatement(this.getRoot());
    }

    public Statement createLogicalRootStatement() {
        return this.createStatement(this.getLogicalRoot());
    }

    private Statement createStatement(EditableTerm root) {
        SelectClause selectClause = new SelectClause();
        for (IQueryableAttribute attribute : this.fColumns) {
            selectClause.addColumnIdentifier(attribute.getIdentifier());
        }
        ArrayList<SortCriteria> sortCriteria = new ArrayList<SortCriteria>(this.fSortColumns.size());
        for (EditableSortColumn sortColumn : this.fSortColumns) {
            sortCriteria.add(new SortCriteria(sortColumn.getAttribute(), sortColumn.getDirection().isAscending()));
        }
        return new Statement(selectClause, root.createExpression(), sortCriteria.toArray(new SortCriteria[sortCriteria.size()]));
    }

    public EditableTerm getRoot() {
        return this.fRoot;
    }

    public EditableTerm getLogicalRoot() {
        return this.getLogicalRoot(this.getRoot());
    }

    public List<IQueryableAttribute> getColumns() {
        return Collections.unmodifiableList(this.fColumns);
    }

    public void addColumns(List<IQueryableAttribute> attributes) {
        this.fColumns.addAll(attributes);
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.COLUMNS_ADDED, this, attributes));
    }

    public void setColumns(List<IQueryableAttribute> attributes) {
        this.fColumns.clear();
        this.fColumns.addAll(attributes);
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.COLUMNS_CHANGED, this, attributes));
    }

    public void removeColumns(List<IQueryableAttribute> attributes) {
        this.fColumns.removeAll(attributes);
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.COLUMNS_REMOVED, this, attributes));
    }

    public void removeAllColumns() {
        this.fColumns.clear();
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.COLUMNS_CLEARED, this));
    }

    public void moveColumns(List<IQueryableAttribute> attributes, int offset) {
        ArrayList<IQueryableAttribute> toBeMoved = new ArrayList<IQueryableAttribute>(attributes);
        if (offset > 0) {
            Collections.reverse(toBeMoved);
        }
        for (IQueryableAttribute attribute : toBeMoved) {
            int index = this.fColumns.indexOf(attribute);
            int newIndex = index + offset;
            if (newIndex <= -1 || newIndex >= this.fColumns.size()) continue;
            this.fColumns.remove(index);
            this.fColumns.add(newIndex, attribute);
        }
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.COLUMNS_CHANGED_ORDER, this));
    }

    public List<EditableSortColumn> getSortColumns() {
        return Collections.unmodifiableList(this.fSortColumns);
    }

    public void addSortColumns(List<EditableSortColumn> sortColumns) {
        for (EditableSortColumn sortColumn : sortColumns) {
            sortColumn.setStatement(this);
        }
        this.fSortColumns.addAll(sortColumns);
        this.notify(new StatementChangeEvent(this, StatementChangeEvent.Type.SORT_COLUMNS_ADDED, sortColumns));
    }

    public void setSortColumns(List<EditableSortColumn> sortColumns) {
        this.internalRemoveAllSortColumns();
        for (EditableSortColumn sortColumn : sortColumns) {
            sortColumn.setStatement(this);
        }
        this.fSortColumns.addAll(sortColumns);
        this.notify(new StatementChangeEvent(this, StatementChangeEvent.Type.SORT_COLUMNS_CHANGED, sortColumns));
    }

    public void removeSortColumns(List<EditableSortColumn> sortColumns) {
        for (EditableSortColumn sortColumn : sortColumns) {
            sortColumn.setStatement(null);
        }
        this.fSortColumns.removeAll(sortColumns);
        this.notify(new StatementChangeEvent(this, StatementChangeEvent.Type.SORT_COLUMNS_REMOVED, sortColumns));
    }

    public void removeAllSortColumns() {
        this.internalRemoveAllSortColumns();
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.SORT_COLUMNS_CLEARED, this));
    }

    private void internalRemoveAllSortColumns() {
        for (EditableSortColumn sortColumn : this.fSortColumns) {
            sortColumn.setStatement(null);
        }
        this.fSortColumns.clear();
    }

    public void moveSortColumns(List<EditableSortColumn> moveCriteria, int offset) {
        ArrayList<EditableSortColumn> toBeMoved = new ArrayList<EditableSortColumn>(moveCriteria);
        if (offset > 0) {
            Collections.reverse(toBeMoved);
        }
        for (EditableSortColumn criteria : toBeMoved) {
            int index = this.fSortColumns.indexOf(criteria);
            int newIndex = index + offset;
            if (newIndex <= -1 || newIndex >= this.fSortColumns.size()) continue;
            this.fSortColumns.remove(index);
            this.fSortColumns.add(newIndex, criteria);
        }
        this.notify(new StatementChangeEvent(StatementChangeEvent.Type.SORT_COLUMNS_CHANGED_ORDER, this));
    }

    private EditableTerm getLogicalRoot(EditableTerm term) {
        int hiddenTerms = 0;
        ArrayList<EditableTerm> rootCandidates = new ArrayList<EditableTerm>();
        for (EditableExpression child : term.getExpressions()) {
            if (!(child instanceof EditableTerm)) continue;
            EditableTerm candidate = (EditableTerm)child;
            if (!candidate.isInternal()) {
                rootCandidates.add(candidate);
                continue;
            }
            ++hiddenTerms;
        }
        if (hiddenTerms > 0) {
            if (rootCandidates.size() == 1 && term.getExpressions().size() - hiddenTerms == 1) {
                return (EditableTerm)rootCandidates.get(0);
            }
            if (rootCandidates.size() == 0 && term.getExpressions().size() - hiddenTerms == 0) {
                return null;
            }
        }
        return term;
    }
}

