/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.queryast.AstQuery;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.expression.Scores;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTExpression
extends Expression {
    private final IQuery fQuery;
    private final List<?> fParameters;
    private boolean fIsDataQuery;
    private final Scores fScores;
    private final UUID[] fContextIds;

    public ASTExpression(IItemQuery query, List<?> parameters) {
        this(query, parameters, null);
    }

    public ASTExpression(IItemQuery query, List<?> parameters, UUID[] contextIds) {
        this((IQuery)query, parameters, false, new Scores(), contextIds);
    }

    public ASTExpression(IQuery query, List<?> parameters, boolean isDataQuery, Scores scores, UUID[] contextIds) {
        this.fQuery = query;
        this.fParameters = parameters;
        this.fIsDataQuery = isDataQuery;
        this.fScores = scores;
        this.fContextIds = contextIds;
    }

    public IQuery getQuery() {
        return this.fQuery;
    }

    public List<?> getParameters() {
        return this.fParameters;
    }

    public Scores getScores() {
        return this.fScores;
    }

    public boolean isDataQuery() {
        return this.fIsDataQuery;
    }

    public boolean hasConditions() {
        return this.fQuery != null && ((AstQuery)this.fQuery).getFilter() != null;
    }

    public UUID[] getContextIds() {
        return this.fContextIds;
    }

    public String toString() {
        int count = 1;
        StringBuffer buffer = new StringBuffer();
        buffer.append(((AstQuery)this.fQuery).getQueryString());
        for (Object parameter : this.fParameters) {
            buffer.append("\n");
            buffer.append("Parameter ");
            buffer.append(count++);
            buffer.append(": ");
            buffer.append(parameter.toString());
        }
        return buffer.toString();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        visitor.visit(this, monitor);
    }

    @Override
    public void init(IPersistableElement element, ISerializationContext context) throws SerializationException {
    }

    @Override
    public void saveState(IPersistableElement element) throws SerializationException {
    }

    public ASTExpression createCountStatement() {
        IDataQuery countQuery = this.getDataQuery(this);
        countQuery.select(countQuery.countDistinct(this.getCountField((IQuery)countQuery)));
        return new ASTExpression((IQuery)countQuery, this.getParameters(), true, this.fScores, this.getContextIds());
    }

    private IField getCountField(IQuery query) {
        return ((AstQuery)query).getReturnItemType().getQueryModel().getField(IItem.ITEM_ID_PROPERTY);
    }

    private IDataQuery getDataQuery(ASTExpression astExpression) {
        AstQuery astQuery = (AstQuery)astExpression.getQuery();
        AstQuery dataQuery = (AstQuery)IDataQuery.FACTORY.newInstance((IQueryModel)astQuery.getRootItemType().getQueryModel());
        dataQuery.filter((IPredicate)EMFHelper.copy(astQuery.getFilter()));
        dataQuery.getInputArgs().addAll(EMFHelper.copy((Collection)astQuery.getInputArgs()));
        return dataQuery;
    }
}

