/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleBasedUserProvider
implements IValueSetProvider<IContributor> {
    private static final String PROJECT_AREA = "projectArea";
    private static final String TEAM_AREA = "teamArea";
    private static final String PATH = "path";
    private static final String ROLE = "role";
    private static final String CURRENT_VARIABLE = "${current}";

    @Override
    public List<? extends IContributor> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        String roleId;
        ItemHandleAwareHashSet<IContributorHandle> collector = new ItemHandleAwareHashSet<IContributorHandle>();
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)attribute.getProjectArea(), monitor);
        for (IConfiguration projectConfiguration : configuration.getChildren(PROJECT_AREA)) {
            IProjectArea projectArea = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)attribute.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
            roleId = projectConfiguration.getString(ROLE);
            this.validateRole((IProcessArea)projectArea, roleId, process, attribute, configuration, monitor);
            this.collectRoles(collector, (IProcessArea)projectArea, roleId, process, monitor);
        }
        for (IConfiguration teamConfiguration : configuration.getChildren(TEAM_AREA)) {
            String processURI = teamConfiguration.getString(PATH);
            roleId = teamConfiguration.getString(ROLE);
            if (CURRENT_VARIABLE.equals(processURI)) {
                if (workItem == null) continue;
                IProcessAreaHandle currentProcessAreaHandle = workItemCommon.findProcessArea(workItem, monitor);
                IProcessArea currentProcessArea = auditableCommon.resolveAuditable((IAuditableHandle)currentProcessAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
                this.validateRole(currentProcessArea, roleId, process, attribute, configuration, monitor);
                this.collectRoles(collector, currentProcessArea, roleId, process, monitor);
                continue;
            }
            try {
                URI uri = this.createURI(processURI);
                IProcessArea processArea = auditableCommon.findProcessAreaByURI(uri, null, monitor);
                if (processArea != null) {
                    this.validateRole(processArea, roleId, process, attribute, configuration, monitor);
                    this.collectRoles(collector, processArea, roleId, process, monitor);
                    continue;
                }
                throw new IllegalArgumentException(NLS.bind((String)Messages.getString("RoleBasedUserProvider.PROCESS_URI_NOT_FOUND"), (Object)configuration.getIdentifier(), (Object[])new Object[]{attribute.getIdentifier(), processURI}));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getString("RoleBasedUserProvider.INVALID_PROCESS_URI"), (Object)configuration.getIdentifier(), (Object[])new Object[]{attribute.getIdentifier(), processURI}), e);
            }
        }
        return auditableCommon.resolveAuditables(collector.toList(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
    }

    private URI createURI(String processURI) throws URISyntaxException {
        Path path = new Path(processURI);
        StringBuilder escaped = new StringBuilder();
        int i = 0;
        while (i < path.segmentCount()) {
            escaped.append(ItemURI.encode(path.segment(i)));
            if (i < path.segmentCount() - 1) {
                escaped.append('/');
            }
            ++i;
        }
        return new URI(escaped.toString());
    }

    private void collectRoles(Set<IContributorHandle> collector, IProcessArea processArea, String roleId, IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle[] iContributorHandleArray = processArea.getMembers();
        int n = iContributorHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributorHandle contributor = iContributorHandleArray[n2];
            List<IRole> roles = process.getContributorRoles(contributor, processArea, monitor);
            for (IRole role : roles) {
                if (!roleId.equals(role.getId())) continue;
                collector.add(contributor);
            }
            ++n2;
        }
    }

    private void validateRole(IProcessArea processArea, String roleId, IAuditableCommonProcess process, IAttribute attribute, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (roleId != null) {
            List<IRole> roles = process.getRoles(processArea, monitor);
            for (IRole role : roles) {
                if (!roleId.equals(role.getId())) continue;
                return;
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.getString("RoleBasedUserProvider.UNKOWN_ROLE"), (Object)configuration.getIdentifier(), (Object[])new Object[]{attribute.getIdentifier(), roleId}));
    }
}

