/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringValueSetProvider
implements IValueSetProvider<Identifier<? extends ILiteral>> {
    private static final String FILTER_ATTRIBUTE = "filterAttribute";
    private static final String FILTER_MAP = "filterMap";
    private static final String ID = "id";
    private static final String LITERAL = "literal";
    private static final String VALUE = "value";
    private static final String CONTENT = "content";

    @Override
    public List<Identifier<? extends ILiteral>> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem == null) {
            List<? extends ILiteral> literals = workItemCommon.resolveEnumeration(attribute, monitor).getEnumerationLiterals();
            ArrayList<Identifier<? extends ILiteral>> identifiers = new ArrayList<Identifier<? extends ILiteral>>();
            for (ILiteral iLiteral : literals) {
                identifiers.add(iLiteral.getIdentifier2());
            }
            return identifiers;
        }
        ArrayList<Identifier<? extends ILiteral>> filteredValues = new ArrayList<Identifier<? extends ILiteral>>();
        IConfiguration filterAttr = configuration.getChild(FILTER_ATTRIBUTE);
        if (filterAttr == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("FilteringValueSetProvider.FILTER_ATTRIBUTE_NOT_DEFINED"), (Object)workItem.getId(), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        String string = filterAttr.getString(ID);
        if (string == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("FilteringValueSetProvider.FILTER_ATTRIBUTE_NOT_DEFINED"), (Object)workItem.getId(), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        IAttribute filterAttribute = workItemCommon.findAttribute(workItem.getProjectArea(), string, monitor);
        if (filterAttribute == null || !workItem.hasAttribute(filterAttribute)) {
            throw new IllegalStateException(NLS.bind((String)Messages.getString("FilteringValueSetProvider.FILTER_ATTRIBUTE_NOT_FOUND"), (Object)workItem.getId(), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        Object filterValue = workItem.getValue(filterAttribute);
        if (filterValue instanceof Identifier) {
            filterValue = ((Identifier)filterValue).getStringIdentifier();
        }
        IEnumeration<? extends ILiteral> enumeration = workItemCommon.resolveEnumeration(attribute, monitor);
        AttributeType attributeType = AttributeTypes.getAttributeType(attribute.getAttributeType());
        IConfiguration map = configuration.getChild(FILTER_MAP);
        if (map != null) {
            for (IConfiguration value : map.getChildren(VALUE)) {
                String content = value.getString(CONTENT);
                if (content == null || !content.equals(filterValue)) continue;
                for (IConfiguration literal : value.getChildren(LITERAL)) {
                    ILiteral lit;
                    String literalId = literal.getString(ID);
                    if (literalId == null || (lit = enumeration.findEnumerationLiteral((Identifier)attributeType.valueOf(literalId, null))) == null) continue;
                    filteredValues.add(lit.getIdentifier2());
                }
            }
        }
        return filteredValues;
    }
}

