/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AttributeCache;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.internal.EnumerationManager;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IWorkItemConfiguration;
import com.ibm.team.workitem.common.internal.IWorkItemRepositoryService;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.ProcessAreaCacheManager;
import com.ibm.team.workitem.common.internal.ProcessConfigurationManager;
import com.ibm.team.workitem.common.internal.RequiredPropertiesManager;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.WorkItemExceptionDescriptionFactory;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderConfiguration;
import com.ibm.team.workitem.common.internal.model.Attachment;
import com.ibm.team.workitem.common.internal.model.Attribute;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemTypeManager;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentationManager;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveResultDTO;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.DataQueryIterator;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.PermissionContext;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.internal.util.TimeoutCacheHelper;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowManager;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.AttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkItemCommon
implements IWorkItemCommon {
    public static final String WORK_ITEM_SAVE_OPERATION_ID = "com.ibm.team.workitem.operation.workItemSave";
    public static final String CATEGORY_SAVE_OPERATION_ID = "com.ibm.team.workitem.server.saveCategory";
    public static final String DELIVERABLE_SAVE_OPERATION_ID = "com.ibm.team.workitem.server.saveDeliverable";
    public static final String ATTACHMENT_SAVE_OPERATION_ID = "com.ibm.team.workitem.server.saveAttachment";
    private static final String HIERARCHICAL_NAME_DELIMITER = "/";
    private ICommonServiceContext fServiceContext;
    private IAuditableCommon fAuditableCommon;
    private WorkItemTypeManager fWorkItemTypeManager;
    private EnumerationManager fEnumerationManager;
    private ProcessAreaCacheManager fProcessAreaManager;
    private RequiredPropertiesManager fRequiredProperitesManager;
    private EditorPresentationManager fEditorPresentationManager;
    private QuickInformationConfigurationManager fQuickInfomationConfigurationManager;
    private WorkflowManager fWorkflowManager;
    private ProcessConfigurationManager fProcessConfigurationManager;
    private AttributeCache fAttributeCache;
    private AuditableCache.ScopedItemTypeCache<ICategory> fCategoryCache;
    private AuditableCache.ScopedItemTypeCache<IDeliverable> fDeliverableCache;
    private TimeoutCacheHelper<String, Boolean> fProjectMemberCache = new TimeoutCacheHelper();
    private TimeoutCacheHelper<IAttribute, Set<String>> fTagsCache = new TimeoutCacheHelper();
    private Map<UUID, List<IAttributeHandle>> fBuiltInAttributeCache = new HashMap<UUID, List<IAttributeHandle>>();
    private Map<UUID, ICategoryHandle> fRootCategoryCache = new HashMap<UUID, ICategoryHandle>();
    private Boolean fAdditionalSaveParametersSupportCache = null;

    public WorkItemCommon(ICommonServiceContext serviceContext) {
        this.fServiceContext = serviceContext;
        this.fAuditableCommon = serviceContext.getService(IAuditableCommon.class).getPeer(IAuditableCommon.class);
        this.fWorkItemTypeManager = new WorkItemTypeManager(this.fAuditableCommon);
        this.fEnumerationManager = new EnumerationManager(this.fAuditableCommon);
        this.fProcessAreaManager = new ProcessAreaCacheManager(this.fAuditableCommon);
        this.fRequiredProperitesManager = new RequiredPropertiesManager(this.fAuditableCommon);
        this.fEditorPresentationManager = new EditorPresentationManager(this.fAuditableCommon);
        this.fQuickInfomationConfigurationManager = new QuickInformationConfigurationManager(this.fAuditableCommon);
        this.fWorkflowManager = new WorkflowManager(this.fAuditableCommon);
        this.fProcessConfigurationManager = new ProcessConfigurationManager(this.fAuditableCommon);
        this.fAttributeCache = new AttributeCache(this.fAuditableCommon);
        this.fCategoryCache = new AuditableCache.ScopedItemTypeCache(ICategory.ITEM_TYPE, ICategory.PROJECT_AREA_PROPERTY);
        this.fDeliverableCache = new AuditableCache.ScopedItemTypeCache(IDeliverable.ITEM_TYPE, IDeliverable.PROJECT_AREA_PROPERTY);
        ((AuditableCommon)this.fAuditableCommon).addItemTypeCache(ICategory.ITEM_TYPE, this.fCategoryCache);
        ((AuditableCommon)this.fAuditableCommon).addItemTypeCache(IDeliverable.ITEM_TYPE, this.fDeliverableCache);
        ((AuditableCommon)this.fAuditableCommon).addItemTypeCache(IAttribute.ITEM_TYPE, this.fAttributeCache.getCache());
    }

    public ProviderConfiguration getProviderConfiguration(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fWorkItemTypeManager.getProviderConfiguration(attribute, monitor);
    }

    protected ICommonServiceContext getServiceContext() {
        return this.fServiceContext;
    }

    public IWorkItem createWorkItem2(IWorkItemType workItemType) throws TeamRepositoryException {
        return this.createWorkItem(workItemType, null);
    }

    public IWorkItem createWorkItem(IWorkItemType workItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItem workItem = (WorkItem)this.fAuditableCommon.createAuditable(IWorkItem.ITEM_TYPE);
        workItem.setProjectArea(workItemType.getProjectArea());
        workItem.setWorkItemType(workItemType.getIdentifier());
        PermissionContext.setDefault((IItem)workItem);
        ArrayList<IAttributeHandle> handles = new ArrayList<IAttributeHandle>();
        handles.addAll(this.findBuiltInAttributes(workItemType.getProjectArea(), monitor));
        handles.addAll(workItemType.getCustomAttributes());
        List<IAttribute> attributes = this.fAuditableCommon.resolveAuditablesPermissionAware(handles, IAttribute.FULL_PROFILE, monitor);
        for (IAttribute attribute : attributes) {
            if (IWorkItem.PROJECT_AREA_PROPERTY.equals(attribute.getIdentifier()) || IWorkItem.TYPE_PROPERTY.equals(attribute.getIdentifier()) || IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY.equals(attribute.getIdentifier()) || IWorkItem.ID_PROPERTY.equals(attribute.getIdentifier())) continue;
            if (!workItem.hasAttribute(attribute)) {
                workItem.addCustomAttribute(attribute);
            }
            Object defaultValue = attribute.getDefaultValue(this.fAuditableCommon, workItem, monitor);
            EStructuralFeature feature = ModelPackage.eINSTANCE.getWorkItem().getEStructuralFeature(attribute.getIdentifier());
            if (defaultValue == null && feature != null && feature.isMany()) continue;
            workItem.setValue(attribute, defaultValue);
        }
        workItem.setCreator(this.fAuditableCommon.getUser());
        workItem.setModified(new Timestamp(System.currentTimeMillis()));
        return workItem;
    }

    @Override
    public IWorkItem findWorkItemById(int id, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            URI uri = ItemURI.createWorkItemURI(this.getAuditableCommon(), id);
            return this.getAuditableCommon().resolveAuditableByLocation(Location.location((URI)uri), profile, monitor);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return null;
        }
    }

    @Override
    public IAttachment findAttachmentById(int id, ItemProfile<IAttachment> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        URI uri = ItemURI.createAttachmentURI(this.getAuditableCommon(), id);
        return this.getAuditableCommon().resolveAuditableByLocation(Location.location((URI)uri), profile, monitor);
    }

    @Override
    public List<IWorkItemHandle> findWorkItemsById(List<Integer> ids, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemQueryIterator<IWorkItemHandle> iter = WorkItemQueries.workItemsById(this.getAuditableCommon(), ids);
        return iter.toList(monitor);
    }

    @Override
    public boolean updateWorkItemType(IWorkItem workItem, IWorkItemType newType, IWorkItemType oldType, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute;
        Assert.isTrue((boolean)workItem.isWorkingCopy());
        ((WorkItem)workItem).setWorkItemType(newType.getIdentifier());
        boolean changed = false;
        ItemHandleAwareHashSet<IAttributeHandle> customAttributes = new ItemHandleAwareHashSet<IAttributeHandle>(newType.getCustomAttributes());
        for (IAttributeHandle customAttribute : customAttributes) {
            attribute = this.fAuditableCommon.resolveAuditable(customAttribute, IAttribute.FULL_PROFILE, monitor);
            if (workItem.hasAttribute(attribute)) continue;
            workItem.addCustomAttribute(attribute);
            workItem.setValue(attribute, attribute.getDefaultValue(this.fAuditableCommon, workItem, monitor));
            changed = true;
        }
        if (oldType != null) {
            for (IAttributeHandle customAttribute : oldType.getCustomAttributes()) {
                if (customAttributes.contains(customAttribute) || !workItem.hasCustomAttribute(customAttribute)) continue;
                attribute = this.fAuditableCommon.resolveAuditable(customAttribute, IAttribute.FULL_PROFILE, monitor);
                workItem.removeCustomAttribute(attribute);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    @Deprecated
    public void changeWorkItemType(IWorkItem workItem, IWorkItemType type, IProgressMonitor monitor) throws TeamRepositoryException {
        this.updateWorkItemType(workItem, type, null, monitor);
    }

    @Override
    public IAttribute createAttribute(IProjectAreaHandle projectArea, String identifier, String attributeType, String displayName, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute = this.createNewAttribute(projectArea, identifier, attributeType, null, monitor);
        attribute.setDisplayName(displayName);
        return this.saveAttribute(attribute, monitor);
    }

    @Override
    public IAttribute createNewAttribute(IProjectAreaHandle projectArea, String identifier, String attributeType, String fullTextKind, IProgressMonitor monitor) throws TeamRepositoryException {
        AttributeType type = AttributeTypes.getAttributeType(attributeType);
        Attribute attribute = (Attribute)this.getAuditableCommon().createAuditable(IAttribute.ITEM_TYPE);
        attribute.setProjectArea(projectArea);
        attribute.setAttributeType(attributeType);
        attribute.setIdentifier(identifier);
        attribute.setFullTextKind(fullTextKind != IAttribute.FULL_TEXT_KIND_DEFAULT ? fullTextKind : type.getDefaultFullTextKind());
        PermissionContext.setDefault((IItem)attribute);
        return attribute;
    }

    @Override
    public IAttribute saveAttribute(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.saveAuditable(Messages.getString("WorkItemCommon.SAVE_ATTRIBUTE"), attribute, monitor);
    }

    @Override
    public IAttribute findAttribute(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        if (IWorkItem.WORKFLOW_SURROGATE_PROPERTY.equals(identifier)) {
            return null;
        }
        return this.fAttributeCache.findAttribute(projectArea, identifier, monitor);
    }

    @Override
    public List<IAttributeHandle> findBuiltInAttributes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.fBuiltInAttributeCache.containsKey(projectArea.getItemId())) {
            ArrayList<Object> attributes = new ArrayList();
            List<IAttribute> cached = this.getAuditableCommon().findAllCachedAuditables(IAttribute.FULL_PROFILE);
            for (IAttribute attribute : cached) {
                if (!attribute.getProjectArea().sameItemId((IItemHandle)projectArea) || !AttributeIdentifiers.ATTRIBUTE_LIST.contains(attribute.getIdentifier())) continue;
                attributes.add((IAttributeHandle)attribute.getItemHandle());
            }
            if (attributes.size() != AttributeIdentifiers.ATTRIBUTES.length) {
                attributes = new ArrayList(WorkItemQueries.builtInAttributes(this.getAuditableCommon(), projectArea).toList(monitor));
            }
            if (attributes.size() != AttributeIdentifiers.ATTRIBUTES.length) {
                this.createBuiltInAttributes(projectArea, monitor);
                attributes = new ArrayList(WorkItemQueries.builtInAttributes(this.getAuditableCommon(), projectArea).toList(monitor));
            }
            Assert.isTrue((attributes.size() == AttributeIdentifiers.ATTRIBUTES.length ? 1 : 0) != 0);
            this.fBuiltInAttributeCache.put(projectArea.getItemId(), attributes);
        }
        return this.fBuiltInAttributeCache.get(projectArea.getItemId());
    }

    @Override
    public List<IAttribute> findAttributes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fAttributeCache.findAttributes(projectArea, monitor);
    }

    public List findWorkItemTypes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fWorkItemTypeManager.findConfigurationItems(projectArea, monitor);
    }

    public List findCachedWorkItemTypes(IProjectAreaHandle projectArea) {
        return this.fWorkItemTypeManager.findCachedConfigurationItems(projectArea);
    }

    @Override
    public IWorkItemType findWorkItemType(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fWorkItemTypeManager.findConfigurationItem(projectArea, identifier, monitor);
    }

    @Override
    public IWorkItemType findCachedWorkItemType(IProjectAreaHandle projectArea, String identifier) {
        return this.fWorkItemTypeManager.findCachedConfigurationItem(projectArea, identifier);
    }

    public String[] findAvailableWorkItemTypes(final IProcessAreaHandle processArea, final String oldWorkflowId, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<String[]> runnable = new ServiceRunnable<String[]>(){

            @Override
            public String[] run() throws TeamRepositoryException {
                IWorkItemRepositoryService repositoryService = WorkItemCommon.this.getServiceContext().getService(IWorkItemRepositoryService.class);
                return repositoryService.findAvailableWorkItemTypes(processArea, oldWorkflowId);
            }
        };
        return this.getServiceContext().callCancelableService(runnable, monitor);
    }

    @Override
    public List findPriorities(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnumeration<?> enumeration = this.resolveEnumeration(this.findAttribute(projectArea, IWorkItem.PRIORITY_PROPERTY, monitor), monitor);
        return enumeration.getEnumerationLiterals();
    }

    @Override
    public List findSeverities(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnumeration<?> enumeration = this.resolveEnumeration(this.findAttribute(projectArea, IWorkItem.SEVERITY_PROPERTY, monitor), monitor);
        return enumeration.getEnumerationLiterals();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<ICategory> findCategories(IProjectAreaHandle projectArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!profile.contains(ICategory.ARCHIVED_PROPERTY)) {
            profile = profile.createExtension(new String[]{ICategory.ARCHIVED_PROPERTY});
        }
        if (!profile.contains(ICategory.CATEGORY_ID)) {
            profile = profile.createExtension(new String[]{ICategory.CATEGORY_ID});
        }
        all = this.findAllCategories(projectArea, profile, monitor);
        Collections.sort(all, new Comparator<ICategory>(){

            @Override
            public int compare(ICategory o1, ICategory o2) {
                return o1.getCategoryId().compareTo(o2.getCategoryId());
            }
        });
        active = new ArrayList<ICategory>();
        parentId = "/";
        iter = all.iterator();
        while (iter.hasNext()) {
            current = iter.next();
            categoryId = current.getCategoryId();
            if (!CategoriesHelper.isRootCategoryId(categoryId) && !categoryId.getInternalRepresentation().equals(parentId)) ** GOTO lbl22
            continue;
lbl-1000:
            // 1 sources

            {
                filtered = current;
                current = iter.next();
                while (this.isSubcategory(filtered, current) && iter.hasNext()) {
                    current = iter.next();
                }
                if (!this.isSubcategory(filtered, current)) continue;
                current = null;
lbl22:
                // 3 sources

                ** while (current != null && current.isArchived() && iter.hasNext())
            }
lbl23:
            // 1 sources

            if (current == null || current.isArchived()) continue;
            parentId = categoryId.getInternalRepresentation();
            active.add(current);
        }
        return active;
    }

    public List<ICategory> findAllCategories(IProjectAreaHandle projectArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ICategory> all = this.findAllCachedCategories(projectArea, profile);
        if (all == null) {
            List<ICategoryHandle> handles = CategoriesHelper.findExistingCategories(this.fAuditableCommon, projectArea, monitor);
            all = this.fAuditableCommon.resolveAuditablesPermissionAware(handles, profile, monitor);
            this.fCategoryCache.cacheAll((IAuditableHandle)projectArea, all, profile);
        }
        return all;
    }

    public List<ICategory> findAllCachedCategories(IProjectAreaHandle projectArea, ItemProfile<ICategory> profile) {
        return this.fCategoryCache.getAll((IAuditableHandle)projectArea, profile);
    }

    private boolean isSubcategory(ICategory parent, ICategory child) {
        return child.getCategoryId().getInternalRepresentation().startsWith(parent.getCategoryId().getInternalRepresentation());
    }

    @Override
    public List findIntervals(IProjectAreaHandle projectArea, IDevelopmentLine developmentLine, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        if (developmentLine != null) {
            return IterationsHelper.findIterations(this.fAuditableCommon, (IDevelopmentLineHandle)developmentLine, (ItemProfile<IIteration>)profile, false, monitor);
        }
        return IterationsHelper.findIterations(this.fAuditableCommon, projectArea, (ItemProfile<IIteration>)profile, false, monitor);
    }

    public IEnumeration<?> resolveEnumeration(IAttributeHandle attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fEnumerationManager.resolve(attribute, monitor);
    }

    public IEnumeration<?> internalResolveEnumeration(IProjectAreaHandle projectArea, String attributeType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fEnumerationManager.internalResolve(projectArea, attributeType, monitor);
    }

    @Override
    public IEnumeration<? extends ILiteral> findCachedEnumeration(IAttribute attribute) {
        return this.fEnumerationManager.findCached(attribute);
    }

    public IEnumeration<? extends ILiteral> findCachedEnumeration(IProjectAreaHandle projectArea, String attributeType) {
        return this.fEnumerationManager.internalFindChached(projectArea, attributeType);
    }

    public EditorPresentation getEditorPresentation(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getEditorPresentation(null, workItem, monitor);
    }

    public EditorPresentation getEditorPresentation(String target, IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        EditorPresentation presentation = new EditorPresentation(target, workItem);
        presentation.resolve(this.fEditorPresentationManager, monitor);
        return presentation;
    }

    public QuickInformationConfigurationManager getQuickInformationConfigurationManager() {
        return this.fQuickInfomationConfigurationManager;
    }

    @Override
    public List<String> findRequiredProperties(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fRequiredProperitesManager.findRequiredProperties(workItem, monitor);
    }

    @Override
    public List<String> findRequiredWorkflowProperties(IWorkItem workItem, String stateId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fRequiredProperitesManager.findRequiredWorkflowProperties(workItem, stateId, monitor);
    }

    @Override
    public IDeliverable findDeliverableByName(IProjectAreaHandle projectArea, String name, ItemProfile<IDeliverable> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemQueryIterator<IDeliverableHandle> iter;
        List<IDeliverable> all = this.fDeliverableCache.getAll((IAuditableHandle)projectArea, profile.createExtension(IDeliverable.NAME_PROPERTY));
        if (all != null) {
            for (IDeliverable deliverable : all) {
                if (!deliverable.getName().equals(name)) continue;
                return deliverable;
            }
        }
        if (!(iter = WorkItemQueries.deliverableByName(this.fAuditableCommon, projectArea, name)).hasNext(monitor)) {
            return null;
        }
        return this.fAuditableCommon.resolveAuditable(iter.next(monitor), profile, monitor);
    }

    @Override
    public List<IDeliverable> findDeliverablesByProjectArea(IProjectAreaHandle projectArea, boolean includeArchived, ItemProfile<IDeliverable> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findDeliverablesByProjectArea(projectArea, includeArchived, profile, false, monitor);
    }

    public List<IDeliverable> findDeliverablesByProjectArea(IProjectAreaHandle projectArea, boolean includeArchived, ItemProfile<IDeliverable> profile, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IDeliverable> deliverables = this.fDeliverableCache.getAll((IAuditableHandle)projectArea, profile = profile.createExtension(IDeliverable.ARCHIVED_PROPERTY));
        if (deliverables == null || refresh) {
            List handles = WorkItemQueries.deliverableByProjectArea(this.fAuditableCommon, projectArea).toList(monitor);
            deliverables = new ArrayList<IDeliverable>(this.fAuditableCommon.resolveAuditablesPermissionAware(handles, profile, monitor));
            int i = 0;
            while (i < handles.size()) {
                IDeliverableHandle handle = (IDeliverableHandle)handles.get(i);
                IDeliverable deliverable = deliverables.get(i);
                if (handle.getStateId() != null && !deliverable.sameStateId((IItemHandle)handle)) {
                    deliverables.set(i, ((AuditableCommon)this.fAuditableCommon).fetchCurrentAuditable(handle, profile, monitor));
                }
                ++i;
            }
            this.fDeliverableCache.cacheAll((IAuditableHandle)projectArea, deliverables, profile);
        }
        if (!includeArchived) {
            deliverables = new ArrayList<IDeliverable>(deliverables);
            Iterator<IDeliverable> iter = deliverables.iterator();
            while (iter.hasNext()) {
                if (!iter.next().isArchived()) continue;
                iter.remove();
            }
        }
        return deliverables;
    }

    @Override
    public List<IDeliverable> findDeliverablesByArtifact(IItemHandle artifact, ItemProfile<IDeliverable> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        List handles = WorkItemQueries.deliverableByArtifact(this.fAuditableCommon, artifact).toList(monitor);
        return new ArrayList<IDeliverable>(this.fAuditableCommon.resolveAuditables(handles, profile, monitor));
    }

    public List<IDeliverable> findVisibleDeliverablesByProjectArea(IProjectAreaHandle projectArea, boolean includeArchived, ItemProfile<IDeliverable> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle user = this.fAuditableCommon.getUser();
        if (user != null && this.isProjectMember(projectArea, user, monitor)) {
            return this.findDeliverablesByProjectArea(projectArea, includeArchived, profile, monitor);
        }
        profile = profile.createExtension(IDeliverable.FILTERED_PROPERTY);
        ArrayList<IDeliverable> deliverables = new ArrayList<IDeliverable>(this.findDeliverablesByProjectArea(projectArea, includeArchived, profile, monitor));
        Iterator iter = deliverables.iterator();
        while (iter.hasNext()) {
            if (!((IDeliverable)iter.next()).isFiltered()) continue;
            iter.remove();
        }
        return deliverables;
    }

    private boolean isProjectMember(IProjectAreaHandle projectArea, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean result;
        String key = this.getProjectMemberKey(projectArea, contributor);
        Boolean isMember = this.fProjectMemberCache.get(key);
        if (isMember != null) {
            return isMember;
        }
        DataQueryIterator<Integer> iter = WorkItemQueries.teamAreaMemberCount(this.fAuditableCommon, projectArea, contributor);
        boolean bl = result = iter.next(monitor) > 0;
        if (!result) {
            String membersProperty = ProcessCommon.getPropertyName(IProjectArea.class, (String)"teamMembers");
            IProjectArea resolved = (IProjectArea)this.fAuditableCommon.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.createProfile(IProjectArea.ITEM_TYPE, membersProperty), monitor);
            result = this.contains((IItemHandle[])resolved.getMembers(), (IItemHandle)contributor);
        }
        this.fProjectMemberCache.put(key, result);
        return result;
    }

    private boolean contains(IItemHandle[] handles, IItemHandle handle) {
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle current = iItemHandleArray[n2];
            if (current.sameItemId(handle)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getProjectMemberKey(IProjectAreaHandle projectArea, IContributorHandle contributor) {
        return String.valueOf(projectArea.getItemId().getUuidValue()) + contributor.getItemId().getUuidValue();
    }

    @Override
    public IDeliverable createDeliverable(IProjectAreaHandle projectArea, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        Deliverable version = (Deliverable)this.findDeliverableByName(projectArea, name, IDeliverable.FULL_PROFILE, monitor);
        if (version != null) {
            version = (Deliverable)version.getWorkingCopy();
            version.setArchived(false);
            return version;
        }
        version = (Deliverable)this.fAuditableCommon.createAuditable(IDeliverable.ITEM_TYPE);
        version.setProjectArea(projectArea);
        version.setName(name);
        PermissionContext.setDefault((IItem)version);
        return version;
    }

    @Override
    public IDeliverable saveDeliverable(IDeliverable deliverable, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.saveAuditable(Messages.getString("WorkItemCommon.SAVE_RELEASE"), deliverable, monitor);
    }

    @Override
    public List<IDeliverable> saveDeliverables(List<IDeliverable> deliverables, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.saveAuditables(Messages.getString("WorkItemCommon.SAVE_RELEASE"), deliverables, monitor).subList(0, deliverables.size());
    }

    @Override
    public IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }

    protected WorkItemTypeManager getWorkItemTypeManager() {
        return this.fWorkItemTypeManager;
    }

    public abstract <T> T getService(Class<T> var1);

    @Override
    public ICategory createCategory(IProjectAreaHandle projectArea, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)projectArea);
        Assert.isNotNull((Object)name);
        Assert.isTrue((name.trim().length() > 0 ? 1 : 0) != 0);
        ICategory rootCategory = this.findRootCategory(projectArea, ICategory.FULL_PROFILE, monitor);
        CategoryId categoryId = CategoriesHelper.createCategoryId(rootCategory, name);
        ItemQueryIterator<ICategoryHandle> iter = WorkItemQueries.categoryByIdentifier(this.fAuditableCommon, projectArea, categoryId);
        if (!iter.hasNext(monitor)) {
            return CategoriesHelper.createCategory(this.fAuditableCommon, rootCategory, name);
        }
        return (ICategory)this.fAuditableCommon.resolveAuditable(iter.next(monitor), ICategory.FULL_PROFILE, monitor).getWorkingCopy();
    }

    @Override
    public ICategory createSubcategory(ICategoryHandle parent, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)name);
        Assert.isTrue((name.trim().length() > 0 ? 1 : 0) != 0);
        ICategory parentCategory = this.fAuditableCommon.resolveAuditable(parent, ICategory.FULL_PROFILE, monitor);
        CategoryId categoryId = CategoriesHelper.createCategoryId(parentCategory.getCategoryId(), name);
        ItemQueryIterator<ICategoryHandle> iter = WorkItemQueries.categoryByIdentifier(this.fAuditableCommon, parentCategory.getProjectArea(), categoryId);
        if (!iter.hasNext(monitor)) {
            return CategoriesHelper.createCategory(this.fAuditableCommon, parentCategory, name);
        }
        return (ICategory)this.fAuditableCommon.resolveAuditable(iter.next(monitor), ICategory.FULL_PROFILE, monitor).getWorkingCopy();
    }

    @Override
    public ICategory saveCategory(ICategory category, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.saveAuditable(Messages.getString("WorkItemCommon.SAVE_CATEGORY"), category, monitor);
    }

    public List<ICategory> saveCategories(List<ICategory> categories, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.saveAuditables(Messages.getString("WorkItemCommon.SAVE_CATEGORY"), categories, monitor).subList(0, categories.size());
    }

    @Override
    public ICategory findUnassignedCategory(IProjectAreaHandle projectArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findRootCategory(projectArea, profile, monitor);
    }

    public ICategory findRootCategory(IProjectAreaHandle projectArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory cached = this.findCachedUnassignedCategory(projectArea, profile);
        if (cached != null) {
            return cached;
        }
        ICategoryHandle rootCategoryHandle = this.fRootCategoryCache.get(projectArea.getItemId());
        if (rootCategoryHandle == null) {
            ItemQueryIterator<ICategoryHandle> iter = WorkItemQueries.rootCategory(this.fAuditableCommon, projectArea);
            if (!iter.hasNext(monitor)) {
                IProjectArea item = (IProjectArea)this.fAuditableCommon.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
                Assert.isTrue((!item.isInitialized() ? 1 : 0) != 0);
                throw new TeamFoundationException(WorkItemExceptionDescriptionFactory.createProjectAreaNotInitializedDescriptor());
            }
            rootCategoryHandle = iter.next(monitor);
            this.fRootCategoryCache.put(projectArea.getItemId(), rootCategoryHandle);
        }
        return this.fAuditableCommon.resolveAuditable(rootCategoryHandle, profile, monitor);
    }

    @Override
    public ICategory findCachedUnassignedCategory(IProjectAreaHandle projectArea, ItemProfile<ICategory> profile) {
        profile = profile.createExtension(ICategory.PROJECT_AREA_PROPERTY, ICategory.CATEGORY_ID);
        List<ICategory> cached = this.fAuditableCommon.findAllCachedAuditables(profile);
        for (ICategory cache : cached) {
            if (!projectArea.sameItemId((IItemHandle)cache.getProjectArea()) || !CategoriesHelper.isRootCategoryId(cache.getCategoryId())) continue;
            return cache;
        }
        return null;
    }

    @Override
    public ICategoryHandle findCategoryById2(IProjectAreaHandle projectArea, CategoryId identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemQueryIterator<ICategoryHandle> iter = WorkItemQueries.categoryByIdentifier(this.fAuditableCommon, projectArea, identifier);
        if (!iter.hasNext(null)) {
            return null;
        }
        return iter.next(null);
    }

    @Override
    public ICategoryHandle findCategoryByNamePath(IProjectAreaHandle projectArea, List<String> namePath, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory rootCategory = this.findRootCategory(projectArea, ICategory.FULL_PROFILE, monitor);
        CategoryId identifier = CategoriesHelper.createCategoryId(rootCategory, namePath.toArray(new String[namePath.size()]));
        return this.findCategoryById2(projectArea, identifier, monitor);
    }

    @Override
    public List<ICategory> findCategoriesOfProcessArea(IProcessAreaHandle processArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemQueryIterator<ICategoryHandle> iter = WorkItemQueries.categoriesByProcessArea(this.fAuditableCommon, processArea);
        return this.fAuditableCommon.resolveAuditablesPermissionAware(iter.toList(monitor), profile, monitor);
    }

    @Override
    public List<ICategory> findCategoriesOfTeamArea2(ITeamAreaHandle teamArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findCategoriesOfProcessArea((IProcessAreaHandle)teamArea, profile, monitor);
    }

    @Override
    public List<ICategory> findCategoriesOfTeamArea(ITeamAreaHandle teamArea, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        profile = profile.createExtension(ICategory.CATEGORY_ID);
        ArrayList<ICategory> categories = new ArrayList<ICategory>(this.findCategoriesOfProcessArea((IProcessAreaHandle)teamArea, profile, monitor));
        Iterator cat = categories.iterator();
        while (cat.hasNext()) {
            if (!((ICategory)cat.next()).isUnassigned()) continue;
            cat.remove();
        }
        return categories;
    }

    @Override
    public IProcessAreaHandle findProcessArea(IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem workItem;
        IProjectAreaHandle projectArea = null;
        IIterationHandle target = null;
        ICategoryHandle category = null;
        boolean projectAreaSet = false;
        boolean targetSet = false;
        boolean categorySet = false;
        if (handle instanceof IWorkItem) {
            workItem = (IWorkItem)handle;
            if (workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY)) {
                projectArea = workItem.getProjectArea();
                projectAreaSet = true;
            }
            if (workItem.isPropertySet(IWorkItem.TARGET_PROPERTY)) {
                target = workItem.getTarget();
                targetSet = true;
            }
            if (workItem.isPropertySet(IWorkItem.CATEGORY_PROPERTY)) {
                category = workItem.getCategory();
                categorySet = true;
            }
        }
        if (!(projectAreaSet && targetSet && categorySet)) {
            workItem = this.fAuditableCommon.resolveAuditable(handle, IWorkItem.SMALL_PROFILE.createExtension(Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.CATEGORY_PROPERTY)), monitor);
            if (!projectAreaSet) {
                projectArea = workItem.getProjectArea();
            }
            if (!targetSet) {
                target = workItem.getTarget();
            }
            if (!categorySet) {
                category = workItem.getCategory();
            }
        }
        return this.fProcessAreaManager.findProcessArea(projectArea, target, category, monitor);
    }

    public ITeamAreaHandle findTeamArea(ICategoryHandle category, IIterationHandle target, IProgressMonitor monitor) throws TeamRepositoryException {
        if (category == null) {
            return null;
        }
        IProjectAreaHandle projectArea = this.fAuditableCommon.resolveAuditable(category, ICategory.SMALL_PROFILE, monitor).getProjectArea();
        IProcessAreaHandle processArea = this.fProcessAreaManager.findProcessArea(projectArea, target, category, monitor);
        if (processArea instanceof ITeamAreaHandle) {
            return (ITeamAreaHandle)processArea;
        }
        return null;
    }

    @Deprecated
    public IDevelopmentLine findDevelopmentLine(IProjectAreaHandle area, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAuditableCommon().findDefaultDevelopmentLine(area, monitor);
    }

    @Deprecated
    public IDevelopmentLine findDevelopmentLine(ITeamAreaHandle area, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAuditableCommon().getDevelopmentLine(area, monitor);
    }

    @Deprecated
    public IDevelopmentLine findDevelopmentLine(IProcessAreaHandle area, IProgressMonitor monitor) throws TeamRepositoryException {
        if (area instanceof ITeamAreaHandle) {
            return this.getAuditableCommon().getDevelopmentLine((ITeamAreaHandle)area, monitor);
        }
        if (area instanceof IProjectAreaHandle) {
            return this.getAuditableCommon().findDefaultDevelopmentLine((IProjectAreaHandle)area, monitor);
        }
        return null;
    }

    @Deprecated
    public static IDevelopmentLine findDevelopmentLine(IAuditableCommonProcess process, IProjectAreaHandle area, IProgressMonitor monitor) throws TeamRepositoryException {
        return process.getAuditableCommon().findDefaultDevelopmentLine(area, monitor);
    }

    @Override
    public ICategoryHandle guessCategory(final IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<ICategoryHandle>(){

            @Override
            public ICategoryHandle run() throws TeamRepositoryException {
                IComment[] comments;
                IWorkItemRepositoryService service = WorkItemCommon.this.getService(IWorkItemRepositoryService.class);
                StringBuilder content = new StringBuilder();
                content.append(item.getHTMLDescription().getPlainText());
                IComment[] iCommentArray = comments = item.getComments().getContents();
                int n = comments.length;
                int n2 = 0;
                while (n2 < n) {
                    IComment comment = iCommentArray[n2];
                    content.append("\n").append(comment.getHTMLContent().getPlainText());
                    ++n2;
                }
                return service.guessCategory(item.getProjectArea(), item, item.getHTMLSummary().getPlainText(), content.toString());
            }
        }, monitor);
    }

    @Override
    public String resolveHierarchicalName(ICategoryHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory category = this.fAuditableCommon.resolveAuditable(handle, ICategory.SMALL_PROFILE, monitor);
        return category.getHierarchicalName();
    }

    @Override
    public void setDefaultTeamArea(ITeamAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamArea teamArea = this.fAuditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        CategoriesManager manager = CategoriesManager.createInstance(this.fAuditableCommon, teamArea.getProjectArea(), monitor);
        manager.getRoot().setDefaultTeamArea((ITeamAreaHandle)teamArea);
        manager.save(monitor);
    }

    @Override
    public IAttachment createAttachment(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        Attachment attachment = (Attachment)this.fAuditableCommon.createAuditable(IAttachment.ITEM_TYPE);
        attachment.setProjectArea(projectArea);
        PermissionContext.setDefault((IItem)attachment);
        return attachment;
    }

    @Override
    public IAttachment saveAttachment(IAttachment attachment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.saveAuditable(Messages.getString("WorkItemCommon.SAVE_ATTACHMENT"), attachment, monitor);
    }

    public IAttachment saveAttachment(IAttachment attachment, ITeamAreaHandle teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            List<IAttachment> savedStates = this.internalSaveAuditables(Messages.getString("WorkItemCommon.SAVE_ATTACHMENT"), Collections.singletonList(attachment), teamArea, monitor);
            return ((AuditableCommon)this.getAuditableCommon()).update(savedStates, monitor).get(0);
        }
        catch (MultiStaleDataException x) {
            throw new StaleDataException(x.getOrigin(), x.getMessage(), (Throwable)((Object)x));
        }
    }

    @Override
    public long fetchMaxAttachmentSize(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<Long>(){

            @Override
            public Long run() throws TeamRepositoryException {
                IWorkItemRepositoryService workItemService = WorkItemCommon.this.getService(IWorkItemRepositoryService.class);
                return workItemService.fetchMaxAttachmentSize();
            }
        }, monitor);
    }

    @Override
    public int findMaxWorkItemId(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<Integer>(){

            @Override
            public Integer run() throws TeamRepositoryException {
                IWorkItemRepositoryService workItemService = WorkItemCommon.this.getService(IWorkItemRepositoryService.class);
                return workItemService.findMaxWorkItemId();
            }
        }, monitor);
    }

    @Override
    public int findMaxAttachmentId(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<Integer>(){

            @Override
            public Integer run() throws TeamRepositoryException {
                IWorkItemRepositoryService workItemService = WorkItemCommon.this.getService(IWorkItemRepositoryService.class);
                return workItemService.findMaxAttachmentId();
            }
        }, monitor);
    }

    public boolean allowProcessScripts(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<Boolean>(){

            @Override
            public Boolean run() throws TeamRepositoryException {
                IWorkItemRepositoryService workItemService = WorkItemCommon.this.getService(IWorkItemRepositoryService.class);
                try {
                    return workItemService.allowProcessScripts();
                }
                catch (ServiceNotAvailableException serviceNotAvailableException) {
                    return false;
                }
            }
        }, monitor);
    }

    public void createBuiltInAttributes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        String identifier;
        AttributeDescriptor descriptor;
        AttributeDescriptor[] descriptors;
        ArrayList handles = new ArrayList(WorkItemQueries.builtInAttributes(this.getAuditableCommon(), projectArea).toList(monitor));
        List<IAttribute> attributes = this.getAuditableCommon().resolveAuditablesPermissionAware(handles, IAttribute.SMALL_PROFILE, monitor);
        LocalizationContext context = LocalizationContext.createProjectAreaContext(this.fAuditableCommon, projectArea, monitor);
        HashMap<String, IAttribute> existing = new HashMap<String, IAttribute>();
        for (IAttribute attribute : attributes) {
            existing.put(attribute.getIdentifier(), attribute);
        }
        HashMap<String, IAttribute> all = new HashMap<String, IAttribute>();
        AttributeDescriptor[] attributeDescriptorArray = descriptors = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            descriptor = attributeDescriptorArray[n2];
            identifier = descriptor.getIdentifier();
            if (existing.containsKey(identifier)) {
                all.put(identifier, (IAttribute)existing.get(identifier));
            } else {
                all.put(identifier, this.createNewAttribute(projectArea, descriptor, context, monitor));
            }
            ++n2;
        }
        attributeDescriptorArray = descriptors;
        n = descriptors.length;
        n2 = 0;
        while (n2 < n) {
            descriptor = attributeDescriptorArray[n2];
            identifier = descriptor.getIdentifier();
            if (!existing.containsKey(identifier)) {
                IAttribute attribute = (IAttribute)all.get(identifier);
                String[] dependencies = descriptor.getDependencies();
                if (dependencies != null) {
                    List<IAttributeHandle> attributeDependencies = attribute.getDependencies();
                    int j = 0;
                    while (j < dependencies.length) {
                        attributeDependencies.add((IAttributeHandle)((IAttribute)all.get(dependencies[j])).getItemHandle());
                        ++j;
                    }
                }
                this.saveAttribute(attribute, monitor);
            }
            ++n2;
        }
    }

    private IAttribute createNewAttribute(IProjectAreaHandle projectArea, AttributeDescriptor descriptor, LocalizationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute = this.createNewAttribute(projectArea, descriptor.getIdentifier(), descriptor.getAttributeType(), descriptor.getFullTextKind(), monitor);
        ((Attribute)attribute).setBuiltIn(true);
        ((Attribute)attribute).setReadOnly(descriptor.isReadOnly());
        attribute.setInternal(descriptor.isInternal());
        attribute.setDisplayName(descriptor.getDisplayName(context));
        return attribute;
    }

    @Override
    public List<String> findTags(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute tagsAttribute = this.findAttribute(projectArea, IWorkItem.TAGS_PROPERTY, monitor);
        return this.findTags2(tagsAttribute, monitor);
    }

    @Override
    public List<String> findTags2(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isLegal((boolean)"tags".equals(attribute.getAttributeType()));
        Set<String> tags = this.fTagsCache.get(attribute);
        if (tags == null) {
            tags = new HashSet<String>();
            DataQueryIterator<String> iter = WorkItemQueries.distinctWorkItemTags(this.fAuditableCommon, attribute);
            while (iter.hasNext(monitor)) {
                SeparatedStringList.parse(tags, iter.next(monitor));
            }
            this.fTagsCache.put(attribute, tags);
        }
        return new ArrayList<String>(tags);
    }

    private <T extends IAuditable> void updateTags(List<T> auditables) {
        for (IAuditable auditable : auditables) {
            if (!(auditable instanceof IWorkItem)) continue;
            IWorkItem workItem = (IWorkItem)auditable;
            for (IAttribute tagAttribute : this.fTagsCache.getKeySet()) {
                Collection current;
                Set<String> cache;
                if (!workItem.isAttributeSet(tagAttribute) || (cache = this.fTagsCache.get(tagAttribute)) == null || cache.containsAll(current = (Collection)workItem.getValue(tagAttribute))) continue;
                HashSet<String> newTags = new HashSet<String>(cache);
                newTags.addAll(current);
                this.fTagsCache.put(tagAttribute, newTags);
            }
        }
    }

    public <T extends IAuditable> void update(List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fProcessAreaManager.update(auditables, monitor);
        this.updateTags(auditables);
    }

    @Override
    public IWorkflowInfo findWorkflowInfo(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fWorkflowManager.getWorkflowInfo(workItem, monitor);
    }

    public IWorkflowInfo findBoundWorkflowInfo(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fWorkflowManager.getBoundWorkflowInfo(workItem, monitor);
    }

    @Override
    public IWorkflowInfo findCachedWorkflowInfo(IWorkItem workItem) {
        return this.fWorkflowManager.getCachedWorkflowInfo(workItem);
    }

    @Override
    public ICombinedWorkflowInfos findCombinedWorkflowInfos(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fWorkflowManager.getCombinedWorkflowInfos(projectArea, monitor);
    }

    @Override
    public ICombinedWorkflowInfos findCachedCombinedWorkflowInfos(IProjectAreaHandle projectArea) {
        return this.fWorkflowManager.getCachedCombinedWorkflowInfos(projectArea);
    }

    @Override
    public IWorkflowManager getWorkflowManager() {
        return this.fWorkflowManager;
    }

    @Deprecated
    public boolean usesTimeRemaining(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fProcessConfigurationManager.usesTimeRemaining(projectAreaHandle, monitor);
    }

    public boolean usesHourOutputFormat(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fProcessConfigurationManager.usesHourOutputFormat(projectAreaHandle, monitor);
    }

    public IWorkItemConfiguration getWorkItemConfiguration() {
        return this.fProcessConfigurationManager;
    }

    private <T extends IAuditable> T saveAuditable(String operationName, T auditable, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            return this.saveAuditables(operationName, Collections.singletonList(auditable), monitor).get(0);
        }
        catch (MultiStaleDataException x) {
            throw new StaleDataException(x.getOrigin(), x.getMessage(), (Throwable)((Object)x));
        }
    }

    private <T extends IAuditable> List<T> saveAuditables(String operationName, List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        List<T> savedStates = this.internalSaveAuditables(operationName, auditables, monitor);
        return ((AuditableCommon)this.getAuditableCommon()).update(savedStates, monitor);
    }

    public <T extends IAuditable> List<T> internalSaveAuditables(String operationName, List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.internalSaveAuditables(operationName, auditables, null, monitor);
    }

    private <T extends IAuditable> List<T> internalSaveAuditables(String operationName, List<T> auditables, ITeamAreaHandle teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        MultiSaveParameterDTO multiSaveParameter = RcpFactory.eINSTANCE.createMultiSaveParameterDTO();
        Utils.setUserTimeZone(multiSaveParameter, TimeZone.getDefault());
        Utils.setImport(multiSaveParameter);
        Utils.setTeamArea(multiSaveParameter, teamArea);
        MultiSaveResultDTO multiSaveResult = null;
        try {
            for (IAuditable auditable : auditables) {
                multiSaveParameter.getSaveParameters().add(Utils.createSaveParameter(auditable, null, null, Collections.<String>emptySet()));
            }
            multiSaveResult = this.save(operationName, multiSaveParameter, monitor);
            if (multiSaveResult.isConflictingUpdate()) {
                IReconcileReport[] reports = multiSaveResult.getReconcileReports();
                ArrayList<IAuditable> incoming = new ArrayList<IAuditable>(reports.length);
                IReconcileReport[] iReconcileReportArray = reports;
                int n = reports.length;
                int n2 = 0;
                while (n2 < n) {
                    IReconcileReport report = iReconcileReportArray[n2];
                    incoming.add(report.getIncoming());
                    ++n2;
                }
                ((AuditableCommon)this.fAuditableCommon).update(incoming, monitor);
            }
            Utils.checkSaveResult(this.getAuditableCommon().getOrigin(), multiSaveResult);
            Utils.updateWorkingCopies(multiSaveParameter, multiSaveResult);
            ArrayList<IAuditable> savedStates = new ArrayList<IAuditable>();
            List saveResults = multiSaveResult.getSaveResults();
            for (SaveResultDTO saveResult : saveResults) {
                savedStates.add(saveResult.getUpdatedState());
            }
            ArrayList<IAuditable> arrayList = savedStates;
            return arrayList;
        }
        finally {
            if (multiSaveParameter != null) {
                Utils.detachItems((EObject)multiSaveParameter);
            }
            if (multiSaveResult != null) {
                Utils.detachItems((EObject)multiSaveResult);
            }
        }
    }

    protected abstract MultiSaveResultDTO save(String var1, MultiSaveParameterDTO var2, IProgressMonitor var3) throws TeamRepositoryException;

    public static String getSaveWorkItemName() {
        return Messages.getString("WorkItemCommon.SAVE_WORK_ITEM");
    }

    public URL resolveURL(URL url, IProgressMonitor monitor) throws TeamRepositoryException {
        return url;
    }

    public void rollbackInitialization(IProjectAreaHandle projectArea) {
        this.fBuiltInAttributeCache.remove(projectArea.getItemId());
        this.fWorkItemTypeManager.flushCache(projectArea);
        this.fProcessAreaManager.flushCache(projectArea);
        this.fCategoryCache.invalidate((IAuditableHandle)projectArea);
        this.fDeliverableCache.invalidate((IAuditableHandle)projectArea);
    }

    @Override
    public boolean areAdditionalSaveParametersSupported(IProgressMonitor monitor) {
        if (this.fAdditionalSaveParametersSupportCache == null) {
            ServiceRunnable<Boolean> runnable = new ServiceRunnable<Boolean>(){

                @Override
                public Boolean run() throws TeamRepositoryException {
                    IWorkItemRepositoryService repositoryService = WorkItemCommon.this.getServiceContext().getService(IWorkItemRepositoryService.class);
                    return repositoryService.areAdditionalSaveParametersSupported();
                }
            };
            try {
                this.fAdditionalSaveParametersSupportCache = this.getServiceContext().callCancelableService(runnable, monitor);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                this.fAdditionalSaveParametersSupportCache = Boolean.FALSE;
            }
        } else if (monitor != null) {
            monitor.done();
        }
        return this.fAdditionalSaveParametersSupportCache;
    }
}

