/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequiredApprovalsAdvisor
implements IOperationAdvisor {
    public static final String APPROVAL_STATE = "approvalState";
    public static final String APPROVAL_TYPE = "approvalType";
    public static final String WORK_ITEM_TYPE = "workItemType";
    public static final String STATE_ID = "stateId";
    public static final String APPROVAL = "approval";
    public static final String ID = "com.ibm.team.workitem.advisor.requiredApprovals";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter) {
            ISaveParameter saveParameter = (ISaveParameter)data;
            this.addProblems(advisorConfiguration, saveParameter, collector, monitor);
        }
    }

    private void addProblems(IProcessConfigurationElement advisorConfiguration, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable auditable = saveParameter.getNewState();
        if (auditable instanceof IWorkItem) {
            IWorkItem workItem;
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItemType workItemType = workItemCommon.findWorkItemType((workItem = (IWorkItem)auditable).getProjectArea(), workItem.getWorkItemType(), monitor);
            if (workItemType == null) {
                return;
            }
            String stateId = RequiredApprovalsAdvisor.findTargetStateId(workItem, saveParameter.getWorkflowAction(), workItemCommon, monitor);
            if (stateId == null) {
                return;
            }
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            IProcessConfigurationElement[] configurationElements = advisorConfiguration.getChildren();
            int i = 0;
            while (i < configurationElements.length) {
                IProcessConfigurationElement configurationElement = configurationElements[i];
                if (APPROVAL.equals(configurationElement.getName()) && stateId.equals(configurationElement.getAttribute(STATE_ID)) && workItemType.getIdentifier().equals(configurationElement.getAttribute(WORK_ITEM_TYPE))) {
                    String approvalType = configurationElement.getAttribute(APPROVAL_TYPE);
                    String approvalState = configurationElement.getAttribute(APPROVAL_STATE);
                    List<IApprovalDescriptor> descriptors = workItem.getApprovals().getDescriptors();
                    boolean found = false;
                    for (IApprovalDescriptor d : descriptors) {
                        if (!d.getTypeIdentifier().equals(approvalType) || approvalState != null && !d.getCumulativeStateIdentifier().equals(approvalState)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        IAdvisorInfo info = collector.createProblemInfo(this.getSummary(approvalType), this.getDescription(workItem, approvalType, approvalState, userTimeZone), ID);
                        info.setProblemObject((Object)workItem.getItemHandle());
                        collector.addInfo((IReportInfo)info);
                    }
                }
                ++i;
            }
        }
    }

    public static String findTargetStateId(IWorkItem workItem, String actionId, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        Identifier<IState> state = workItem.getState2();
        IWorkflowInfo wfInfo = ((WorkItemCommon)workItemCommon).findWorkflowInfo(workItem, monitor);
        if (state == null && actionId == null && wfInfo != null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (wfInfo != null && state != null && !Arrays.asList(wfInfo.getAllStateIds()).contains(state)) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (actionId != null && wfInfo != null && (state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId))) == null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
            if (actionId != null) {
                state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId));
            }
        }
        if (state != null) {
            String stateId = state.getStringIdentifier();
            try {
                Integer.parseInt(stateId);
                stateId = "s" + stateId;
            }
            catch (NumberFormatException numberFormatException) {}
            return stateId;
        }
        return null;
    }

    private String getSummary(String approvalType) {
        IApprovalType type = WorkItemApprovals.getType(approvalType);
        String typeName = null;
        if (type != null) {
            typeName = type.getDisplayName();
        }
        if (typeName == null) {
            typeName = approvalType;
        }
        return NLS.bind((String)Messages.getString("RequiredApprovalsAdvisor.APPROVAL_NOT_PRESENT_SUMMARY"), (Object)typeName, (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, String approvalType, String approvalState, TimeZone userTimeZone) {
        IApprovalType type = WorkItemApprovals.getType(approvalType);
        String typeName = null;
        if (type != null) {
            typeName = type.getDisplayName();
        }
        if (typeName == null) {
            typeName = approvalType;
        }
        IApprovalState state = WorkItemApprovals.getState(approvalState);
        String stateName = null;
        if (state != null) {
            stateName = state.getDisplayName();
        }
        if (stateName == null) {
            stateName = approvalState;
        }
        return NLS.bind((String)Messages.getString("RequiredApprovalsAdvisor.APPROVAL_NOT_PRESENT_DESCRIPTION"), (Object)WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone), (Object[])new Object[]{typeName, stateName});
    }
}

