/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.Messages;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.SimilarityExpression;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.WorkItemExpression;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Term
extends Expression {
    public static final int AND = 0;
    public static final int OR = 1;
    @Deprecated
    public Expression[] expressions;
    @Deprecated
    public int operator;
    private final ArrayList<Expression> fExpressions = new ArrayList();
    private boolean fInternal;

    public Term() {
        this(0, null);
    }

    public Term(Operator operator) {
        this(operator, null);
    }

    public Term(Operator operator, Expression[] expressions) {
        this(operator.termOperator, expressions);
    }

    public Term(int operator, Expression[] expressions) {
        this.operator = operator;
        if (expressions != null) {
            Expression[] expressionArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                this.fExpressions.add(QueryUtils.getConditions(expression));
                ++n2;
            }
        }
        this.expressions = expressions;
        this.fInternal = false;
    }

    public void setOperator(Operator op) {
        this.operator = op.termOperator;
    }

    public Operator getOperator() {
        return this.operator == 0 ? Operator.AND : Operator.OR;
    }

    public List<Expression> getExpressions() {
        return Collections.unmodifiableList(this.fExpressions);
    }

    public void add(Expression expression) {
        this.fExpressions.add(expression);
        this.updateCompatibility();
    }

    public void remove(Expression expression) {
        this.fExpressions.remove(expression);
        this.updateCompatibility();
    }

    public void setInternal(boolean internal) {
        this.fInternal = internal;
    }

    public boolean isInternal() {
        return this.fInternal;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            for (Expression expression : this.fExpressions) {
                expression.accept(visitor);
            }
        }
    }

    @Override
    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (visitor.visit(this, monitor)) {
            for (Expression expression : this.fExpressions) {
                expression.accept(visitor, monitor);
            }
        }
    }

    @Override
    public void init(IPersistableElement element, ISerializationContext context) throws SerializationException {
        this.operator = this.getOperatorValue(element).termOperator;
        this.fInternal = element.hasAttribute("internal") && "true".equals(element.getAttribute("internal"));
        IPersistableElement[] expressionElements = element.getChildren();
        int i = 0;
        while (i < expressionElements.length) {
            Expression expression = null;
            String name = expressionElements[i].getName();
            if ("condition".equals(name)) {
                expression = expressionElements[i].hasChild("variable") ? new VariableAttributeExpression() : new AttributeExpression();
            } else if ("and".equals(name) || "or".equals(name)) {
                expression = new Term();
            } else if ("similarContent".equals(name)) {
                expression = new SimilarityExpression();
            } else if ("similarItem".equals(name)) {
                expression = new WorkItemExpression();
            }
            if (expression == null) {
                String error = NLS.bind((String)Messages.getString("Term.UNKNOWN_ELEMENT"), (Object)name, (Object[])new Object[0]);
                throw new SerializationException(error);
            }
            ((Expression)expression).init(expressionElements[i], context);
            this.add(expression);
            ++i;
        }
        this.updateCompatibility();
    }

    @Override
    public void saveState(IPersistableElement element) throws SerializationException {
        IPersistableElement termElement = element.createChild(this.getOperator().getTagName());
        if (this.isInternal()) {
            termElement.setAttribute("internal", "true");
        }
        for (Expression expression : this.fExpressions) {
            expression.saveState(termElement);
        }
    }

    private Operator getOperatorValue(IPersistableElement element) throws SerializationException {
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator op = operatorArray[n2];
            if (op.getTagName().equals(element.getName())) {
                return op;
            }
            ++n2;
        }
        String error = NLS.bind((String)Messages.getString("Term.UNKNOWN_TERM_OPERATOR"), (Object)element.getName(), (Object[])new Object[0]);
        throw new SerializationException(error);
    }

    private void updateCompatibility() {
        this.expressions = this.fExpressions.toArray(new Expression[this.fExpressions.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        AND(0, "and", "Term.AND_LITERAL"),
        OR(1, "or", "Term.OR_LITERAL");

        private final int termOperator;
        private final String fTagName;
        private final String fLabelKey;

        private Operator(int operator, String tagName, String labelKey) {
            this.termOperator = operator;
            this.fTagName = tagName;
            this.fLabelKey = labelKey;
        }

        public String getLabel() {
            return Messages.getString(this.fLabelKey);
        }

        private String getTagName() {
            return this.fTagName;
        }
    }
}

