/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.calm;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.calm.AbstractServiceDocument;
import com.ibm.team.workitem.common.calm.ChangeManagementServiceDocument;
import com.ibm.team.workitem.common.calm.QualityManagerServiceDocument;
import com.ibm.team.workitem.common.calm.RequirementsManagerServiceDocument;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CALMLinkType {
    public static final String LINK_TESTED_BY = "tested-by";
    public static final String LINK_IMPLEMENTS = "implements";
    public static final String LINK_RELATED_CM_ARTIFACT = "related-to";
    public static final CALMLinkType RELATED_CHANGE_MANAGEMENT = new CALMLinkType("com.ibm.team.workitem.linktype.relatedChangeManagement", "related-to", "oslc_cm", "oslc_cm:changeRequests", null);
    public static final CALMLinkType BLOCKS_EXECUTION_RECORD = new CALMLinkType("com.ibm.team.workitem.linktype.blocksTestExecutionRecord", "tested-by", "oslc_qm", "oslc_qm:executionrecords", null);
    public static final CALMLinkType AFFECTS_EXECUTION_RESULT = new CALMLinkType("com.ibm.team.workitem.linktype.affectsExecutionResult", "tested-by", "oslc_qm", "oslc_qm:executionresult", null);
    public static final CALMLinkType TESTED_BY_TEST_CASE = new CALMLinkType("com.ibm.team.workitem.linktype.testedByTestCase", "tested-by", "oslc_qm", "oslc_qm:testcases", "testcase");
    public static final CALMLinkType IMPLEMENTS_REQUIREMENT = new CALMLinkType("com.ibm.team.workitem.linktype.implementsRequirement", "implements", "oslc_rm", "oslc_rm:requirements", null);
    public static final CALMLinkType IMPLEMENTS_REQUIREMENT_COLLECTION = new CALMLinkType("com.ibm.team.workitem.linktype.implementsRequirementCollection", "implements", "oslc_rm", "oslc_rm:collections", null);
    public static final List<CALMLinkType> ALL_LINKS = Arrays.asList(RELATED_CHANGE_MANAGEMENT, BLOCKS_EXECUTION_RECORD, AFFECTS_EXECUTION_RESULT, TESTED_BY_TEST_CASE, IMPLEMENTS_REQUIREMENT, IMPLEMENTS_REQUIREMENT_COLLECTION);
    private final String fItemLinkType;
    private final String fProjectLinkName;
    private final String fProtocolNamespace;
    private final String fDefaultPickerName;
    private final String fResourceType;
    private boolean fPickerEnabled;

    static {
        RELATED_CHANGE_MANAGEMENT.setPickerEnabled(true);
        IMPLEMENTS_REQUIREMENT.setPickerEnabled(true);
        TESTED_BY_TEST_CASE.setPickerEnabled(true);
    }

    private CALMLinkType(String itemLinkType, String projectLinkName, String protocolNamespace, String resourceType, String defaultPickerName) {
        this.fItemLinkType = itemLinkType;
        this.fProjectLinkName = projectLinkName;
        this.fProtocolNamespace = protocolNamespace;
        this.fResourceType = resourceType;
        this.fDefaultPickerName = defaultPickerName;
        this.fPickerEnabled = false;
    }

    public String getProjectLinkName() {
        return this.fProjectLinkName;
    }

    public String getProtocolNamespace() {
        return this.fProtocolNamespace;
    }

    public String getResourceType() {
        return this.fResourceType;
    }

    public String getDefaultPickerName() {
        return this.fDefaultPickerName;
    }

    public void setPickerEnabled(boolean enablePicker) {
        this.fPickerEnabled = enablePicker;
    }

    public boolean isPickerEnabled() {
        return this.fPickerEnabled;
    }

    public AbstractServiceDocument getServiceDocument(String content) throws TeamRepositoryException {
        if (LINK_TESTED_BY.equals(this.fProjectLinkName)) {
            return new QualityManagerServiceDocument(content);
        }
        if (LINK_IMPLEMENTS.equals(this.fProjectLinkName)) {
            return new RequirementsManagerServiceDocument(content);
        }
        if (LINK_RELATED_CM_ARTIFACT.equals(this.fProjectLinkName)) {
            return new ChangeManagementServiceDocument(content);
        }
        return null;
    }

    public static CALMLinkType getCALMLink(ILinkType linkType) {
        return CALMLinkType.getCALMLink(linkType.getLinkTypeId());
    }

    public static CALMLinkType getCALMLink(String linkTypeId) {
        for (CALMLinkType link : ALL_LINKS) {
            if (!link.getItemLinkType().equals(linkTypeId)) continue;
            return link;
        }
        return null;
    }

    public boolean hasCALMProjectLink(List<IProjectLink> links) {
        for (IProjectLink projectLink : links) {
            if (!projectLink.getLinkType().equals(this.fProjectLinkName)) continue;
            return true;
        }
        return false;
    }

    public String getItemLinkType() {
        return this.fItemLinkType;
    }

    public static boolean isCalmLinkWithPicker(IEndPointDescriptor endPoint) {
        return CALMLinkType.isCalmLinkWithPicker(endPoint.getLinkType().getLinkTypeId());
    }

    public static boolean isCalmLinkWithPicker(String linkTypeId) {
        CALMLinkType link = CALMLinkType.getCALMLink(linkTypeId);
        return link != null && link.isPickerEnabled();
    }

    public static List<IEndPointDescriptor> getCALMEndPointDescriptors(IProjectLink projectLink) {
        String projectLinkType = projectLink.getLinkType();
        ArrayList<IEndPointDescriptor> descriptors = new ArrayList<IEndPointDescriptor>(1);
        for (CALMLinkType link : ALL_LINKS) {
            IEndPointDescriptor desc;
            if (!link.getProjectLinkName().equals(projectLinkType) || !link.isPickerEnabled() || (desc = WorkItemLinkTypes.findTargetEndPointDescriptor(link.getItemLinkType())) == null) continue;
            descriptors.add(desc);
        }
        return descriptors;
    }

    public static List<IEndPointDescriptor> getCALMEndPointDescriptors() {
        ArrayList<IEndPointDescriptor> descriptors = new ArrayList<IEndPointDescriptor>(1);
        for (CALMLinkType link : ALL_LINKS) {
            IEndPointDescriptor desc = WorkItemLinkTypes.findTargetEndPointDescriptor(link.getItemLinkType());
            if (desc == null) continue;
            descriptors.add(desc);
        }
        return descriptors;
    }
}

