/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.template;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemTemplateClient;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.client.internal.template.Messages;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IWorkItemTemplateService;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateSerializable;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.IWorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemTemplateClient
implements IWorkItemTemplateClient {
    private final ICommonServiceContext fContext;

    public WorkItemTemplateClient(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException(Messages.WorkItemTemplateClient_ERROR_ON_INITIALIZATION);
        }
        this.fContext = new ClientServiceContext(context);
    }

    @Override
    public String createTemplateIdentifier(final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)project);
        ServiceRunnable<String> runnable = new ServiceRunnable<String>(){

            public String run() throws TeamRepositoryException {
                return WorkItemTemplateClient.this.getService().createTemplateIdentifier(project);
            }
        };
        return (String)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public void createTemplate(final IWorkItemTemplateDescriptor desc, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)desc);
        ServiceRunnable<Object> runnable = new ServiceRunnable<Object>(){

            public Object run() throws TeamRepositoryException {
                WorkItemTemplateClient.this.getService().createTemplate(WorkItemTemplateSerializable.serializeTemplateDescriptor((IWorkItemTemplateDescriptor)desc));
                return null;
            }
        };
        this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public String[] getAvailableTemplates(final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)project);
        ServiceRunnable<String[]> runnable = new ServiceRunnable<String[]>(){

            public String[] run() throws TeamRepositoryException {
                return WorkItemTemplateClient.this.getService().getAvailableTemplates(project);
            }
        };
        return (String[])this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public IWorkItemTemplateHandle getTemplate(final String templateIdentifier, final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((templateIdentifier != null && templateIdentifier.length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)project);
        ServiceRunnable<IWorkItemTemplateHandle> runnable = new ServiceRunnable<IWorkItemTemplateHandle>(){

            public IWorkItemTemplateHandle run() throws TeamRepositoryException {
                Object[] data = WorkItemTemplateClient.this.getService().getTemplate(templateIdentifier, project);
                if (data == null || data.length == 0) {
                    return null;
                }
                return WorkItemTemplateSerializable.deserializeTemplateHandle((Object[])data);
            }
        };
        return (IWorkItemTemplateHandle)this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public int[] instantiateTemplate(final String templateIdentifier, final Map<IAttributeVariable, Object> variables, final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((templateIdentifier != null && templateIdentifier.length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull(variables);
        Assert.isNotNull((Object)project);
        ServiceRunnable<int[]> runnable = new ServiceRunnable<int[]>(){

            public int[] run() throws TeamRepositoryException {
                return WorkItemTemplateClient.this.getService().instantiateTemplate(templateIdentifier, WorkItemTemplateSerializable.serializeVariableValues((Map)variables), project);
            }
        };
        return (int[])this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    @Override
    public void importTemplate(final String xmlContent, final IProjectAreaHandle project, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<Object> runnable = new ServiceRunnable<Object>(){

            public Object run() throws TeamRepositoryException {
                WorkItemTemplateClient.this.getService().importTemplate(xmlContent, project);
                return null;
            }
        };
        this.fContext.callCancelableService((ServiceRunnable)runnable, monitor);
    }

    public IWorkItemTemplateService getService() throws TeamRepositoryException {
        IWorkItemTemplateService service = (IWorkItemTemplateService)this.fContext.getService(IWorkItemTemplateService.class);
        if (service == null) {
            throw new TeamRepositoryException(Messages.WorkItemTemplateClient_ERROR_ON_ACCESSING_TEMPLATE_SERVICE);
        }
        return service;
    }
}

