/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.AdapterManagerFactory;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyRegistry;
import com.ibm.team.workitem.client.internal.WorkingCopyRunnable;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemWorkingCopyImpl
implements WorkItemWorkingCopy {
    private ListenerList fListeners = new ListenerList();
    private boolean fIsDirty;
    public String fWorkflowAction;
    private ITeamRepository fTeamRepository;
    private IWorkItem fWorkItem;
    private List<IWorkItemWorkingCopyManager> fConnections = Collections.synchronizedList(new ArrayList());
    private IWorkItemReferences fReferences;
    private IWorkItem fSharedItem;
    private IWorkItem fBaseState;
    private boolean fIsStale = false;
    private boolean fIsUpdatingBaseState = false;
    private WorkItemWorkingCopyRegistry fRegistry;
    private Set<String> fAdditionalSaveParameters;
    private ReadWriteLock fLock = new ReentrantReadWriteLock();
    private int fDeferEvents = 0;
    private List<WorkingCopyEvent> fDeferredEventQueue = new ArrayList<WorkingCopyEvent>();
    private List<ArtifactLink> fArtifactLinks = new ArrayList<ArtifactLink>();

    public WorkItemWorkingCopyImpl(IWorkItem workItem) {
        Assert.isTrue((boolean)workItem.isWorkingCopy());
        this.fTeamRepository = (ITeamRepository)workItem.getOrigin();
        this.fWorkItem = workItem;
        this.fAdditionalSaveParameters = new HashSet<String>(3);
    }

    public void connect(IWorkItemWorkingCopyManager manager) {
        this.fConnections.add(manager);
        ((WorkItemWorkingCopyManager)manager).addConnection((IWorkItemHandle)this.getWorkItem().getItemHandle());
    }

    public void disconnect(IWorkItemWorkingCopyManager manager) {
        Assert.isTrue((boolean)this.fConnections.remove(manager));
        ((WorkItemWorkingCopyManager)manager).removeConnection((IWorkItemHandle)this.getWorkItem().getItemHandle());
    }

    public boolean isDisconnected() {
        return this.fConnections.isEmpty();
    }

    public boolean isConnected(IWorkItemWorkingCopyManager manager) {
        return this.fConnections.contains(manager);
    }

    public boolean hasWriteConnection() {
        return this.hasOtherWriteConnection(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasOtherWriteConnection(IWorkItemWorkingCopyManager manager) {
        List<IWorkItemWorkingCopyManager> list = this.fConnections;
        synchronized (list) {
            IWorkItemWorkingCopyManager current;
            Iterator<IWorkItemWorkingCopyManager> iterator = this.fConnections.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((current = iterator.next()) == manager || !((WorkItemWorkingCopyManager)current).isWriteable());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasWriteConnectionAfter(IWorkItemWorkingCopyManager manager) {
        List<IWorkItemWorkingCopyManager> list = this.fConnections;
        synchronized (list) {
            boolean seen = false;
            Iterator<IWorkItemWorkingCopyManager> iterator = this.fConnections.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                IWorkItemWorkingCopyManager current = iterator.next();
                if (current == manager && !seen) {
                    seen = true;
                    continue;
                }
                if (((WorkItemWorkingCopyManager)current).isWriteable()) break;
            }
            return true;
        }
    }

    public void aboutToUpdateBaseState() {
        this.fIsUpdatingBaseState = true;
    }

    public void baseStateUpdated() {
        this.fIsUpdatingBaseState = false;
        this.updateStaleState(false);
    }

    public void reverted() {
        this.setDirty(false);
        this.fireWorkingCopyChanged(WorkingCopyEvent.createWorkingCopyEvent(this, "reverted"));
    }

    public void dispose() {
        this.fireWorkingCopyChanged(WorkingCopyEvent.createWorkingCopyEvent(this, "aboutToBeDisposed"));
    }

    @Override
    public IWorkItem getWorkItem() {
        return this.fWorkItem;
    }

    @Override
    public void addWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        if (this.fIsDirty != dirty) {
            this.fIsDirty = dirty;
            if (this.fIsDirty && !this.hasWriteConnection() && !this.isDisconnected()) {
                ModelPlugin.log(Messages.WorkItemWorkingCopyImpl_READ_ONLY_WORKING_COPY_DIRTIED, new IllegalStateException());
            }
            if (!this.fIsDirty) {
                this.resetWorkflowAction();
                this.getAdditionalSaveParameters().clear();
            }
            WorkingCopyEvent event = WorkingCopyEvent.createWorkingCopyEvent(this, "dirtyState");
            this.fireWorkingCopyChanged(event);
        }
    }

    @Override
    public boolean isStale() {
        return this.fIsStale;
    }

    public void updateStaleState() {
        this.updateStaleState(true);
    }

    private void updateStaleState(boolean autoMerge) {
        boolean isStale;
        if (this.fIsUpdatingBaseState) {
            return;
        }
        boolean bl = isStale = this.fBaseState != null && this.fSharedItem != null && !this.fBaseState.sameStateId((IItemHandle)this.fSharedItem);
        if (this.fIsStale != isStale) {
            if (autoMerge && isStale && this.fRegistry.autoMerge(this)) {
                return;
            }
            this.fIsStale = isStale;
            WorkingCopyEvent event = WorkingCopyEvent.createWorkingCopyEvent(this, "staleState");
            this.fireWorkingCopyChanged(event);
        }
    }

    public void aboutToBeSaved() {
        this.fireWorkingCopyChanged(WorkingCopyEvent.createWorkingCopyEvent(this, "aboutToBeSaved"));
        this.fIsUpdatingBaseState = true;
    }

    @Override
    public IDetailedStatus save(IProgressMonitor monitor) {
        IDetailedStatus status;
        if (!this.fIsDirty) {
            return DetailedStatus.OK_STATUS;
        }
        try {
            status = this.getWorkItemClient().getWorkItemWorkingCopyManager().save(new WorkItemWorkingCopy[]{this}, monitor);
        }
        catch (TeamRepositoryException x) {
            status = DetailedStatus.createFromException(Messages.WorkItemWorkingCopyRegistry_SAVE_EXCEPTION, x);
        }
        return status;
    }

    public void saved(IDetailedStatus status) {
        this.fIsUpdatingBaseState = false;
        boolean succeeded = status != null && !status.matches(4);
        try {
            if (succeeded) {
                this.fireWorkingCopyChanged(WorkingCopyEvent.createWorkingCopyEvent(this, "saved", status));
            } else {
                this.fireWorkingCopyChanged(WorkingCopyEvent.createWorkingCopyEvent(this, "saveCanceled", status));
            }
        }
        finally {
            if (succeeded) {
                this.setDirty(false);
            }
            this.updateStaleState(false);
        }
    }

    @Override
    public void setWorkflowAction(String action) {
        if (!this.equals(this.fWorkflowAction, action)) {
            this.fWorkflowAction = action;
            this.setDirty(true);
            this.fireWorkflowActionChanged();
        }
    }

    @Override
    public Set<String> getAdditionalSaveParameters() {
        return this.fAdditionalSaveParameters;
    }

    private boolean equals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    private void resetWorkflowAction() {
        if (this.fWorkflowAction != null) {
            this.fWorkflowAction = null;
            this.fireWorkflowActionChanged();
        }
    }

    private void fireWorkflowActionChanged() {
        WorkingCopyEvent event = WorkingCopyEvent.createWorkingCopyEvent(this, "workflowAction");
        this.fireWorkingCopyChanged(event);
    }

    @Override
    public String getWorkflowAction() {
        return this.fWorkflowAction;
    }

    @Override
    public IWorkItemReferences getReferences() {
        this.enforceAccessProfile(this.isReferencesSet());
        return this.fReferences;
    }

    public void setReferences(IWorkItemReferences references) {
        this.fReferences = references;
    }

    @Override
    public boolean isReferencesSet() {
        return this.fReferences != null;
    }

    public IWorkItem getSharedItem() {
        return this.fSharedItem;
    }

    public void setSharedItem(IWorkItem sharedItem) {
        Assert.isNotNull((Object)sharedItem);
        Assert.isTrue((!sharedItem.isWorkingCopy() ? 1 : 0) != 0);
        this.fSharedItem = sharedItem;
        this.updateStaleState(false);
    }

    public IWorkItem getBaseState() {
        this.assertIsValidWorkingCopyPredecessor(((WorkItem)this.fWorkItem).getWorkingCopyPredecessor());
        return this.fBaseState;
    }

    public void assertIsValidWorkingCopyPredecessor(UUID workingCopyPredecessor) {
        if (this.fBaseState == null) {
            Assert.isTrue((workingCopyPredecessor == null ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)this.fBaseState.getStateId().equals((Object)workingCopyPredecessor));
        }
    }

    public void setBaseState(IWorkItem baseState) {
        Assert.isNotNull((Object)baseState);
        Assert.isTrue((!baseState.isWorkingCopy() ? 1 : 0) != 0);
        Assert.isTrue((!baseState.isImmutable() ? 1 : 0) != 0);
        this.fBaseState = baseState;
        if (!baseState.getStateId().equals((Object)((WorkItem)this.fWorkItem).getWorkingCopyPredecessor())) {
            ((WorkItem)this.fWorkItem).setWorkingCopyPredecessor(baseState.getStateId());
        }
        this.updateStaleState(false);
    }

    private void enforceAccessProfile(boolean isSet) {
        if (!AuditablesHelper.ENFORCE_ACCESS_PROFILES) {
            return;
        }
        if (!isSet) {
            AuditablesHelper.handleAccessProfileViolation((IAuditable)this.getWorkItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWorkingCopyChanged(WorkingCopyEvent event) {
        List<WorkingCopyEvent> list = this.fDeferredEventQueue;
        synchronized (list) {
            if (this.fDeferEvents > 0) {
                this.fDeferredEventQueue.add(event);
                return;
            }
        }
        if (this.fRegistry != null) {
            this.fRegistry.fireWorkingCopyEvent(this.fListeners, event);
        }
    }

    public void setRegistry(WorkItemWorkingCopyRegistry registry) {
        this.fRegistry = registry;
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    private IWorkItemClient getWorkItemClient() {
        return (IWorkItemClient)this.getTeamRepository().getClientLibrary(IWorkItemClient.class);
    }

    public Object getAdapter(Class adapter) {
        return AdapterManagerFactory.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactLink> getArtifactLinks() {
        List<ArtifactLink> list = this.fArtifactLinks;
        synchronized (list) {
            List references = this.getReferences().getReferences(WorkItemEndPoints.ATTACHMENT);
            for (IReference reference : references) {
                ArtifactLink link = this.find(this.fArtifactLinks, reference);
                if (link != null) continue;
                this.fArtifactLinks.add(new ArtifactLink(this, reference));
            }
            Iterator<ArtifactLink> iter = this.fArtifactLinks.iterator();
            while (iter.hasNext()) {
                if (references.contains(iter.next().getReference())) continue;
                iter.remove();
            }
            return new ArrayList<ArtifactLink>(this.fArtifactLinks);
        }
    }

    private ArtifactLink find(List<ArtifactLink> links, IReference reference) {
        for (ArtifactLink link : links) {
            if (link.getReference() != reference) continue;
            return link;
        }
        return null;
    }

    public <T> T read(WorkingCopyRunnable<T> runnable) {
        return this.run(this.fLock.readLock(), runnable);
    }

    public <T> T write(WorkingCopyRunnable<T> runnable) {
        return this.run(this.fLock.writeLock(), runnable);
    }

    public <T> T run(final Lock lock, final WorkingCopyRunnable<T> runnable) {
        final Object[] result = new Object[1];
        ThreadCheck.runProhibitingLongOps((Runnable)new Runnable(){

            public void run() {
                lock.lock();
                if (lock instanceof ReentrantReadWriteLock.WriteLock) {
                    WorkItemWorkingCopyImpl.this.suspendWorkingCopyEvents();
                }
                try {
                    result[0] = runnable.run();
                }
                finally {
                    List events = null;
                    if (lock instanceof ReentrantReadWriteLock.WriteLock) {
                        events = WorkItemWorkingCopyImpl.this.resumeWorkingCopyEvents();
                    }
                    lock.unlock();
                    if (lock instanceof ReentrantReadWriteLock.WriteLock) {
                        WorkItemWorkingCopyImpl.this.sendDeferredEvents(events);
                    }
                    runnable.runFinally();
                }
            }
        });
        return (T)result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendWorkingCopyEvents() {
        List<WorkingCopyEvent> list = this.fDeferredEventQueue;
        synchronized (list) {
            ++this.fDeferEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WorkingCopyEvent> resumeWorkingCopyEvents() {
        ArrayList<WorkingCopyEvent> events = new ArrayList<WorkingCopyEvent>();
        List<WorkingCopyEvent> list = this.fDeferredEventQueue;
        synchronized (list) {
            --this.fDeferEvents;
            if (this.fDeferEvents == 0) {
                events.addAll(this.fDeferredEventQueue);
                this.fDeferredEventQueue.clear();
            }
        }
        return events;
    }

    private void sendDeferredEvents(List<WorkingCopyEvent> events) {
        if (this.fRegistry != null) {
            for (WorkingCopyEvent event : events) {
                this.fRegistry.fireWorkingCopyEvent(this.fListeners, event);
            }
        }
    }
}

