/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.internal.repository.rcp.tar.TarEntry;
import com.ibm.team.internal.repository.rcp.tar.TarOutputStream;
import com.ibm.team.scm.client.importz.IChangeSetFileWriter;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.internal.utils.TimerUtil;
import com.ibm.team.scm.client.importz.spi.DerivedImportChangeSet;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCache {
    private static final int DEFAULT_MAX_ENTRIES = 1000;
    private static final String FILE_NAME = "logEntryFile";
    protected Map<Long, List<DerivedImportChangeSet>> entries;
    private List<File> filesList;
    protected int entryCounter = 0;
    private IChangeSetFileWriter fileWriter;
    private TarOutputStream tar_out;
    private File file;
    private Comparator<IImportChangeSet> comparator;

    public LogCache(IChangeSetFileWriter fileWriter, String filename, Comparator<IImportChangeSet> comparator) throws IOException {
        if (fileWriter == null || filename == null) {
            throw new IllegalArgumentException();
        }
        this.comparator = comparator == null ? new Comparator<IImportChangeSet>(){

            @Override
            public int compare(IImportChangeSet o1, IImportChangeSet o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        } : comparator;
        this.fileWriter = fileWriter;
        this.filesList = new LinkedList<File>();
        this.clearCache();
        this.file = new File(filename);
        try {
            this.file.createNewFile();
            this.tar_out = new TarOutputStream(this.file);
            TimerUtil.log(this.file.getAbsolutePath());
        }
        finally {
            if (this.tar_out == null) {
                this.file.delete();
            }
        }
    }

    protected void clearCache() {
        this.entries = new HashMap<Long, List<DerivedImportChangeSet>>();
        this.entryCounter = 0;
    }

    public void addChange(Date date, String comment, String author, IImportChange change, InputStream contents) throws IOException {
        DerivedImportChangeSet changeSet;
        long bucket;
        List<DerivedImportChangeSet> changeSets;
        if (date == null || comment == null || author == null || change == null) {
            throw new IllegalArgumentException();
        }
        if (change.getItemType() == 1 && change.getAfterPath() != null) {
            if (contents == null) {
                throw new IllegalArgumentException();
            }
            String filename = this.getArchivePath(change);
            this.tar_out.putNextEntry(new TarEntry(filename, 420L, 0L, 0L, 0L, 0L, 48, "", "", "", 0L, 0L, 0L, 0L), contents, TarOutputStream.gzipFilter);
        }
        if ((changeSets = this.entries.get(bucket = date.getTime() / (long)this.getBucketTimeRangeInMillis())) == null) {
            changeSets = new ArrayList<DerivedImportChangeSet>();
            this.entries.put(bucket, changeSets);
        }
        if ((changeSet = this.findChangeSet(changeSets, comment, author)) == null) {
            changeSet = this.createChangeSet(date, comment, author);
            changeSets.add(changeSet);
        }
        changeSet.add(date, change);
        ++this.entryCounter;
        if (this.entryCounter >= this.getMaximumEntries()) {
            this.writeCurrentEntries();
        }
    }

    private DerivedImportChangeSet findChangeSet(List<DerivedImportChangeSet> changeSets, String comment, String author) {
        for (DerivedImportChangeSet importChangeSet : changeSets) {
            if (!this.matches(importChangeSet, comment, author)) continue;
            return importChangeSet;
        }
        return null;
    }

    protected DerivedImportChangeSet createChangeSet(Date date, String comment, String author) {
        return new DerivedImportChangeSet(date, comment, author);
    }

    protected boolean matches(DerivedImportChangeSet importChangeSet, String comment, String author) {
        return importChangeSet.getComment().equals(comment) && importChangeSet.getAuthor().equals(author);
    }

    protected int getBucketTimeRangeInMillis() {
        return 1000;
    }

    protected int getMaximumEntries() {
        return 1000;
    }

    protected String getArchivePath(IImportChange change) {
        if (change instanceof ImportChange) {
            ImportChange ic = (ImportChange)change;
            return ic.getArchivePath();
        }
        String path = change.getAfterPath();
        String revision = change.getRevision();
        return LogCache.getCachedFileName(path, revision);
    }

    public void writeCurrentEntries() throws IOException {
        File file = DebugUtils.createTempFile(FILE_NAME);
        try {
            this.fileWriter.startWrite(file);
            List<IImportChangeSet> changeSets = this.getSortedChangeSets();
            for (IImportChangeSet changeSet : changeSets) {
                this.fileWriter.writeElement(changeSet);
            }
            this.fileWriter.closeWrite();
        }
        catch (IOException e) {
            DebugUtils.deleteTempFile(file);
            throw e;
        }
        this.filesList.add(file);
        this.clearCache();
    }

    private List<IImportChangeSet> getSortedChangeSets() {
        ArrayList<IImportChangeSet> sortedList = new ArrayList<IImportChangeSet>();
        for (List<DerivedImportChangeSet> sets : this.entries.values()) {
            sortedList.addAll(sets);
        }
        Collections.sort(sortedList, this.comparator);
        return sortedList;
    }

    public List<File> getStoredFiles() {
        return this.filesList;
    }

    public static String getCachedFileName(String path, String revision) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return String.valueOf(path) + "_" + revision + ".gz";
    }

    public TarOutputStream getTarOutputStream() {
        return this.tar_out;
    }

    public File getFile() {
        return this.file;
    }
}

