/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.IImportParticipant;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.interop.IWorkspaceConnectionInteropAdapter;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImportParticipant
implements IImportParticipant {
    private static final int POST_IMPORT_BASELINE_TIMEOUT = 3600;
    private String postImportBaselineName;

    public void postCommit(IWorkspaceConnection connection, IComponentHandle component, IImportChangeSet importChangeSet, IChangeSetHandle changeSet, IUpdateReport updateReport, IVersionable[] affectedItems, IImportChange[] changes, IVersionableHandle[] changeLeafs, IProgressMonitor monitor) {
    }

    public void changeSetRead(IWorkspaceConnection connection, IComponentHandle component, IImportChangeSet importChangeSet, IProgressMonitor monitor) {
    }

    public void postImport(IWorkspaceConnection workspace, IComponent component, IProgressMonitor monitor) {
        ITeamRepository teamRepository = workspace.teamRepository();
        int timeout = teamRepository.getConnectionTimeout();
        try {
            try {
                IWorkspaceConnectionInteropAdapter op;
                if (3600 > timeout) {
                    teamRepository.setConnectionTimeout(3600);
                }
                if ((op = (IWorkspaceConnectionInteropAdapter)workspace.getAdapter(IWorkspaceConnectionInteropAdapter.class)) != null) {
                    op.createPostImportBaseline((IComponentHandle)component, this.postImportBaselineName == null ? null : this.postImportBaselineName, SCMImportMessages.ImportParticipant_0, monitor);
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)this, (Throwable)e);
                if (teamRepository.getConnectionTimeout() == 3600) {
                    teamRepository.setConnectionTimeout(timeout);
                }
            }
        }
        finally {
            if (teamRepository.getConnectionTimeout() == 3600) {
                teamRepository.setConnectionTimeout(timeout);
            }
        }
    }

    public String getPostImportBaselineName() {
        return this.postImportBaselineName;
    }

    public void setPostImportBaselineName(String postImportBaselineName) {
        this.postImportBaselineName = postImportBaselineName;
    }
}

