/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.common.IChangeSet;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportChangeSet
implements IImportChangeSet {
    public static final String NULL_AUTHOR = "anonymous";
    private final Date date;
    private final String comment;
    private final String author;
    private final String revision;
    private final List<IImportChange> changes;

    public ImportChangeSet(String revision, Date date, String comment, String author) {
        this.revision = revision;
        this.checkArgs(date, comment);
        this.date = date;
        this.comment = comment;
        this.author = author == null ? NULL_AUTHOR : author;
        this.changes = new ArrayList<IImportChange>();
    }

    public ImportChangeSet(Date date, String comment, String author) {
        this(null, date, comment, author);
    }

    private void checkArgs(Date date, String comment) {
        if (date == null || comment == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImportChangeSet)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        ImportChangeSet other = (ImportChangeSet)obj;
        return this.date.equals(other.date) && this.comment.equals(other.comment) && this.author.equals(other.author);
    }

    public int hashCode() {
        return this.date.hashCode() + this.comment.hashCode() + this.author.hashCode();
    }

    public String toString() {
        return "[" + this.getAuthor() + "] (" + DateFormat.getInstance().format(this.getDate()) + ") " + this.getComment();
    }

    @Override
    public List<IImportChange> getChanges() {
        return this.changes;
    }

    public void add(IImportChange change) {
        this.changes.add(change);
    }

    public void addAll(List<IImportChange> changes) {
        this.changes.addAll(changes);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    @Override
    public String asCommentMessage(boolean embedAuthor, boolean embedDate) {
        if (!embedAuthor && !embedDate && this.revision == null) {
            return this.getComment();
        }
        StringBuffer buf = new StringBuffer();
        if (embedAuthor) {
            buf.append("[" + this.getAuthor() + "] ");
        }
        if (embedDate) {
            buf.append("(" + DateFormat.getInstance().format(this.getDate()) + ") ");
        }
        buf.append(this.getComment());
        if (this.revision != null) {
            return NLS.bind((String)SCMImportMessages.ImportChangeSet_0, (Object)this.getRevision(), (Object)buf.toString());
        }
        return buf.toString();
    }

    public static long getRevision(String comment) {
        String patternString = NLS.bind((String)SCMImportMessages.ImportChangeSet_0, (Object)"(\\d+)", (Object)"(.|\n|\r)*");
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(comment);
        if (matcher.matches()) {
            String group = matcher.group(1);
            try {
                return Long.parseLong(group);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1L;
    }

    public static String truncateComment(String comment) {
        IStatus status = IItemValidator.INSTANCE.validateAttribute((IType)IChangeSet.ITEM_TYPE, IChangeSet.COMMENT_PROPERTY, (Object)comment);
        if (!status.isOK() && status instanceof IStringSizeConstraintErrorStatus) {
            IStringSizeConstraintErrorStatus ss = (IStringSizeConstraintErrorStatus)status;
            long maxSize = ss.getMaxSize();
            try {
                byte[] bytes = comment.getBytes("UTF8");
                if ((long)bytes.length > maxSize) {
                    return String.valueOf(new String(bytes, 0, (int)maxSize - 3, "UTF8")) + "...";
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return String.valueOf(comment.substring(0, (int)maxSize - (int)maxSize / 10)) + "...";
            }
        }
        return comment;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }
}

