/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.spi.ImportData;
import com.ibm.team.scm.client.importz.spi.LogCache;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ImportChange
implements IImportChange {
    private static final int ITEM_TYPE_MASK = 15;
    private static final int KIND_MASK = 240;
    private final int status;
    private final String beforePath;
    private final String afterPath;
    private final String revision;
    private final IFileProperties fileProperties;
    private final String archivePath;

    public static final String kindToString(int kind) {
        if (kind == 16) {
            return "ADDITION";
        }
        if (kind == 32) {
            return "DELETION";
        }
        if (kind == 64) {
            return "CHANGE";
        }
        return "UNKNOWN";
    }

    public static String getArchivePath(int status, String afterPath, String revision) {
        if (afterPath != null && (status & 0xF) == 1 && (status & 0xF0) != 32) {
            return LogCache.getCachedFileName(afterPath, revision);
        }
        return null;
    }

    public ImportChange(int status, String revision, String beforePath, String afterPath, String archivePath, IFileProperties fileProperties) {
        this.archivePath = archivePath;
        this.verifyStatus(status);
        this.verifyPaths(status, beforePath, afterPath);
        Assert.isNotNull((Object)revision);
        this.revision = revision;
        this.beforePath = beforePath;
        this.afterPath = afterPath;
        this.status = status;
        this.fileProperties = fileProperties;
    }

    private void verifyStatus(int flags) {
        int type = flags & 0xF;
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException(NLS.bind((String)SCMImportMessages.ImportChange_4, (Object)flags));
        }
        int kind = flags & 0xF0;
        if (kind != 16 && kind != 32 && kind != 64) {
            throw new IllegalArgumentException(NLS.bind((String)SCMImportMessages.ImportChange_5, (Object)flags));
        }
    }

    private void verifyPaths(int flags, String beforePath, String afterPath) {
        int kind = flags & 0xF0;
        if (kind == 32 || (flags & 0x200) > 0) {
            Assert.isNotNull((Object)beforePath);
        }
        if (kind == 16 || kind == 64) {
            Assert.isNotNull((Object)afterPath);
        }
    }

    public int getItemType() {
        return this.status & 0xF;
    }

    public int getKind() {
        return this.status & 0xF0;
    }

    public int getFlags() {
        return this.status & 0xFFFFFF00;
    }

    public String getBeforePath() {
        return this.beforePath;
    }

    public String getAfterPath() {
        return this.afterPath;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getArchivePath() {
        if (this.archivePath == null || this.getItemType() != 1 || this.getKind() == 32 || this.getAfterPath() == null) {
            return null;
        }
        return new String(this.archivePath.getBytes());
    }

    public int hashCode() {
        int hashCode = this.getRevision().hashCode();
        if (this.beforePath != null) {
            hashCode ^= this.beforePath.hashCode();
        }
        if (this.afterPath != null) {
            hashCode ^= this.afterPath.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImportChange)) {
            return false;
        }
        ImportChange other = (ImportChange)obj;
        return this.getRevision().equals(other.getRevision()) && this.pathsEqual(this.beforePath, other.beforePath) && this.pathsEqual(this.afterPath, other.afterPath);
    }

    private boolean pathsEqual(String path1, String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        return path1.equals(path2);
    }

    public InputStream getContents(IImportData data, IProgressMonitor monitor) throws IOException {
        String archivePath = this.getArchivePath();
        if (archivePath == null) {
            return null;
        }
        return ((ImportData)data).getArchiveInputStream(archivePath);
    }

    public IFileProperties getFileProperties() {
        return this.fileProperties;
    }

    public boolean isIgnoreFileChange() {
        return false;
    }

    public IImportChange asModificationForReconciliation() {
        Assert.isTrue((this.getItemType() == 1 ? 1 : 0) != 0);
        Assert.isTrue((this.getKind() == 16 ? 1 : 0) != 0);
        return new ImportChange(321, this.getRevision(), this.getAfterPath(), this.getAfterPath(), this.getArchivePath(), this.getFileProperties());
    }
}

