/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.spi.FileProperties;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import com.ibm.team.scm.client.importz.spi.ImportData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreFileChange
extends ImportChange {
    private final String ignorePattern;

    public IgnoreFileChange(int status, String revision, String beforePath, String afterPath, String ignorePattern, String archivePath) {
        super(status, revision, beforePath, afterPath, archivePath, new FileProperties(FileLineDelimiter.LINE_DELIMITER_NONE, "text/plain", "UTF-8", false));
        this.ignorePattern = ignorePattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    @Override
    public InputStream getContents(IImportData data, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.ignorePattern != null) {
            return this.getJazzIgnoreFileContents(this.ignorePattern, progress);
        }
        String archivePath = this.getArchivePath();
        if (archivePath != null) {
            InputStream inputStream;
            InputStream ignorePatternInputStream = ((ImportData)data).getArchiveInputStream(archivePath);
            try {
                String customIgnorePatterns = this.toString(ignorePatternInputStream);
                inputStream = this.getJazzIgnoreFileContents(customIgnorePatterns, progress);
            }
            catch (Throwable throwable) {
                try {
                    ignorePatternInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ignorePatternInputStream.close();
            }
            catch (IOException iOException) {}
            return inputStream;
        }
        return null;
    }

    private String toString(InputStream in) throws IOException {
        int len;
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[1024];
        String encoding = null;
        IFileProperties props = this.getFileProperties();
        if (props != null) {
            encoding = props.getEncoding();
        }
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        while ((len = reader.read(buffer)) != -1) {
            result.append(buffer, 0, len);
        }
        return result.toString();
    }

    private InputStream getJazzIgnoreFileContents(String customIgnorePatterns, SubMonitor monitor) throws IOException {
        try {
            monitor.setWorkRemaining(3);
            IPath path = new Path(this.getAfterPath()).removeLastSegments(1);
            Collection<String> globalPatterns = this.getGlobalPatterns(path, (IProgressMonitor)monitor.newChild(1));
            Collection<String> localPatterns = this.getLocalPatterns(path, customIgnorePatterns, (IProgressMonitor)monitor.newChild(1));
            byte[] bytes = DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor.newChild(1)).getIgnoreFileContents(path, globalPatterns, localPatterns);
            return new ByteArrayInputStream(bytes);
        }
        catch (FileSystemClientException e) {
            StatusUtil.log((Object)this, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private Collection<String> getLocalPatterns(IPath path, String customIgnorePatterns, IProgressMonitor monitor) throws FileSystemClientException {
        Collection patterns = DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor).getDefaultIgnorePatterns(path);
        HashSet<String> result = new HashSet<String>();
        for (IgnorePattern ignorePattern : patterns) {
            if (ignorePattern.isGlobal()) continue;
            result.add(ignorePattern.getPattern());
        }
        StringTokenizer tokenizer = new StringTokenizer(customIgnorePatterns, "\r\n\t");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.trim().length() <= 0) continue;
            result.add(s.trim());
        }
        return result;
    }

    private Collection<String> getGlobalPatterns(IPath path, IProgressMonitor monitor) throws FileSystemClientException {
        if (path.segmentCount() > 1) {
            return null;
        }
        Collection patterns = DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor).getDefaultIgnorePatterns(path);
        HashSet<String> result = new HashSet<String>();
        for (IgnorePattern ignorePattern : patterns) {
            if (!ignorePattern.isGlobal()) continue;
            result.add(ignorePattern.getPattern());
        }
        return result;
    }

    @Override
    public boolean isIgnoreFileChange() {
        return true;
    }

    @Override
    public IImportChange asModificationForReconciliation() {
        Assert.isTrue((this.getItemType() == 1 ? 1 : 0) != 0);
        Assert.isTrue((this.getKind() == 16 ? 1 : 0) != 0);
        return new IgnoreFileChange(321, this.getRevision(), this.getAfterPath(), this.getAfterPath(), this.getIgnorePattern(), this.getArchivePath());
    }
}

