/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.spi.ImportChangeSet;
import java.util.Date;

public class DerivedImportChangeSet
extends ImportChangeSet {
    public static final long MAX_TIME_DIFF = 60000L;
    private Date earliestDate;
    private Date latestDate;

    public DerivedImportChangeSet(Date earliestDate, Date latestDate, String comment, String author) {
        super(earliestDate, comment, author);
        this.earliestDate = earliestDate;
        this.latestDate = latestDate;
    }

    public DerivedImportChangeSet(Date date, String comment, String author) {
        this(date, date, comment, author);
    }

    public Date getLatestDate() {
        return this.latestDate;
    }

    public void setLatestDate(Date latestDate) {
        this.latestDate = latestDate;
    }

    public Date getEarliestDate() {
        return this.earliestDate;
    }

    public void setEarliestDate(Date earliestDate) {
        this.earliestDate = earliestDate;
    }

    public void add(Date date, IImportChange change) {
        this.add(change);
        if (date.before(this.getEarliestDate())) {
            this.setEarliestDate(date);
        } else if (date.after(this.getLatestDate())) {
            this.setLatestDate(date);
        }
    }

    public boolean sameAs(DerivedImportChangeSet other) {
        if (!this.getComment().equals(other.getComment()) || !this.getAuthor().equals(other.getAuthor())) {
            return false;
        }
        if (other.getEarliestDate().getTime() - this.getLatestDate().getTime() > 60000L) {
            return false;
        }
        return this.getEarliestDate().getTime() - other.getLatestDate().getTime() <= 60000L;
    }

    public void combine(DerivedImportChangeSet other) {
        if (this.getEarliestDate().after(other.getEarliestDate())) {
            this.setEarliestDate(other.getEarliestDate());
        }
        if (this.getLatestDate().before(other.getLatestDate())) {
            this.setLatestDate(other.getLatestDate());
        }
        this.addAll(other.getChanges());
    }
}

