/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.scm.client.importz.IChangeSetFileWriter;
import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.spi.IgnoreFileChange;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetFileWriter
implements IChangeSetFileWriter {
    public static final String LOG_FILENAME = "changes.txt.gz";
    static final String VERSION_IDENTIFIER_PREFIX = "Change-set-archive-version: ";
    static final String VERSION_ONE = "1";
    static final String DIRECTORIES_SIGNIFICANT_PREFIX = "Directories-significant: ";
    static final String DATE_PREFIX = "Date: ";
    static final String AUTHOR_PREFIX = "Author: ";
    static final String COMMENT_LINES_PREFIX = "Comment-lines: ";
    static final String CHANGE_COUNT_PREFIX = "Change-count: ";
    static final String PATH_PREFIX = "Path: ";
    static final String KIND_PREFIX = "Kind: ";
    static final String FROM_PATH_PREFIX = "From-path: ";
    static final String ARCHIVE_PATH_PREFIX = "Archive-path: ";
    static final String IGNORE_PATTERN_PREFIX = "Ignore-pattern: ";
    static final String IGNORE_PATTERN_FILE_PREFIX = "Ignore-pattern-file: ";
    static final String REVISION_PREFIX = "Revision: ";
    static final String LINE_DELIMITER_PREFIX = "Line-delimiter: ";
    static final String CONTENT_TYPE_PREFIX = "Content-type: ";
    static final String CONTENT_ENCODING_PREFIX = "Character-encoding: ";
    static final String EXECUTABLE_PREFIX = "Executable: ";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS Z";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS Z", Locale.US);
    private BufferedWriter writer;
    private boolean needsClose;
    private boolean directoriesSignificant = true;

    static synchronized String formatDate(Date date) {
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(date);
    }

    static synchronized Date parseDate(String date) {
        try {
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            return formatter.parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public final void startWrite(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.startWrite(new FileOutputStream(file));
        }
        finally {
            this.needsClose = true;
        }
    }

    @Override
    public final void startWrite(OutputStream stream) throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException(SCMImportMessages.ChangeSetFileWriter_0);
        }
        this.writer = new BufferedWriter(new OutputStreamWriter(stream));
        this.writeHeader();
    }

    protected void writeHeader() throws IOException {
        this.writeVersion();
        this.writeDirectoriesSignificantFlag();
    }

    private void writeVersion() throws IOException {
        this.writer.write(VERSION_IDENTIFIER_PREFIX);
        this.writer.write(VERSION_ONE);
        this.writer.newLine();
    }

    private void writeDirectoriesSignificantFlag() throws IOException {
        this.writer.write(DIRECTORIES_SIGNIFICANT_PREFIX);
        this.writer.write(this.directoriesSignificant ? Boolean.toString(true) : Boolean.toString(false));
        this.writer.newLine();
    }

    @Override
    public void closeWrite() throws IOException {
        if (this.writer != null) {
            if (this.needsClose) {
                this.writer.close();
            } else {
                this.writer.flush();
            }
        }
        this.writer = null;
        this.needsClose = false;
    }

    @Override
    public final void writeElement(IImportChangeSet changeSet) throws IOException {
        List<IImportChange> changes = changeSet.getChanges();
        this.writeElement(changeSet, changes);
    }

    @Override
    public void writeElement(IImportChangeSet changeSet, List<IImportChange> changes) throws IOException {
        if (changeSet == null || changes == null) {
            throw new IllegalArgumentException();
        }
        this.writeProperties(changeSet);
        this.writer.write(CHANGE_COUNT_PREFIX);
        this.writer.write(Integer.toString(changes.size()));
        this.writer.newLine();
        Iterator<IImportChange> iter = changes.iterator();
        while (iter.hasNext()) {
            this.writer.newLine();
            this.writeChange(iter.next());
        }
        this.writer.newLine();
    }

    private void writeProperties(IImportChangeSet changeSet) throws IOException {
        String revision = changeSet.getRevision();
        if (revision != null) {
            this.getWriter().write(REVISION_PREFIX);
            this.getWriter().write(revision);
            this.getWriter().newLine();
        }
        this.writer.write(DATE_PREFIX);
        this.writer.write(ChangeSetFileWriter.formatDate(changeSet.getDate()));
        this.writer.newLine();
        this.writer.write(AUTHOR_PREFIX);
        this.writer.write(changeSet.getAuthor());
        this.writer.newLine();
        List<String> commentLines = this.getCommentLines(changeSet);
        this.writer.write(COMMENT_LINES_PREFIX);
        this.writer.write(Integer.toString(commentLines.size()));
        this.writer.newLine();
        for (String line : commentLines) {
            this.writer.write(line);
            this.writer.newLine();
        }
    }

    private List<String> getCommentLines(IImportChangeSet changeSet) {
        StringTokenizer tokenizer = new StringTokenizer(changeSet.getComment(), "\r\n");
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private void writeChange(IImportChange change) throws IOException {
        IFileProperties properties;
        String archivePath;
        ImportChange ic;
        String path = this.getPath(change);
        this.writer.write(PATH_PREFIX);
        this.writer.write(path);
        this.writer.newLine();
        this.writer.write(KIND_PREFIX);
        this.writer.write(this.formatKind(change));
        this.writer.newLine();
        String fromPath = this.getFromPath(change);
        if (fromPath != null && !fromPath.equals(path)) {
            this.writer.write(FROM_PATH_PREFIX);
            this.writer.write(fromPath);
            this.writer.newLine();
        }
        if (change.isIgnoreFileChange()) {
            if (change instanceof IgnoreFileChange) {
                IgnoreFileChange ifc = (IgnoreFileChange)change;
                String ignorePattern = ifc.getIgnorePattern();
                if (ignorePattern != null) {
                    this.writer.write(IGNORE_PATTERN_PREFIX);
                    this.writer.write(this.convertLineBreaksToTabs(ignorePattern));
                    this.writer.newLine();
                }
            } else if (change instanceof ImportChange) {
                ic = (ImportChange)change;
                archivePath = ic.getArchivePath();
                if (archivePath != null) {
                    this.writer.write(IGNORE_PATTERN_FILE_PREFIX);
                    this.writer.write(archivePath);
                    this.writer.newLine();
                }
            } else {
                ic = (ImportChange)change;
                archivePath = ic.getArchivePath();
                if (archivePath != null) {
                    this.writer.write(ARCHIVE_PATH_PREFIX);
                    this.writer.write(archivePath);
                    this.writer.newLine();
                }
            }
        } else if (change instanceof ImportChange && (archivePath = (ic = (ImportChange)change).getArchivePath()) != null) {
            this.writer.write(ARCHIVE_PATH_PREFIX);
            this.writer.write(archivePath);
            this.writer.newLine();
        }
        if ((properties = change.getFileProperties()) != null) {
            boolean isExecutable;
            String encoding;
            String contentType;
            FileLineDelimiter eol = properties.getLineDelimiter();
            if (eol != null && !eol.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE)) {
                this.writer.write(LINE_DELIMITER_PREFIX);
                this.writer.write(this.toString(eol));
                this.writer.newLine();
            }
            if (!(contentType = properties.getContentType()).equals("text/plain")) {
                this.writer.write(CONTENT_TYPE_PREFIX);
                this.writer.write(contentType);
                this.writer.newLine();
            }
            if ((encoding = properties.getEncoding()) != null) {
                this.writer.write(CONTENT_ENCODING_PREFIX);
                this.writer.write(encoding);
                this.writer.newLine();
            }
            if (isExecutable = properties.isExecutable()) {
                this.writer.write(EXECUTABLE_PREFIX);
                this.writer.write("true");
                this.writer.newLine();
            }
        }
        this.writer.write(REVISION_PREFIX);
        this.writer.write(change.getRevision());
        this.writer.newLine();
    }

    private String convertLineBreaksToTabs(String ignorePattern) {
        StringTokenizer tokenizer = new StringTokenizer(ignorePattern, "\r\n\t");
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.trim().length() <= 0) continue;
            result.add(s.trim());
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < result.size()) {
            String pattern = (String)result.get(i);
            buffer.append(pattern);
            if (i < result.size() - 1) {
                buffer.append('\t');
            }
            ++i;
        }
        return buffer.toString();
    }

    private String toString(FileLineDelimiter lineDelimiter) {
        if (lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
            return "platform";
        }
        if (lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_LF)) {
            return "lf";
        }
        if (lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_CR)) {
            return "cr";
        }
        if (lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_CRLF)) {
            return "crlf";
        }
        return "none";
    }

    private String getPath(IImportChange change) {
        String afterPath = change.getAfterPath();
        if (afterPath != null) {
            return afterPath;
        }
        return change.getBeforePath();
    }

    private String getFromPath(IImportChange change) {
        if (change.getAfterPath() == null) {
            return null;
        }
        return change.getBeforePath();
    }

    private String formatKind(IImportChange change) {
        StringBuffer buffer = new StringBuffer(32);
        int type = change.getItemType();
        if (type == 1) {
            buffer.append("file,");
        } else if (type == 2) {
            buffer.append("folder,");
        }
        int kind = change.getKind();
        if (kind == 16) {
            buffer.append("add");
        } else if (kind == 32) {
            buffer.append("delete");
        } else {
            buffer.append("change");
        }
        int flags = change.getFlags();
        if ((flags & 0x200) > 0) {
            buffer.append(",");
            buffer.append("move");
        }
        if ((flags & 0x100) > 0) {
            buffer.append(",");
            buffer.append("content");
        }
        return buffer.toString();
    }

    protected BufferedWriter getWriter() {
        return this.writer;
    }

    public boolean isDirectoriesSignificant() {
        return this.directoriesSignificant;
    }

    public void setDirectoriesSignificant(boolean directoriesSignificant) {
        this.directoriesSignificant = directoriesSignificant;
    }
}

