/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.utils;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.internal.utils.IFileTree;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeWithEmptyFolderTracking
implements IFileTree {
    private IFileTree wrappedTree;
    private final Set<String> emptyFolders = new HashSet<String>();

    public FileTreeWithEmptyFolderTracking(IFileTree tree) {
        this.wrappedTree = tree;
    }

    @Override
    public void prepareForChanges(List<IImportChange> changes, boolean fetchDeep, boolean directoriesSignificant, IProgressMonitor monitor) throws TeamRepositoryException {
        this.wrappedTree.prepareForChanges(changes, fetchDeep, directoriesSignificant, monitor);
    }

    @Override
    public IVersionableHandle getItemHandle(String path) {
        return this.wrappedTree.getItemHandle(path);
    }

    @Override
    public IVersionable getItem(String path) {
        return this.wrappedTree.getItem(path);
    }

    @Override
    public IFolder createFolder(String path) {
        IFolder folder = this.wrappedTree.createFolder(path);
        this.emptyFolders.remove(PathUtils.getParentFolderPath((String)path));
        this.emptyFolders.add(path);
        return folder;
    }

    @Override
    public IFileItem createFile(String path) {
        IFileItem file = this.wrappedTree.createFile(path);
        this.emptyFolders.remove(PathUtils.getParentFolderPath((String)path));
        return file;
    }

    @Override
    public IVersionable move(String beforePath, String afterPath) {
        IVersionable item = this.wrappedTree.move(beforePath, afterPath);
        this.emptyFolders.remove(PathUtils.getParentFolderPath((String)afterPath));
        this.testForEmptyFolder(beforePath);
        return item;
    }

    private void testForEmptyFolder(String beforePath) {
        String parent = PathUtils.getParentFolderPath((String)beforePath);
        if (!this.wrappedTree.hasChildren(parent) && PathUtils.getBaseName((String)parent).length() > 0) {
            this.emptyFolders.add(parent);
        }
    }

    @Override
    public IVersionable remove(String path) {
        IVersionable item = this.wrappedTree.remove(path);
        this.emptyFolders.remove(path);
        this.testForEmptyFolder(path);
        return item;
    }

    @Override
    public boolean hasChildren(String path) {
        return this.wrappedTree.hasChildren(path);
    }

    public Set<String> getEmptyFolders() {
        return new HashSet<String>(this.emptyFolders);
    }

    @Override
    public Collection<String> getChildNames(String path) {
        return this.wrappedTree.getChildNames(path);
    }

    @Override
    public boolean areChilrenKnown(String path) {
        return this.wrappedTree.areChilrenKnown(path);
    }
}

