/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractOptionsArea;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class StatisticsArea
extends AbstractOptionsArea {
    private Group statisticsGroup;
    private Button showStatButton;
    private Text textField;

    public StatisticsArea(Composite parent, final ImportConfiguration configuration) {
        this.statisticsGroup = this.createGroup(parent, SCMImportMessages.StatisticsArea_0, 2, true);
        this.textField = new Text((Composite)this.statisticsGroup, 10);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.textField.setLayoutData((Object)data);
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("archiveFilename")) {
                    StatisticsArea.this.setStatistics("");
                }
            }
        };
        configuration.addPropertyChangeListener(propertyChangeListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                configuration.removePropertyChangeListener(propertyChangeListener);
            }
        });
        Label label = new Label((Composite)this.statisticsGroup, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.showStatButton = new Button((Composite)this.statisticsGroup, 8);
        this.showStatButton.setText(SCMImportMessages.StatisticsArea_2);
        this.showStatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsArea.this.showStatistics();
            }
        });
        this.showStatButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    protected abstract void showStatistics();

    public void setStatistics(String stats) {
        if (stats == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(stats);
        }
    }
}

