/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractOptionsArea;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ImportTargetOptions
extends AbstractOptionsArea {
    private Button importToWorkspaceOption;
    private Button importToArchiveOption;
    private ImportConfiguration configuration;
    private Group importGroup;

    public ImportTargetOptions(Composite parent, ImportConfiguration importConfiguration) {
        this.configuration = importConfiguration;
        this.importGroup = this.createGroup(parent, SCMImportMessages.ImportTargetOptions_0, 1);
        this.importToWorkspaceOption = new Button((Composite)this.importGroup, 16);
        this.importToWorkspaceOption.setText(SCMImportMessages.ImportTargetOptions_1);
        this.importToWorkspaceOption.setLayoutData((Object)new GridData(4, 4, true, false));
        this.importToWorkspaceOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTargetOptions.this.configuration.setImportIntoWorkspace(ImportTargetOptions.this.importToWorkspaceOption.getSelection());
            }
        });
        this.importToArchiveOption = new Button((Composite)this.importGroup, 16);
        this.importToArchiveOption.setText(SCMImportMessages.ImportTargetOptions_2);
        this.importToArchiveOption.setLayoutData((Object)new GridData(4, 4, true, false));
        this.importToArchiveOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTargetOptions.this.configuration.setImportIntoWorkspace(ImportTargetOptions.this.importToWorkspaceOption.getSelection());
            }
        });
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ImportTargetOptions.this.updateEnablements();
            }
        };
        this.configuration.addPropertyChangeListener(propertyChangeListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImportTargetOptions.this.configuration.removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    public void initControls() {
        this.importToWorkspaceOption.setSelection(this.configuration.isImportIntoWorkspace());
        this.importToArchiveOption.setSelection(!this.configuration.isImportIntoWorkspace());
        this.updateEnablements();
    }

    protected void updateEnablements() {
        this.importToWorkspaceOption.setEnabled(this.isEnabled() && this.configuration.isImportFullHistory());
        this.importToArchiveOption.setEnabled(this.isEnabled() && this.configuration.isImportFullHistory());
    }
}

