/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.IChangeSetArchiveCreator;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.ChangeSetArchiveImporter;
import com.ibm.team.scm.client.importz.internal.IChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractImportWizard;
import com.ibm.team.scm.client.importz.internal.ui.ConfigureArchiveFileImportPage;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import com.ibm.team.scm.client.importz.internal.ui.ImportLoggingHelper;
import com.ibm.team.scm.client.importz.internal.ui.ImportOperation;
import com.ibm.team.scm.client.importz.internal.ui.StatisticsArea;
import com.ibm.team.scm.client.importz.spi.ImportData;
import com.ibm.team.scm.client.importz.spi.MigrationFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ChangeArchiveImportWizard
extends AbstractImportWizard
implements IImportWizard {
    private ConfigureArchiveFileImportPage configureArchiveImportPage;
    private String initialFilename;

    public ChangeArchiveImportWizard() {
        this.setWindowTitle(SCMImportMessages.ChangeArchiveImportWizard_1);
        this.setNeedsProgressMonitor(true);
    }

    protected ImportConfiguration createConfiguration() {
        return new ImportConfiguration(this.getSourceRepositoryKind(), true);
    }

    protected String getDefaultFilename() {
        if (this.initialFilename != null) {
            return this.initialFilename;
        }
        return AbstractImportWizard.DEFAULT_FILENAME;
    }

    protected void addPagesAtBeginning() {
        this.configureArchiveImportPage = new ConfigureArchiveFileImportPage("ConfigureArchiveFileImportPage", SCMImportMessages.ChangeArchiveImportWizard_3, this.getBanner(), this.getConfiguration()){

            protected StatisticsArea createStatisticsGroup(Composite composite, ImportConfiguration configuration) {
                return new EmbeddedStatisticsArea(composite, configuration);
            }
        };
        this.configureArchiveImportPage.setDescription(SCMImportMessages.ChangeArchiveImportWizard_4);
        this.addPage((IWizardPage)this.configureArchiveImportPage);
    }

    public boolean canFinish() {
        if (!this.configureArchiveImportPage.isPageComplete()) {
            return false;
        }
        return super.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        for (Object o : selection) {
            IPath path;
            if (o instanceof File) {
                this.initialFilename = ((File)o).getAbsolutePath();
                break;
            }
            if (!(o instanceof IAdaptable)) continue;
            IAdaptable a = (IAdaptable)o;
            IFile file = (IFile)a.getAdapter(IFile.class);
            if (file != null && (path = file.getLocation()) != null) {
                this.initialFilename = path.toOSString();
                break;
            }
            File f = (File)a.getAdapter(File.class);
            if (f == null) continue;
            this.initialFilename = f.getAbsolutePath();
            break;
        }
    }

    private IChangeArchiveStatistics getStatistics(IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        String filename = this.getConfiguration().getArchiveFilename();
        File file = new File(filename);
        if (!file.exists()) {
            ImportLoggingHelper.displayError(SCMImportMessages.ChangeArchiveImportWizard_Error, NLS.bind((String)SCMImportMessages.ChangeArchiveImportWizard_6, (Object)filename));
            return null;
        }
        IMigrationFactory factory = this.getMigrationFactory();
        ImportData data = new ImportData();
        data.setArchiveFile(file);
        boolean closeArchive = false;
        try {
            closeArchive = data.openArchive(null);
            ChangeSetArchiveImporter importer = new ChangeSetArchiveImporter(factory, data);
            importer.importChangeSetArchive(null, null, true, monitor);
            IChangeArchiveStatistics iChangeArchiveStatistics = importer.getStats();
            return iChangeArchiveStatistics;
        }
        finally {
            if (closeArchive) {
                data.closeArchive();
            }
        }
    }

    protected IMigrationFactory getMigrationFactory() {
        return new MigrationFactory(){

            public String getName() {
                return SCMImportMessages.MigrationFactory_0;
            }

            public IChangeSetArchiveCreator createChangeSetArchiveCreator() {
                return null;
            }
        };
    }

    protected ImportOperation createImportOperation() {
        return new ImportOperation(SCMImportMessages.ChangeArchiveImportWizard_2, this.getMigrationFactory(), this.getConfiguration());
    }

    protected String getSourceRepositoryKind() {
        return SCMImportMessages.ChangeArchiveImportWizard_5;
    }

    protected ImageDescriptor getBanner() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.scm.client.importz", (String)"icons/wizban/change_archi_import_wizban.gif");
    }

    private final class EmbeddedStatisticsArea
    extends StatisticsArea {
        private EmbeddedStatisticsArea(Composite parent, ImportConfiguration configuration) {
            super(parent, configuration);
        }

        protected void showStatistics() {
            try {
                ChangeArchiveImportWizard.this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            final IChangeArchiveStatistics stats = ChangeArchiveImportWizard.this.getStatistics(monitor);
                            if (stats != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        EmbeddedStatisticsArea.this.setStatistics(stats.toDescriptionString());
                                    }
                                });
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ImportLoggingHelper.displayError(SCMImportMessages.ChangeArchiveImportWizard_0, e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }

        protected void updateEnablements() {
        }
    }
}

