/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractImportWizardPage;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMapping;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMappingArea;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Author2ContributorMappingPage
extends AbstractImportWizardPage
implements IPropertyChangeListener {
    public static final String AUTHOR_MAPPING_PROPERTY = "PromptForAuthrMappings";
    public static final String PROMPT_FOR_MAPPINGS = "prompt";
    public static final String NO_MAPPING = "none";
    public static final String USE_PROVIDED_MAPPINGS = "provided";
    public static final String MAP_MATCHING_IDS = "auto";
    private final ImportConfiguration configuration;
    private Button promptForMapping;
    private Button useEnteredMappings;
    private Button noMapping;
    private Author2ContributorMappingArea mappingArea;
    private final boolean duringImport;
    private boolean isAdmin;
    private Button autoMapping;

    public Author2ContributorMappingPage(String pageName, ImageDescriptor titleImage, ImportConfiguration configuration, boolean duringImport, boolean isAdmin) {
        super(pageName, SCMImportMessages.Author2ContributorMappingPage_4, titleImage);
        this.configuration = configuration;
        this.duringImport = duringImport;
        this.isAdmin = isAdmin;
        this.setDescription(NLS.bind((String)SCMImportMessages.Author2ContributorMappingPage_5, (Object)configuration.getSourceRepositoryKind()));
        configuration.addPropertyChangeListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.configuration.removePropertyChangeListener(this);
    }

    @Override
    protected ImportConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void createPageAreas(Composite composite) {
        GridData data;
        if (!this.duringImport) {
            this.promptForMapping = new Button(composite, 80);
            this.promptForMapping.setText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingPage_6, (Object)this.configuration.getSourceRepositoryKind()));
            this.promptForMapping.setToolTipText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingPage_7, (Object)this.configuration.getSourceRepositoryKind()));
            data = new GridData(4, 4, true, false);
            data.horizontalSpan = 2;
            this.promptForMapping.setLayoutData((Object)data);
            this.promptForMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Author2ContributorMappingPage.this.updateMappingType();
                }
            });
        }
        this.noMapping = new Button(composite, 80);
        this.noMapping.setText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingPage_8, (Object)this.configuration.getSourceRepositoryKind()));
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.noMapping.setLayoutData((Object)data);
        this.noMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingPage.this.updateMappingType();
            }
        });
        this.autoMapping = new Button(composite, 80);
        this.autoMapping.setText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingPage_0, (Object)this.configuration.getSourceRepositoryKind()));
        this.autoMapping.setToolTipText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingPage_1, (Object)this.configuration.getSourceRepositoryKind()));
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.autoMapping.setLayoutData((Object)data);
        this.autoMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingPage.this.updateMappingType();
            }
        });
        this.useEnteredMappings = new Button(composite, 80);
        this.useEnteredMappings.setText(SCMImportMessages.Author2ContributorMappingPage_9);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.useEnteredMappings.setLayoutData((Object)data);
        this.useEnteredMappings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingPage.this.updateMappingType();
            }
        });
        this.mappingArea = new Author2ContributorMappingArea(composite, this.configuration, !this.duringImport, (IRunnableContext)this.getContainer(), this.getUserOperationRunner());
        this.mappingArea.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.mappingArea.getAuthorMappings().addListener((ISetListener)new ISetListener<Author2ContributorMapping>(){

            public void changed(SetDiff<Author2ContributorMapping> diff) {
                Author2ContributorMappingPage.this.updateEnablements();
            }
        });
    }

    @Override
    protected void initControls() {
        String property = (String)this.configuration.getProperty(AUTHOR_MAPPING_PROPERTY);
        if (this.isAdmin) {
            if (property == null) {
                property = this.duringImport ? USE_PROVIDED_MAPPINGS : PROMPT_FOR_MAPPINGS;
            } else if (property.equals(PROMPT_FOR_MAPPINGS) && this.duringImport) {
                property = USE_PROVIDED_MAPPINGS;
            }
            this.setMessage(null);
        } else {
            property = NO_MAPPING;
        }
        if (this.promptForMapping != null) {
            this.promptForMapping.setSelection(property.equals(PROMPT_FOR_MAPPINGS));
            this.promptForMapping.setEnabled(this.isAdmin);
        }
        if (this.autoMapping != null) {
            this.autoMapping.setSelection(property.equals(MAP_MATCHING_IDS));
            this.autoMapping.setEnabled(this.isAdmin);
        }
        this.noMapping.setSelection(property.equals(NO_MAPPING));
        this.useEnteredMappings.setSelection(property.equals(USE_PROVIDED_MAPPINGS));
        this.useEnteredMappings.setEnabled(this.isAdmin);
        super.initControls();
        this.updateEnablements();
    }

    void updateMappingType() {
        String value = USE_PROVIDED_MAPPINGS;
        if (this.promptForMapping != null && this.promptForMapping.getSelection()) {
            value = PROMPT_FOR_MAPPINGS;
        } else if (this.autoMapping != null && this.autoMapping.getSelection()) {
            value = MAP_MATCHING_IDS;
        } else if (this.noMapping.getSelection()) {
            value = NO_MAPPING;
        }
        this.configuration.setProperty(AUTHOR_MAPPING_PROPERTY, value);
        this.updateEnablements();
    }

    @Override
    public void updateEnablements() {
        if (this.isComplete()) {
            super.updateEnablements();
        } else {
            this.setPageComplete(false);
        }
        this.mappingArea.setEnabled(this.useEnteredMappings.getSelection());
        if (this.isVisible() && this.useEnteredMappings.getSelection()) {
            this.mappingArea.linkInputToViewer(this.configuration.getRepository(), this.getUserOperationRunner());
        }
        if (!this.isAdmin && this.getMessage() == null) {
            this.setMessage(SCMImportMessages.Author2ContributorMappingPage_3, 2);
        }
    }

    @Override
    protected IStatus validatePageState() {
        return Status.OK_STATUS;
    }

    private boolean isVisible() {
        return this.getControl() != null && this.getControl().isVisible();
    }

    public boolean isComplete() {
        return this.mappingArea != null && (!this.getAuthorMappings().isEmpty() || this.promptForMapping != null && this.promptForMapping.getSelection() || this.autoMapping != null && this.autoMapping.getSelection() || this.noMapping.getSelection());
    }

    public Collection<Author2ContributorMapping> getAuthorMappings() {
        if (this.useEnteredMappings.getSelection()) {
            return this.mappingArea.getAuthorMappings().toCollection();
        }
        return new ArrayList<Author2ContributorMapping>();
    }

    public void updateMappingsFor(Collection<String> authorsForSelectedFolders) {
        this.mappingArea.ensureAuthorIdsAreAvailable(authorsForSelectedFolders);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.useEnteredMappings.getSelection()) {
            this.mappingArea.linkInputToViewer(this.configuration.getRepository(), this.getUserOperationRunner());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("teamReposiotry")) {
            try {
                this.isAdmin = false;
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ITeamRepository repository = Author2ContributorMappingPage.this.configuration.getRepository();
                        if (repository != null) {
                            Author2ContributorMappingPage.this.isAdmin = Author2ContributorMappingArea.hasJazzAdminPermissions(repository);
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.initControls();
        }
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.team.scm.client.importz.userMappingPage";
    }
}

