/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.ISyncImportParticipant;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.spi.ImportParticipant;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SyncImportParticipant
extends ImportParticipant
implements ISyncImportParticipant {
    private IWorkspaceConnection workspace;
    private IComponent component;
    private Set committedChangeSets;
    private Map stateRevisionMap;
    private Map baseStateRevisionMap;
    private IFileItemHandle syncFileHandle;
    private Map<UUID, IChangeSetHandle> incomingChangeSets = new LinkedHashMap<UUID, IChangeSetHandle>();

    public SyncImportParticipant(IWorkspaceConnection workspace, IComponent component, Set committedChangeSets, Map stateRevisionMap, IFileItemHandle syncFileHandle) {
        this.workspace = workspace;
        this.component = component;
        this.committedChangeSets = new HashSet(committedChangeSets);
        this.stateRevisionMap = new CachedDiskBackedHashMap(stateRevisionMap);
        this.baseStateRevisionMap = stateRevisionMap;
        this.syncFileHandle = syncFileHandle;
    }

    public List getIncomingChangeSets() {
        return new ArrayList<IChangeSetHandle>(this.incomingChangeSets.values());
    }

    public void postCommit(IWorkspaceConnection connection, IComponentHandle component, IImportChangeSet importChangeSet, IChangeSetHandle changeSet, IUpdateReport updateReport, IVersionable[] affectedItems, IImportChange[] changes, IVersionableHandle[] changeLeafs, IProgressMonitor monitor) {
        super.postCommit(connection, component, importChangeSet, changeSet, updateReport, affectedItems, changes, changeLeafs, monitor);
        if (changeSet != null) {
            this.incomingChangeSets.put(changeSet.getItemId(), changeSet);
            HashMap<UUID, IVersionableHandle> afterStateMap = new HashMap<UUID, IVersionableHandle>();
            for (IItemUpdateReport report : updateReport.updates()) {
                afterStateMap.put(report.item().getItemId(), report.getNewCurrentState());
            }
            int i = 0;
            while (i < changes.length) {
                this.processChange(changes[i], changeLeafs[i], afterStateMap);
                ++i;
            }
        }
    }

    protected void processChange(IImportChange change, IVersionableHandle leaf, Map afterStateMap) {
        if (change.getAfterPath() != null) {
            IVersionableHandle afterState = (IVersionableHandle)afterStateMap.get(leaf.getItemId());
            if (afterState == null) {
                throw new IllegalStateException("null after state for non null change ");
            }
            this.stateRevisionMap.put(afterState.getStateId().getUuidValue(), change.getRevision());
        } else {
            this.stateRevisionMap.put(leaf.getItemId().getUuidValue(), change.getRevision());
        }
    }

    public Map getStateRevisionMap() {
        return this.stateRevisionMap;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public Set getCommittedChangeSets() {
        return this.committedChangeSets;
    }

    public boolean needsReinit(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.syncFileHandle == null) {
            monitor.beginTask("", 1);
            monitor.done();
            return true;
        }
        return !this.syncFileHandle.sameStateId((IItemHandle)this.workspace.configuration((IComponentHandle)this.component).fetchCompleteItem((IVersionableHandle)this.syncFileHandle, monitor));
    }

    public void updateSyncFileHandle(IUpdateReport report) {
        if (this.syncFileHandle == null) {
            return;
        }
        for (IItemUpdateReport itemReport : report.updates()) {
            if (!this.syncFileHandle.sameItemId((IItemHandle)itemReport.item())) continue;
            this.syncFileHandle = (IFileItemHandle)itemReport.getNewCurrentState();
            return;
        }
        throw new IllegalArgumentException(SCMImportMessages.SyncImportParticipant_2);
    }

    public void acceptedChangeSets(Collection changeSets) {
        for (IChangeSetHandle cs : changeSets) {
            this.incomingChangeSets.remove(cs.getItemId());
        }
    }

    public void acceptedChangeSets(Collection changeSets, Map newBaseStateRevisionMap) {
        this.acceptedChangeSets(changeSets);
        for (IChangeSetHandle cs : changeSets) {
            this.committedChangeSets.add(cs.getItemId().getUuidValue());
        }
        this.baseStateRevisionMap = newBaseStateRevisionMap;
    }

    public void deliveredChangeSets(Collection changeSets) {
        for (IChangeSetHandle cs : changeSets) {
            this.committedChangeSets.add(cs.getItemId().getUuidValue());
        }
    }

    public Map getBaseStateRevisionMap() {
        return this.baseStateRevisionMap;
    }

    public void deliveredState(IVersionableHandle versionable, String version) {
        this.stateRevisionMap.put(versionable.getStateId().getUuidValue(), version);
        this.baseStateRevisionMap.put(versionable.getStateId().getUuidValue(), version);
    }

    public void deliveredDeletion(IVersionableHandle versionable, String version) {
        this.stateRevisionMap.put(versionable.getItemId().getUuidValue(), version);
        this.baseStateRevisionMap.put(versionable.getItemId().getUuidValue(), version);
    }
}

