/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.AbstractChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import org.eclipse.osgi.util.NLS;

public class PreFlightChangeArchiveStatistics
extends AbstractChangeArchiveStatistics {
    int numChangeSets = 0;
    int numChanges = 0;

    public String toDescriptionString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NLS.bind((String)SCMImportMessages.PreFlightChangeArchiveStatistics_0, (Object)this.numChangeSets));
        buffer.append('\n');
        buffer.append(NLS.bind((String)SCMImportMessages.PreFlightChangeArchiveStatistics_1, (Object)this.numChanges));
        buffer.append('\n');
        buffer.append(NLS.bind((String)SCMImportMessages.PreFlightChangeArchiveStatistics_2, (Object)this.getContributorsCount()));
        buffer.append('\n');
        buffer.append(NLS.bind((String)SCMImportMessages.PreFlightChangeArchiveStatistics_3, (Object)this.getLargestChangeSetSize()));
        buffer.append('\n');
        long timeSpan = this.timeSpan();
        long diffHours = timeSpan / 3600000L;
        long diffDays = timeSpan / 86400000L;
        long diffYears = diffDays / 365L;
        long diffYearsRemain = Math.round((double)(diffDays % 365L) / 365.0 * 100.0);
        buffer.append(NLS.bind((String)SCMImportMessages.PreFlightChangeArchiveStatistics_4, (Object[])new Object[]{diffYears, diffYearsRemain, diffDays, diffHours}));
        buffer.append('\n');
        return buffer.toString();
    }

    public int getChangeSetCount() {
        return this.numChangeSets;
    }

    public int getChangesCount() {
        return this.numChanges;
    }

    public void startCommit(IImportChangeSet importChangeSet, long time, boolean preflight) {
        super.startCommit(importChangeSet, time, preflight);
        ++this.numChangeSets;
        this.numChanges += importChangeSet.getChanges().size();
    }

    public void changesCollected(long time) {
    }

    public void changesCommited(long time) {
    }

    public void close() {
    }

    public void endCommit(IImportChangeSet importChangeSet) {
    }

    public void endPhase(String statisticsName) {
    }

    public void startPhase(String statisticsName) {
    }
}

