/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.internal.IImportAcceptHelper;
import com.ibm.team.scm.client.importz.internal.SyncImportParticipant;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ImportAcceptHelper
implements IImportAcceptHelper {
    private SyncImportParticipant participant;
    private Set committedChangeSets;
    private Map committedStateRevisionMap;

    public ImportAcceptHelper(SyncImportParticipant participant) {
        this.participant = participant;
        this.committedChangeSets = new HashSet(participant.getCommittedChangeSets());
        this.committedStateRevisionMap = new CachedDiskBackedHashMap(participant.getBaseStateRevisionMap());
    }

    public void postAccept(List acceptedChangeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IChangeSetHandle cs : acceptedChangeSetHandles) {
            this.committedChangeSets.add(cs.getItemId().getUuidValue());
        }
        List changeSets = this.getChangeSets(acceptedChangeSetHandles, monitor);
        for (IChangeSet cs : changeSets) {
            for (IChange change : cs.changes()) {
                String revision;
                String state;
                if (change.afterState() != null) {
                    state = change.afterState().getStateId().getUuidValue();
                    revision = (String)this.participant.getStateRevisionMap().get(state);
                    if (revision != null) {
                        this.committedStateRevisionMap.put(state, revision);
                    }
                }
                if (change.beforeState() != null) {
                    state = change.beforeState().getStateId().getUuidValue();
                    revision = (String)this.participant.getStateRevisionMap().get(state);
                    if (revision != null) {
                        this.committedStateRevisionMap.put(state, revision);
                    }
                }
                for (IVersionableHandle item : change.mergeStates()) {
                    if (item == null) continue;
                    String state2 = item.getStateId().getUuidValue();
                    String revision2 = (String)this.participant.getStateRevisionMap().get(state2);
                    if (revision2 == null) continue;
                    this.committedStateRevisionMap.put(state2, revision2);
                }
            }
        }
        this.participant.acceptedChangeSets(acceptedChangeSetHandles, this.committedStateRevisionMap);
    }

    protected List getChangeSets(List changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspace().teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
    }

    protected IWorkspaceConnection getWorkspace() {
        return this.participant.getWorkspace();
    }

    protected IComponent getComponent() {
        return this.participant.getComponent();
    }

    protected Set getCommittedChangeSets() {
        return this.committedChangeSets;
    }

    protected Map getStateRevisionMap() {
        return this.committedStateRevisionMap;
    }

    protected SyncImportParticipant getParticipant() {
        return this.participant;
    }
}

