/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.AbstractChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.IChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;

public class ChangeArchiveStatistics
extends AbstractChangeArchiveStatistics
implements IChangeArchiveStatistics {
    private long importStartTime;
    private long commitStartTime;
    private PrintStream debugStream = System.out;
    private final IStatistics statistics;
    private final IWorkspaceConnection connection;
    private long phaseStart;
    private Set<String> phases = new HashSet<String>();

    public ChangeArchiveStatistics(IWorkspaceConnection connection) {
        String filename;
        this.connection = connection;
        this.statistics = connection.teamRepository().statistics();
        this.importStartTime = System.currentTimeMillis();
        if (DebugUtils.DEBUG_TIMINGS && (filename = DebugUtils.DEBUG_TIMINGS_LOG_FILE) != null && filename.length() > 0) {
            try {
                File file = new File(filename);
                this.debugStream = new PrintStream(new FileOutputStream(file));
            }
            catch (Exception exception) {}
        }
    }

    public void startCommit(IImportChangeSet importChangeSet, long time, boolean preflight) {
        this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Set Read Time", time);
        this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Set Count", 1L);
        this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Count", (long)importChangeSet.getChanges().size());
        super.startCommit(importChangeSet, time, preflight);
        if (!preflight) {
            this.commitStartTime = System.currentTimeMillis();
            if (DebugUtils.DEBUG_TIMINGS) {
                this.debugStream.println(String.valueOf(this.commitStartTime) + ": Starting to import " + importChangeSet.getChanges().size() + " changes of '" + importChangeSet.asCommentMessage(true, true) + "'");
            }
        }
    }

    public String toDescriptionString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Total change sets: " + this.getChangeSetCount());
        buffer.append('\n');
        buffer.append("Total changes: " + this.getChangesCount());
        buffer.append('\n');
        buffer.append("Total contributors: " + this.getContributorsCount());
        buffer.append('\n');
        buffer.append("Largest change set contains " + this.getLargestChangeSetSize() + " changes");
        buffer.append('\n');
        long timeSpan = this.timeSpan();
        long diffHours = timeSpan / 3600000L;
        long diffDays = timeSpan / 86400000L;
        long diffYears = diffDays / 365L;
        long diffYearsRemain = Math.round((double)(diffDays % 365L) / 365.0 * 100.0);
        buffer.append("Changes happened over " + diffYears + "." + diffYearsRemain + " years or " + diffDays + " days or " + diffHours + " hours");
        buffer.append('\n');
        return buffer.toString();
    }

    public int getChangeSetCount() {
        return (int)this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Set Count");
    }

    Object getContext() {
        return this.connection.getResolvedWorkspace().getItemId();
    }

    public int getChangesCount() {
        return (int)this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Count");
    }

    public void changesCollected(long time) {
        this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Collect Changes", time);
        if (DebugUtils.DEBUG_TIMINGS) {
            this.debugStream.println(">Preparing changes took " + time);
        }
    }

    public void changesCommited(long time) {
        this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Commit Changes", time);
        if (DebugUtils.DEBUG_TIMINGS) {
            this.debugStream.println(">Commiting changes took " + time);
        }
    }

    public void endCommit(IImportChangeSet importChangeSet) {
        long end = System.currentTimeMillis();
        long commitTime = end - this.commitStartTime;
        this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change set Commit Time", commitTime);
        if (DebugUtils.DEBUG_TIMINGS) {
            this.debugStream.println(String.valueOf(end) + ": Import of change took " + commitTime);
            this.debugStream.println();
            if (this.getChangeSetCount() % 100 == 0) {
                this.printAverages(System.out);
            }
        }
    }

    private void printAverages(PrintStream out) {
        long totalTime = this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change set Commit Time");
        long baselineCount = this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Baseline Count");
        out.println("Change sets " + this.getChangeSetCount() + " changes " + this.getChangesCount() + " baselines " + baselineCount);
        if (this.getChangeSetCount() > 0 && this.getChangesCount() > 0) {
            out.println("Average time for each change set: " + totalTime / (long)this.getChangeSetCount());
            out.println("Average time for each change: " + totalTime / (long)this.getChangesCount());
            out.println("Average time reading change set: " + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Set Read Time") / (long)this.getChangeSetCount() + "/" + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Change Set Read Time") / (long)this.getChangesCount());
            out.println("Average time collecting changes: " + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Collect Changes") / (long)this.getChangeSetCount() + "/" + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Collect Changes") / (long)this.getChangesCount());
            out.println("Average time comitting changes: " + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Commit Changes") / (long)this.getChangeSetCount() + "/" + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Commit Changes") / (long)this.getChangesCount());
            for (String phase : this.phases) {
                out.println("Average time '" + phase + "': " + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), phase) / (long)this.getChangeSetCount() + "/" + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), phase) / (long)this.getChangesCount());
            }
        }
        if (baselineCount > 0L) {
            out.println("Average time per baseline: " + this.statistics.getStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), "Baseline Time") / baselineCount);
        }
    }

    public void close() {
        if (DebugUtils.DEBUG_TIMINGS) {
            long duration = System.currentTimeMillis() - this.importStartTime;
            long seconds = duration / 1000L;
            String totalTime = String.valueOf(seconds / 60L) + "min " + seconds % 60L + "sec";
            this.printAverages(System.out);
            this.debugStream.println(this.toDescriptionString());
            this.debugStream.println("Total import time: " + totalTime);
            this.printAverages(this.debugStream);
            if (this.debugStream != System.out) {
                System.out.println(this.toDescriptionString());
                System.out.println("Total import time: " + totalTime);
                this.debugStream.close();
            }
        }
    }

    public void startPhase(String statisticsName) {
        this.phases.add(statisticsName);
        this.phaseStart = System.currentTimeMillis();
    }

    public void endPhase(String statisticsName) {
        if (this.phaseStart != -1L) {
            this.statistics.incStatisticValue("com.ibm.team.scm.client.importz.importType", this.getContext(), statisticsName, System.currentTimeMillis() - this.phaseStart);
            this.phaseStart = -1L;
        }
    }
}

