/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.filesystem.ui.util.IgnoreOutOfSyncOnUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractSyncFileWriter {
    public static final String SYNC_STATE_FOLDER = ".CVS/";
    public static final String SYNC_STATE_FILENAME = ".CVS/.Sync_State";
    private static final byte[] PROJECT_DESCRIPTION_CONTENT = ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>" + ".CVS/".substring(0, ".CVS/".indexOf(47)) + "</name>\n" + "\t<comment></comment>\n" + "\t<projects>\n" + "\t</projects>\n" + "\t<buildSpec>\n" + "\t</buildSpec>\n" + "\t<natures>\n" + "\t</natures>\n" + "</projectDescription>\n").getBytes();
    private static final String PROJECT_DESCRIPTION_FILE = ".project";
    protected IWorkspaceConnection workspace;
    protected IComponent component;
    protected Set committedChangeSets;
    protected Map stateRevisionMap;
    protected boolean markDelivered;
    protected IChangeSetHandle lastChangeSet;
    protected IUpdateReport lastUpdateReport;

    public AbstractSyncFileWriter(IWorkspaceConnection workspace, IComponent component, Set committedChangeSets, Map stateRevisionMap, boolean markDelivered) {
        this.workspace = workspace;
        this.component = component;
        this.committedChangeSets = committedChangeSets;
        this.stateRevisionMap = stateRevisionMap;
        this.markDelivered = markDelivered;
    }

    public void writeFile(File file) throws IOException {
        this.writeTmpFile(new FileOutputStream(file), null);
    }

    protected void writeTmpFile(OutputStream out, String csUuid) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        try {
            this.writeHeader(writer);
            this.writeCommittedChangeSets(writer, csUuid);
            this.writeStateMap(writer);
            this.writeBody(writer);
        }
        finally {
            writer.close();
        }
    }

    public void write(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IUpdateReport report;
        IChangeSetHandle cs;
        block21: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.AbstractSyncFileWriter_13, (int)100);
            ArrayList<IWorkspaceConnection.ISaveOp> configOps = new ArrayList<IWorkspaceConnection.ISaveOp>();
            IFileItem file = this.getStateFile(configOps, (IProgressMonitor)progress.newChild(5));
            boolean success = false;
            cs = null;
            try {
                try {
                    ITeamRepository repo = this.workspace.teamRepository();
                    cs = this.workspace.createChangeSet((IComponentHandle)this.component, (IProgressMonitor)progress.newChild(5));
                    SCMPlatform.getWorkspaceManager((ITeamRepository)repo).setComment(cs, SCMImportMessages.AbstractSyncFileWriter_15, (IProgressMonitor)progress.newChild(1));
                    final TemporaryOutputStream tmpOut = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)-1L);
                    boolean tmpFileWritten = false;
                    try {
                        this.writeTmpFile((OutputStream)tmpOut, cs.getItemId().getUuidValue());
                        tmpFileWritten = true;
                    }
                    catch (Throwable throwable) {
                        if (!tmpFileWritten) {
                            try {
                                tmpOut.dispose();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (!tmpFileWritten) {
                        try {
                            tmpOut.dispose();
                        }
                        catch (IOException iOException) {}
                    }
                    IFileContent content = FileSystemCore.getContentManager((ITeamRepository)this.workspace.teamRepository()).storeContent("us-ascii", FileLineDelimiter.LINE_DELIMITER_PLATFORM, new AbstractVersionedContentManagerInputStreamProvider(){

                        public void dispose() throws IOException, TeamRepositoryException {
                            tmpOut.dispose();
                        }

                        public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                            return tmpOut.getInputStream(null);
                        }

                        public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                            return in;
                        }
                    }, file.getContent() == null ? null : file.getContent().getHash(), (IProgressMonitor)progress.newChild(67));
                    file.setContentType("text/plain");
                    file.setContent(content);
                    configOps.add(this.workspace.configurationOpFactory().save((IVersionable)file));
                    report = this.workspace.commit(cs, configOps, (IProgressMonitor)progress.newChild(5));
                    this.workspace.closeChangeSets(Collections.singletonList(cs), (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(SCMImportMessages.AbstractSyncFileWriter_16, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (!success && cs != null) {
                    try {
                        this.workspace.discardChangeSets(false, Collections.singletonList(cs), (IProgressMonitor)progress.newChild(0));
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                }
                throw throwable;
            }
            if (!success && cs != null) {
                try {
                    this.workspace.discardChangeSets(false, Collections.singletonList(cs), (IProgressMonitor)progress.newChild(0));
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            IgnoreOutOfSyncOnUpdate problemHandler = new IgnoreOutOfSyncOnUpdate(null);
            try {
                new UpdateOperation(this.workspace, Collections.singletonList(report), 3, (UpdateDilemmaHandler)problemHandler, null).run((IProgressMonitor)progress.newChild(15));
            }
            catch (FileSystemClientException e) {
                if (e.getStatus().getSeverity() != 4) break block21;
                throw e;
            }
        }
        monitor.done();
        this.lastChangeSet = cs;
        this.lastUpdateReport = report;
    }

    private IFileItem getStateFile(Collection configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.AbstractSyncFileWriter_17, (int)100);
        try {
            IFolderHandle root = this.component.getRootFolder();
            String[] segments = SYNC_STATE_FILENAME.split("/");
            IVersionableHandle handle = this.workspace.configuration((IComponentHandle)this.component).resolvePath(root, segments, (IProgressMonitor)progress.newChild(50));
            if (handle instanceof IFileItemHandle) {
                IFileItem iFileItem = (IFileItem)this.workspace.configuration((IComponentHandle)this.component).fetchCompleteItem(handle, (IProgressMonitor)progress.newChild(50)).getWorkingCopy();
                return iFileItem;
            }
            if (handle != null) {
                throw new IllegalStateException("A non-file exists at .CVS/.Sync_State");
            }
            IFolderHandle folder = AbstractSyncFileWriter.createDirHierarchy(this.workspace, this.component, configOps, (IProgressMonitor)progress.newChild(50));
            IFileItem stateFile = (IFileItem)IFileItem.ITEM_TYPE.createItem();
            stateFile.setFileTimestamp(new Date());
            stateFile.setName(segments[segments.length - 1]);
            stateFile.setParent(folder);
            IFileItem iFileItem = stateFile;
            return iFileItem;
        }
        finally {
            monitor.done();
        }
    }

    protected void writeCommittedChangeSets(BufferedWriter writer, String thisChangeSetId) throws IOException {
        writer.write(Integer.toString(this.committedChangeSets.size() + (this.markDelivered ? 1 : 0)));
        writer.newLine();
        Iterator i = this.committedChangeSets.iterator();
        while (i.hasNext()) {
            writer.write((String)i.next());
            writer.newLine();
        }
        if (this.markDelivered) {
            writer.write(thisChangeSetId);
            writer.newLine();
        }
    }

    protected void writeStateMap(BufferedWriter writer) throws IOException {
        writer.write(Integer.toString(this.stateRevisionMap.size()));
        writer.newLine();
        for (Map.Entry entry : this.stateRevisionMap.entrySet()) {
            String state = (String)entry.getKey();
            String revision = (String)entry.getValue();
            writer.write(state);
            writer.newLine();
            writer.write(revision);
            writer.newLine();
        }
    }

    public IChangeSetHandle getLastChangeSet() {
        return this.lastChangeSet;
    }

    public IUpdateReport getLastUpdateReport() {
        return this.lastUpdateReport;
    }

    protected abstract void writeHeader(BufferedWriter var1) throws IOException;

    protected abstract void writeBody(BufferedWriter var1) throws IOException;

    public static IFolderHandle createDirHierarchy(IWorkspaceConnection workspace, IComponent component, Collection configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.AbstractSyncFileWriter_20, (int)100);
        String[] segments = SYNC_STATE_FILENAME.split("/");
        SubMonitor subProgress = progress.newChild(75);
        subProgress.beginTask("", 2);
        IFolderHandle folder = component.getRootFolder();
        Map children = workspace.configuration((IComponentHandle)component).childEntries(component.getRootFolder(), (IProgressMonitor)subProgress.newChild(1));
        int i = 0;
        while (i < segments.length - 1) {
            IVersionableHandle handle = (IVersionableHandle)children.get(segments[i]);
            if (handle == null) break;
            if (!(handle instanceof IFolderHandle)) {
                throw new IllegalStateException(String.valueOf(SCMImportMessages.AbstractSyncFileWriter_23) + SYNC_STATE_FILENAME);
            }
            folder = (IFolderHandle)handle;
            subProgress.setWorkRemaining(2);
            children = workspace.configuration((IComponentHandle)component).childEntries(folder, (IProgressMonitor)subProgress.newChild(1));
            ++i;
        }
        while (i < segments.length - 1) {
            IFolder tmp = (IFolder)IFolder.ITEM_TYPE.createItem();
            tmp.setParent(folder);
            tmp.setName(segments[i]);
            configOps.add(workspace.configurationOpFactory().save((IVersionable)tmp));
            if (i == 0) {
                IFileItem projectFile = (IFileItem)IFileItem.ITEM_TYPE.createItem();
                projectFile.setFileTimestamp(new Date());
                IFileContent content = FileSystemCore.getContentManager((ITeamRepository)workspace.teamRepository()).storeContent("us-ascii", FileLineDelimiter.LINE_DELIMITER_PLATFORM, (AbstractVersionedContentManagerInputStreamProvider)new VersionedContentManagerByteArrayInputStreamPovider(PROJECT_DESCRIPTION_CONTENT), null, (IProgressMonitor)progress.newChild(25));
                projectFile.setContentType("text/plain");
                projectFile.setContent(content);
                projectFile.setParent((IFolderHandle)tmp);
                projectFile.setName(PROJECT_DESCRIPTION_FILE);
                configOps.add(workspace.configurationOpFactory().save((IVersionable)projectFile));
            }
            folder = tmp;
            ++i;
        }
        monitor.done();
        return folder;
    }
}

