/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IContentManagerInputStreamProvider;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.IUploadHandler;
import com.ibm.team.repository.client.internal.ProgressHandlingContentManagerSession;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class SynchronousContentManagerSession
extends ProgressHandlingContentManagerSession {
    private final IContentManager contentManager;
    MultiStatus errorStatus = new MultiStatus("com.ibm.team.repository.client", 0, new String(), null);

    public SynchronousContentManagerSession(String name, int totalWork, IContentManager cm, IProgressMonitor mon) {
        super(name, totalWork, true, mon);
        this.contentManager = cm;
    }

    public void join() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void internalRetrieveContent(IContent content, IDownloadHandler handler) throws TeamRepositoryException {
        try {
            this.handleCancel(content, handler);
            handler.downloadStart(content);
            InputStream in = this.contentManager.retrieveContentStream(content, (IProgressMonitor)this.monitor.newChild(1));
            try {
                handler.downloadStreamAcquired(content, in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            this.handleCancel(content, handler);
            handler.downloadCompleted(content);
            this.handleCancel(content, handler);
        }
        catch (TeamRepositoryException e) {
            MultiStatus statusToReturn;
            block13: {
                statusToReturn = null;
                if (e.getCause() instanceof CoreException) {
                    statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, Messages.getServerString("SynchronousContentManagerSession.ErrorRetrievingContent"), (Throwable)e);
                    statusToReturn.add(((CoreException)e.getCause()).getStatus());
                } else {
                    statusToReturn = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("SynchronousContentManagerSession.ErrorRetrievingContent"), (Throwable)e);
                }
                try {
                    handler.downloadFailed(content, e);
                }
                catch (Exception exception) {
                    Status anotherError = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("SynchronousContentManagerSession.ErrorNotifyingHandler"), (Throwable)e);
                    if (statusToReturn instanceof MultiStatus) {
                        statusToReturn.add((IStatus)anotherError);
                        break block13;
                    }
                    statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, new IStatus[]{statusToReturn, anotherError}, Messages.getServerString("SynchronousContentManagerSession.ErrorRetrievingContent"), null);
                }
            }
            this.errorStatus.add((IStatus)statusToReturn);
        }
    }

    protected void internalStoreContent(IUploadHandler handler) throws TeamRepositoryException {
        SubMonitor progress = this.monitor.newChild(1).setWorkRemaining(100);
        while (true) {
            try {
                this.handleCancel(handler);
                IContentManagerInputStreamProvider streamProvider = handler.getStreamProvider();
                String contentType = handler.getContentType();
                String characterEncoding = handler.getCharacterEncoding();
                LineDelimiter lineDelimiter = handler.getLineDelimiter();
                UUID predecessorId = handler.getPredecessorContentId();
                handler.uploadStart();
                IContent content = this.contentManager.storeContent(contentType, characterEncoding, lineDelimiter, streamProvider, predecessorId, (IProgressMonitor)progress.newChild(95));
                this.handleCancel(handler);
                handler.uploadCompleted(content);
                this.handleCancel(handler);
            }
            catch (TeamRepositoryException e) {
                MultiStatus statusToReturn;
                block10: {
                    statusToReturn = null;
                    if (e.getCause() instanceof CoreException) {
                        statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, Messages.getServerString("SynchronousContentManagerSession.ErrorStoringContent"), (Throwable)e);
                        statusToReturn.add(((CoreException)e.getCause()).getStatus());
                    } else {
                        statusToReturn = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("SynchronousContentManagerSession.ErrorStoringContent"), (Throwable)e);
                    }
                    try {
                        progress.setWorkRemaining(101);
                        if (handler.uploadFailed(e, (IProgressMonitor)progress.newChild(1))) {
                            continue;
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        Status anotherError = new Status(4, "com.ibm.team.repository.client", 0, Messages.getServerString("SynchronousContentManagerSession.ErrorNotifyingHandler"), (Throwable)e);
                        if (statusToReturn instanceof MultiStatus) {
                            statusToReturn.add((IStatus)anotherError);
                        } else {
                            statusToReturn = new MultiStatus("com.ibm.team.repository.client", 0, new IStatus[]{statusToReturn, anotherError}, Messages.getServerString("SynchronousContentManagerSession.ErrorStoringContent"), null);
                        }
                        break block10;
                    }
                    continue;
                }
                this.errorStatus.add((IStatus)statusToReturn);
            }
            break;
        }
    }

    private void handleCancel(IContent content, IDownloadHandler handler) {
        if (this.isCanceled()) {
            try {
                handler.downloadCanceled(content);
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(e);
            }
            throw new OperationCanceledException();
        }
    }

    private void handleCancel(IUploadHandler handler) {
        if (this.isCanceled()) {
            try {
                handler.uploadCanceled();
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(e);
            }
            throw new OperationCanceledException();
        }
    }

    public IStatus[] getErrorStatus() {
        return this.errorStatus.getChildren();
    }
}

