/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.internal.TeamPlatformObject;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorDetailsHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IContributorService;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ContributorManager
extends TeamPlatformObject
implements IContributorManager {
    private final IContributorService contributorService;
    private static final IItemQuery ALL_CONTRIBUTORS_QUERY = ContributorManager.createAllContributorsQuery();
    private static final Object[] EMPTY_QUERY_ARGUMENTS = new Object[0];
    private static final int QUERY_PAGE_SIZE = 100;

    private static IItemQuery createAllContributorsQuery() {
        BaseContributorQueryModel.ContributorQueryModel contributorQueryModel = BaseContributorQueryModel.ContributorQueryModel.ROOT;
        IItemQuery allContributorsQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)contributorQueryModel);
        return allContributorsQuery;
    }

    public ContributorManager(TeamRepository repository) {
        super(repository);
        this.contributorService = (IContributorService)repository.getServiceInterface(IContributorService.class);
        if (this.contributorService == null) {
            throw new IllegalArgumentException("Unable to initialize contributor service");
        }
    }

    public IContributor saveContributor(final IContributor contributorWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorWorkingCopy == null) {
            throw new IllegalArgumentException("The contributor is null");
        }
        if (!contributorWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("The contributor is not a working copy");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributor>(){

            @Override
            public IContributor run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor = ClientUtil.beginMonitor(monitor, 100);
                try {
                    IContributor contributor = ContributorManager.this.contributorService.saveContributor(contributorWorkingCopy);
                    ClientUtil.fixWorkingCopy((Auditable)contributorWorkingCopy, contributor.getStateId());
                    ClientUtil.makeImmutable(ContributorManager.this.teamRepository(), (IItemHandle)contributorWorkingCopy);
                    IContributor iContributor = (IContributor)ContributorManager.this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(contributor)).get(0);
                    return iContributor;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    public void deleteContributor(final IContributorHandle contributorHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorHandle == null) {
            throw new IllegalArgumentException("The contributor handle is null");
        }
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

            @Override
            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor = ClientUtil.beginMonitor(monitor, 100);
                try {
                    IContributorDetailsHandle detailsHandle;
                    IContributorHandle createdHandle = contributorHandle;
                    if (contributorHandle instanceof IContributor) {
                        createdHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(contributorHandle.getItemId(), contributorHandle.getStateId());
                    }
                    IContributor contributor = (IContributor)ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)createdHandle);
                    ContributorManager.this.contributorService.deleteContributor(createdHandle);
                    ArrayList<Object> toDelete = new ArrayList<Object>(2);
                    toDelete.add(createdHandle);
                    if (contributor != null && contributor.isPropertySet(IContributor.DETAILS_PROPERTY) && (detailsHandle = contributor.getDetails()) != null) {
                        toDelete.add(detailsHandle);
                    }
                    ContributorManager.this.teamRepository().itemManager().applyItemDeletes(toDelete);
                }
                finally {
                    monitor.done();
                }
                return null;
            }
        }, monitor);
    }

    public List fetchAllContributors(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<List>(){

            @Override
            public List run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor = ClientUtil.beginMonitor(monitor, 100);
                    ArrayList contributors = new ArrayList();
                    IItemQueryPage page = ContributorManager.this.getQueryService().queryItems(ALL_CONTRIBUTORS_QUERY, EMPTY_QUERY_ARGUMENTS, 100);
                    contributors.addAll(ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(page.getItemHandles(), 0, null));
                    monitor.worked(10);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 90);
                    int size = page.getSize();
                    subMonitor.beginTask(null, size * 100);
                    while (page.hasNext()) {
                        page = (IItemQueryPage)ContributorManager.this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), page.getSize());
                        subMonitor.worked(50);
                        contributors.addAll(ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(page.getItemHandles(), 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 50)));
                    }
                    List list = Collections.unmodifiableList(contributors);
                    return list;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    public IContributor fetchContributorByUserId(final String userId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (userId == null) {
            throw new IllegalArgumentException("The userId is null");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributor>(){

            @Override
            public IContributor run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor = ClientUtil.beginMonitor(monitor, 100);
                try {
                    IContributorHandle contributor = ContributorManager.this.contributorService.fetchContributorByUserId(userId);
                    monitor.worked(50);
                    if (contributor == null) {
                        String message = NLS.bind((String)Messages.getServerString("ContributorManager.0"), (Object)userId, (Object[])new Object[0]);
                        throw new ItemNotFoundException(message);
                    }
                    IContributor iContributor = (IContributor)ContributorManager.this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)contributor, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    return iContributor;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    public IContributorDetails setContributorDetails(final IContributorHandle contributorHandle, final IContributorDetails detailsWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorHandle == null) {
            throw new IllegalArgumentException("The contributor handle is null");
        }
        if (detailsWorkingCopy == null) {
            throw new IllegalArgumentException("The contributor details are null");
        }
        if (!detailsWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("The contributor details are not a working copy");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributorDetails>(){

            @Override
            public IContributorDetails run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor = ClientUtil.beginMonitor(monitor, 100);
                try {
                    IContributorDetails details = ContributorManager.this.contributorService.setContributorDetails(contributorHandle, detailsWorkingCopy);
                    monitor.worked(50);
                    ClientUtil.fixWorkingCopy((Auditable)detailsWorkingCopy, details.getStateId());
                    ClientUtil.makeImmutable(ContributorManager.this.teamRepository(), (IItemHandle)detailsWorkingCopy);
                    details = (IContributorDetails)ContributorManager.this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(details)).get(0);
                    IContributor contributor = (IContributor)ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)contributorHandle);
                    if (contributor != null && contributor.isPropertySet(IContributor.DETAILS_PROPERTY) && !contributor.getDetails().sameItemId((IItemHandle)details)) {
                        ContributorManager.this.teamRepository().itemManager().refreshSharedItems(Collections.singletonList(contributor), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    IContributorDetails iContributorDetails = details;
                    return iContributorDetails;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }
}

