/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.service.managers.clearquest.common;

import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.interop.service.managers.clearquest.common.Messages;
import java.nio.CharBuffer;
import java.text.MessageFormat;

public class XMLControlEscaper {
    private static final char[] UNICODE_ESCAPE = new char[]{'\\', 'u'};
    private static final String ORIGINAL_UNICODE_LITERAL = "\\u";
    private static final char[] NUL = new char[]{'\\', 'u', '0', '0', '0', '0'};
    private static final char[] SOH = new char[]{'\\', 'u', '0', '0', '0', '1'};
    private static final char[] STX = new char[]{'\\', 'u', '0', '0', '0', '2'};
    private static final char[] ETX = new char[]{'\\', 'u', '0', '0', '0', '3'};
    private static final char[] EOT = new char[]{'\\', 'u', '0', '0', '0', '4'};
    private static final char[] ENQ = new char[]{'\\', 'u', '0', '0', '0', '5'};
    private static final char[] ACK = new char[]{'\\', 'u', '0', '0', '0', '6'};
    private static final char[] BEL = new char[]{'\\', 'u', '0', '0', '0', '7'};
    private static final char[] BS = new char[]{'\\', 'u', '0', '0', '0', '8'};
    private static final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};
    private static final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
    private static final char[] VT = new char[]{'\\', 'u', '0', '0', '0', 'B'};
    private static final char[] FF = new char[]{'\\', 'u', '0', '0', '0', 'C'};
    private static final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
    private static final char[] SO = new char[]{'\\', 'u', '0', '0', '0', 'E'};
    private static final char[] SI = new char[]{'\\', 'u', '0', '0', '0', 'F'};
    private static final char[] DLE = new char[]{'\\', 'u', '0', '0', '1', '0'};
    private static final char[] DC1 = new char[]{'\\', 'u', '0', '0', '1', '1'};
    private static final char[] DC2 = new char[]{'\\', 'u', '0', '0', '1', '2'};
    private static final char[] DC3 = new char[]{'\\', 'u', '0', '0', '1', '3'};
    private static final char[] DC4 = new char[]{'\\', 'u', '0', '0', '1', '4'};
    private static final char[] NAK = new char[]{'\\', 'u', '0', '0', '1', '5'};
    private static final char[] SYN = new char[]{'\\', 'u', '0', '0', '1', '6'};
    private static final char[] ETB = new char[]{'\\', 'u', '0', '0', '1', '7'};
    private static final char[] CAN = new char[]{'\\', 'u', '0', '0', '1', '8'};
    private static final char[] EM = new char[]{'\\', 'u', '0', '0', '1', '9'};
    private static final char[] SUB = new char[]{'\\', 'u', '0', '0', '1', 'A'};
    private static final char[] ESC = new char[]{'\\', 'u', '0', '0', '1', 'B'};
    private static final char[] FS = new char[]{'\\', 'u', '0', '0', '1', 'C'};
    private static final char[] GS = new char[]{'\\', 'u', '0', '0', '1', 'D'};
    private static final char[] RS = new char[]{'\\', 'u', '0', '0', '1', 'E'};
    private static final char[] US = new char[]{'\\', 'u', '0', '0', '1', 'F'};
    private static final char[] BACKSLASH = new char[]{'\\', 'u', '0', '0', '5', 'C'};
    private static final char[][] CONTROL_CHARACTERS = new char[][]{NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL, BS, TAB, LF, VT, FF, CR, SO, SI, DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB, CAN, EM, SUB, ESC, FS, GS, RS, US};

    private XMLControlEscaper() {
    }

    public static String encodeControlChars(String input) {
        boolean changed = false;
        int inputLength = input.length();
        CharBuffer buffer = CharBuffer.allocate(input.length() * 6);
        int inputPos = 0;
        char ch = '\u0000';
        while (inputLength-- > 0) {
            ch = input.charAt(inputPos++);
            switch (ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    int pos = buffer.position();
                    while (pos != 0 && buffer.get(pos - 1) == '\\') {
                        --pos;
                    }
                    int cnt = buffer.position() - pos;
                    buffer.position(pos);
                    while (cnt != 0) {
                        XMLControlEscaper.replaceChars(buffer, BACKSLASH);
                        --cnt;
                    }
                    XMLControlEscaper.replaceChars(buffer, CONTROL_CHARACTERS[ch]);
                    changed = true;
                    break;
                }
                case 'u': {
                    if (inputPos >= 2 && input.charAt(inputPos - 2) == '\\') {
                        XMLControlEscaper.replaceChars(buffer, UNICODE_ESCAPE);
                        changed = true;
                        break;
                    }
                    buffer.append(ch);
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        String retVal = input;
        if (changed) {
            retVal = new String(buffer.array(), 0, buffer.position());
        }
        return retVal;
    }

    private static void replaceChars(CharBuffer buffer, char[] replacement) {
        buffer.put(replacement, 0, replacement.length);
    }

    public static String decodeControlChars(String value) throws InteropException {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value.indexOf(ORIGINAL_UNICODE_LITERAL) == -1) {
            return value;
        }
        try {
            int inputLength = value.length();
            int inputPos = 0;
            StringBuffer buf = new StringBuffer(inputLength);
            while (inputPos < inputLength) {
                char ch;
                if ((ch = value.charAt(inputPos++)) == '\\' && inputPos + 1 < inputLength) {
                    if (value.charAt(inputPos) == '\\' && value.charAt(inputPos + 1) == 'u') {
                        buf.append(ORIGINAL_UNICODE_LITERAL);
                        inputPos += 2;
                        continue;
                    }
                    if (value.charAt(inputPos) == 'u' && inputPos + 4 < inputLength) {
                        String numString = value.substring(inputPos + 1, inputPos + 5);
                        int cc = Integer.parseInt(numString, 16);
                        buf.append((char)cc);
                        inputPos += 5;
                        continue;
                    }
                    buf.append(ch);
                    continue;
                }
                buf.append(ch);
            }
            value = buf.toString();
        }
        catch (Throwable ex) {
            throw new InteropException(MessageFormat.format(Messages.getString("XMLEscapeUtil.ErrorUnrecognizedControlSequence"), value), ex);
        }
        return value;
    }
}

