/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.service.managers.clearquest.common;

import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.interop.service.managers.clearquest.common.Messages;
import java.net.URI;
import java.net.URLDecoder;
import java.text.MessageFormat;

public class CQRepositoryInfoParser {
    private static int uniqueIdPrefixLength = "CQ:cq.repo.cq-record:".length();
    private static CQRepositoryInfoParser singleton = new CQRepositoryInfoParser();

    private CQRepositoryInfoParser() {
    }

    public static CQRepositoryInfoParser getCQRepositoryInfoParser() {
        return singleton;
    }

    public String deriveCQRecordTypeNameFromExternalTypeName(String externalTypeName) throws InteropException {
        int indexOfThirdLastDot = externalTypeName.lastIndexOf(46);
        if (indexOfThirdLastDot != -1) {
            return externalTypeName.substring(indexOfThirdLastDot + 1);
        }
        throw new InteropException(MessageFormat.format(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MISSING_A_DOT"), externalTypeName));
    }

    public String deriveCQRecordTypeNameFromUniqueId(String uniqueId) throws InteropException {
        String decodedUniqueId;
        block8: {
            decodedUniqueId = null;
            try {
                decodedUniqueId = URLDecoder.decode(uniqueId, "UTF-8");
            }
            catch (Exception e) {
                throw new InteropException(e);
            }
            try {
                if (!decodedUniqueId.contains("Attachments") || decodedUniqueId.split("/").length != 5) break block8;
                return "attachments";
            }
            catch (Exception exception) {
                throw new InteropException(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MALFORMED_IN_SOME_WAY"));
            }
        }
        if (decodedUniqueId.startsWith("CQ:repo/cq-record:")) {
            int indexOfFirstSlash = decodedUniqueId.indexOf(47, uniqueIdPrefixLength);
            if (indexOfFirstSlash != -1) {
                return decodedUniqueId.substring(uniqueIdPrefixLength, indexOfFirstSlash);
            }
            throw new InteropException(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MISSING_A_SLASH"));
        }
        int indexOfFirstSlash = decodedUniqueId.indexOf(47);
        int indexOfSecondColon = decodedUniqueId.indexOf(58, decodedUniqueId.indexOf(58) + 1);
        if (indexOfFirstSlash == -1 || indexOfSecondColon == -1) {
            throw new InteropException(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MISSING_A_SLASH_OR_COLON"));
        }
        return decodedUniqueId.substring(indexOfSecondColon + 1, indexOfFirstSlash);
    }

    public String deriveCQRecordTypeNameFromURI(URI uri) throws InteropException {
        return this.deriveCQRecordTypeNameFromUniqueId(uri.toASCIIString());
    }
}

