/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.rcp.ui.internal;

import com.ibm.team.interop.client.admin.IItemConnectorAdminClient;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.IExternalState;
import com.ibm.team.interop.common.IExternalStateHandle;
import com.ibm.team.interop.common.IPropertyMapping;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.common.dto.IManagerInfoDTO;
import com.ibm.team.interop.common.dto.IPropertyInfoDTO;
import com.ibm.team.interop.common.dto.ITypeInfoDTO;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.AbstractWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProxyWorkingCopy
extends AbstractWorkingCopy {
    private final RevertJob fRevertJob = new RevertJob();
    private final Job fSynchronizeIncoming = new Job(Messages.ExternalProxyWorkingCopy_INCOMING_SYNC_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (ExternalProxyWorkingCopy.this.fProxy == null || ExternalProxyWorkingCopy.this.fExternalState == null) {
                    return Status.CANCEL_STATUS;
                }
                ExternalProxyWorkingCopy.this.fProxy = ExternalProxyWorkingCopy.this.adminClient().synchronizeIncomingAndWait((IExternalProxyHandle)ExternalProxyWorkingCopy.this.fProxy, null, null, null, monitor);
                ExternalProxyWorkingCopy.this.refreshLinkedItem(monitor);
                ExternalProxyWorkingCopy.this.doRevert(RevertMode.FULL, monitor);
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };
    private final Job fSynchronizeOutgoing = new Job(Messages.ExternalProxyWorkingCopy_OUTGOING_SYNC_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (ExternalProxyWorkingCopy.this.fProxy == null || ExternalProxyWorkingCopy.this.fLinkedItemHandle == null) {
                    return Status.CANCEL_STATUS;
                }
                ExternalProxyWorkingCopy.this.fProxy = ExternalProxyWorkingCopy.this.adminClient().synchronizeOutgoingAndWait(ExternalProxyWorkingCopy.this.fLinkedItemHandle, null, null, monitor);
                ExternalProxyWorkingCopy.this.refreshLinkedItem(monitor);
                ExternalProxyWorkingCopy.this.doRevert(RevertMode.FULL, monitor);
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };
    private final Job fSetExternalStateMerged = new Job(Messages.ExternalProxyWorkingCopy_ACCEPT_EXTERNAL_STATE_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (ExternalProxyWorkingCopy.this.fProxy == null || ExternalProxyWorkingCopy.this.fExternalState == null || ExternalProxyWorkingCopy.this.fLinkedItemHandle == null) {
                    return Status.CANCEL_STATUS;
                }
                IAuditableHandle auditableItemHandle = null;
                if (ExternalProxyWorkingCopy.this.fLinkedItemHandle instanceof IAuditableHandle) {
                    auditableItemHandle = (IAuditableHandle)ExternalProxyWorkingCopy.this.fLinkedItemHandle;
                }
                ExternalProxyWorkingCopy.this.fProxy = ExternalProxyWorkingCopy.this.adminClient().synchronizeIncomingAndWait((IExternalProxyHandle)ExternalProxyWorkingCopy.this.fProxy, (IExternalStateHandle)ExternalProxyWorkingCopy.this.fExternalState, auditableItemHandle, null, monitor);
                ExternalProxyWorkingCopy.this.refreshLinkedItem(monitor);
                ExternalProxyWorkingCopy.this.doRevert(RevertMode.FULL, monitor);
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };
    private final Job fSetItemStateMerged = new Job(Messages.ExternalProxyWorkingCopy_ACCEPT_ITEM_STATE_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (ExternalProxyWorkingCopy.this.fProxy == null || ExternalProxyWorkingCopy.this.fExternalState == null || ExternalProxyWorkingCopy.this.fLinkedItemHandle == null) {
                    return Status.CANCEL_STATUS;
                }
                ExternalProxyWorkingCopy.this.fProxy = ExternalProxyWorkingCopy.this.adminClient().synchronizeOutgoingAndWait(ExternalProxyWorkingCopy.this.fLinkedItemHandle, (IExternalStateHandle)ExternalProxyWorkingCopy.this.fExternalState, null, monitor);
                ExternalProxyWorkingCopy.this.refreshLinkedItem(monitor);
                ExternalProxyWorkingCopy.this.doRevert(RevertMode.FULL, monitor);
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };
    private ISharedItemChangeListener fProxyChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IItem item = event.getSharedItem();
                if (item instanceof IExternalProxy && event.getAfterState() == null) {
                    ExternalProxyWorkingCopy.this.unregisterSharedItemListener();
                    ExternalProxyWorkingCopy.this.fRepository = null;
                    ExternalProxyWorkingCopy.this.fItemId = null;
                }
                ExternalProxyWorkingCopy.this.setValid(false);
                ExternalProxyWorkingCopy.this.fRevertJob.setSystem(true);
                ExternalProxyWorkingCopy.this.fRevertJob.schedule();
            }
        }
    };
    private static final String DOT = ".";
    private static EnumMap<IExternalProxy.SynchronizationStatus, String> SYNC_STATUS_TEXT = new EnumMap(IExternalProxy.SynchronizationStatus.class);
    private IItemConnectorAdminClient fAdminClient;
    private ITeamRepository fRepository;
    private UUID fItemId;
    private boolean fResolveState;
    private IExternalProxy fProxy;
    private IExternalState fExternalState;
    private Map<String, Object> fExternalProperties;
    private IItemHandle fLinkedItemHandle;
    private Map<String, Object> fLinkedItemProperties;
    private Map<String, Object> fLinkedItemRawProperties;
    private Map<String, String> fLinkedItemPropertiesDisplayNames;
    private Exception fLinkedItemError;
    private ISyncRule fSyncRule;
    private String fUri;
    private String fName;
    private String fExternalId;
    private IExternalProxy[] fIncomingBlocking;
    private IExternalProxy[] fOutgoingBlocking;

    static {
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.CONFLICT, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_CONFLICT);
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.CYCLE, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_CYCLE);
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.INCOMING_ERROR, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_INCOMING_ERROR);
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.OK, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_OK);
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.OUTGOING_ERROR, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_OUTGOING_ERROR);
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.PENDING, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_PENDING);
        SYNC_STATUS_TEXT.put(IExternalProxy.SynchronizationStatus.UNINITIALIZED, Messages.ExternalProxyWorkingCopy_SYNC_STATUS_UNITIALIZED);
    }

    public ExternalProxyWorkingCopy(ITeamRepository repository, UUID itemId, boolean resolveState) {
        this.fRepository = repository;
        this.fItemId = itemId;
        this.fResolveState = resolveState;
        this.setValid(false);
    }

    public ExternalProxyWorkingCopy(ITeamRepository repository, UUID itemId, boolean resolveState, Display display) throws TeamRepositoryException {
        super(display);
        this.fRepository = repository;
        this.fItemId = itemId;
        this.fResolveState = resolveState;
        this.setValid(false);
        this.doRevert(RevertMode.FULL, null);
    }

    public ExternalProxyWorkingCopy(ITeamRepository repository, IExternalProxy proxy, ISyncRule syncRule, Display display) {
        super(display);
        this.fRepository = repository;
        this.fProxy = proxy;
        this.fItemId = this.fProxy.getItemId();
        this.fSyncRule = syncRule;
        this.fResolveState = false;
        this.setValid(false);
    }

    public void dispose() {
        this.unregisterSharedItemListener();
    }

    public ImageDescriptor getImage() {
        return InteropRcpUiPlugin.PROXY_IMAGE_DESCRIPTOR;
    }

    public String getName() {
        this.waitForRevertJob();
        if (this.fName == null || this.fName.length() == 0) {
            return Messages.ExternalProxyWorkingCopy_DEFAULT_NAME;
        }
        return this.fName;
    }

    public String getToolTipText() {
        return Messages.ExternalProxyWorkingCopy_TOOLTIP;
    }

    public void revert(IProgressMonitor progress) throws CoreException {
        this.setValid(false);
        this.fRevertJob.setSystem(true);
        this.fRevertJob.schedule();
    }

    public void revert(RevertMode mode, IProgressMonitor progress) throws CoreException {
        this.setValid(false);
        try {
            this.doRevert(mode, progress);
        }
        catch (NotLoggedInException notLoggedInException) {
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    public void save(IProgressMonitor progress) throws CoreException, SaveConflictException {
    }

    public void saveAndOverwrite(IProgressMonitor progress) throws CoreException {
    }

    public ITeamRepository getRepository() {
        return this.fRepository;
    }

    public IExternalProxy getExternalProxy() {
        return this.fProxy;
    }

    public UUID getExternalProxyItemId() {
        return this.fItemId;
    }

    public Map<String, Object> getExternalState(boolean raw) {
        if (this.fExternalState == null) {
            return null;
        }
        return raw ? this.fExternalState.getState() : this.fExternalProperties;
    }

    public String getExternalId() {
        return this.fExternalId;
    }

    public Map<String, Object> getLinkedItemState(boolean raw) {
        return raw ? this.fLinkedItemRawProperties : this.fLinkedItemProperties;
    }

    public Map<String, String> getLinkedItemPropertyDisplayNamesMap() {
        return this.fLinkedItemPropertiesDisplayNames;
    }

    public IItemHandle getLinkedItemHandle() {
        return this.fLinkedItemHandle;
    }

    public Exception getLinkedItemError() {
        return this.fLinkedItemError;
    }

    public String getSyncStatusText() {
        if (this.fProxy == null) {
            return SYNC_STATUS_TEXT.get(IExternalProxy.SynchronizationStatus.UNINITIALIZED);
        }
        return ExternalProxyWorkingCopy.getSyncStatusText(this.fProxy, this.isIncomingBlocked() || this.isOutgoingBlocked());
    }

    public static String getSyncStatusText(IExternalProxy proxy) {
        return ExternalProxyWorkingCopy.getSyncStatusText(proxy, false);
    }

    public static String getSyncStatusText(IExternalProxy proxy, boolean blocked) {
        IExternalProxy.SynchronizationStatus status = proxy.getSynchronizationStatus();
        String text = SYNC_STATUS_TEXT.get(status);
        if (status == IExternalProxy.SynchronizationStatus.PENDING) {
            if (blocked) {
                text = Messages.ExternalProxyWorkingCopy_SYNC_STATUS_PENDING_BLOCKED;
            } else {
                switch (proxy.getLastSynchronizationDirection()) {
                    case INCOMING: {
                        text = Messages.ExternalProxyWorkingCopy_SYNC_STATUS_PENDING_OUTGOING;
                        break;
                    }
                    case OUTGOING: {
                        text = Messages.ExternalProxyWorkingCopy_SYNC_STATUS_PENDING_INCOMING;
                    }
                }
            }
        }
        return text;
    }

    public ISyncRule getSyncRule() {
        return this.fSyncRule;
    }

    public String getExternalUri() {
        return this.fUri;
    }

    public boolean isIncomingBlocked() {
        return this.fIncomingBlocking != null && this.fIncomingBlocking.length > 0;
    }

    public IExternalProxy[] getIncomingBlocking() {
        return this.fIncomingBlocking;
    }

    public boolean isOutgoingBlocked() {
        return this.fOutgoingBlocking != null && this.fOutgoingBlocking.length > 0;
    }

    public IExternalProxy[] getOutgoingBlocking() {
        return this.fOutgoingBlocking;
    }

    public void synchronizeIncoming() {
        if (this.fProxy != null) {
            this.setValid(false);
            this.fSynchronizeIncoming.setSystem(false);
            this.fSynchronizeIncoming.schedule();
        }
    }

    public void synchronizeOutgoing() {
        if (this.fProxy != null) {
            this.setValid(false);
            this.fSynchronizeOutgoing.setSystem(false);
            this.fSynchronizeOutgoing.schedule();
        }
    }

    public void acceptExternalStateAsMerged() {
        if (this.fProxy != null) {
            this.setValid(false);
            this.fSetExternalStateMerged.setSystem(false);
            this.fSetExternalStateMerged.schedule();
        }
    }

    public void acceptItemStateAsMerged() {
        if (this.fProxy != null) {
            this.setValid(false);
            this.fSetItemStateMerged.setSystem(false);
            this.fSetItemStateMerged.schedule();
        }
    }

    public void deleteExternalProxy(IProgressMonitor monitor) {
        if (this.fProxy != null) {
            this.setValid(false);
            try {
                this.adminClient().synchronizeDeletionAndWait((IExternalProxyHandle)this.fProxy, monitor);
                this.fRepository = null;
                this.fItemId = null;
                this.doRevert(RevertMode.FULL, monitor);
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                InteropRcpUiPlugin.getDefault().log(Messages.ExternalProxyWorkingCopy_ERROR_DELETING_PROXY, e);
            }
        }
    }

    private void doRevert(RevertMode mode, IProgressMonitor monitor) throws TeamRepositoryException {
        if (mode == RevertMode.FULL) {
            this.fExternalState = null;
            this.fExternalProperties = null;
            this.fLinkedItemHandle = null;
            this.fLinkedItemProperties = null;
            this.fLinkedItemRawProperties = null;
            this.fLinkedItemPropertiesDisplayNames = null;
            this.fLinkedItemError = null;
            this.fIncomingBlocking = null;
            this.fOutgoingBlocking = null;
            this.fSyncRule = null;
            this.fUri = null;
            this.fName = null;
        }
        if (this.fItemId == null) {
            this.fProxy = InteropFactory.INSTANCE.createExternalProxy();
        } else {
            ISyncRuleHandle syncRuleHandle;
            URI uri;
            List blockingProxies;
            IExternalProxyHandle[] blockingHandles;
            this.unregisterSharedItemListener();
            if (mode == RevertMode.FULL) {
                IExternalProxyHandle itemHandle = (IExternalProxyHandle)IExternalProxy.ITEM_TYPE.createItemHandle(this.fItemId, null);
                try {
                    this.fProxy = (IExternalProxy)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)itemHandle, 1, monitor);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    this.fProxy = null;
                    this.setValid(true);
                    return;
                }
                this.fLinkedItemHandle = this.adminClient().getTargetItem((IExternalProxyHandle)this.fProxy, monitor);
                if (this.fLinkedItemHandle != null && !(this.fLinkedItemHandle instanceof IManagedItemHandle)) {
                    this.setValid(true);
                    return;
                }
            }
            if ((blockingHandles = this.adminClient().getBlockingProxies((IExternalProxyHandle)this.fProxy, true, monitor)).length != 0) {
                blockingProxies = this.fRepository.itemManager().fetchCompleteItems(Arrays.asList(blockingHandles), 0, monitor);
                this.fIncomingBlocking = blockingProxies.toArray(new IExternalProxy[blockingProxies.size()]);
            }
            if ((blockingHandles = this.adminClient().getBlockingProxies((IExternalProxyHandle)this.fProxy, false, monitor)).length != 0) {
                blockingProxies = this.fRepository.itemManager().fetchCompleteItems(Arrays.asList(blockingHandles), 0, monitor);
                this.fOutgoingBlocking = blockingProxies.toArray(new IExternalProxy[blockingProxies.size()]);
            }
            if ((uri = this.adminClient().getUri((IExternalProxyHandle)this.fProxy, monitor)) != null) {
                try {
                    this.fUri = URLDecoder.decode(uri.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.fUri = e.toString();
                }
            }
            if (mode == RevertMode.LINKS) {
                this.fLinkedItemHandle = this.adminClient().getTargetItem((IExternalProxyHandle)this.fProxy, monitor);
            }
            if (this.fLinkedItemHandle != null) {
                try {
                    IItem linkedItem = this.fRepository.itemManager().fetchCompleteItem(this.fLinkedItemHandle, 0, monitor);
                    this.fLinkedItemHandle = linkedItem;
                }
                catch (Exception e) {
                    this.fLinkedItemError = e;
                }
            }
            if (mode == RevertMode.FULL && (syncRuleHandle = this.fProxy.getSyncRuleHandle()) != null) {
                this.fSyncRule = (ISyncRule)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)syncRuleHandle, 1, monitor);
                if (this.fResolveState) {
                    this.fExternalState = this.adminClient().getExternalState(this.fProxy, monitor);
                    if (this.fExternalState != null) {
                        this.fExternalProperties = this.resolveExternalState(this.fExternalState, this.fSyncRule, monitor);
                    }
                    if (this.fLinkedItemHandle != null && this.fLinkedItemHandle.hasFullState()) {
                        this.fLinkedItemRawProperties = this.adminClient().getTargetItemState((IExternalProxyHandle)this.fProxy, monitor);
                        if (this.fLinkedItemRawProperties != null) {
                            this.fLinkedItemProperties = this.resolveItemState(this.fLinkedItemRawProperties, this.fSyncRule, monitor);
                        }
                    }
                    try {
                        this.fLinkedItemPropertiesDisplayNames = this.getItemPropertyDipslayNamesMap(monitor);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                }
            }
            this.fExternalId = this.fProxy.getExternalIdHint();
            if (this.fExternalId == null) {
                this.fExternalId = this.fUri == null ? Messages.ExternalProxyWorkingCopy_UNKNOWN_EXTERNAL_ID : this.fUri;
            }
            this.fName = NLS.bind((String)Messages.ExternalProxyWorkingCopy_NAME, (Object)this.fExternalId, (Object[])new Object[0]);
            this.registerSharedItemListener();
        }
        this.setValid(true);
    }

    private Map<String, Object> resolveItemState(Map itemState, ISyncRule syncRule, IProgressMonitor monitor) throws TeamRepositoryException {
        List mappings = syncRule.getPropertyMappings();
        if (mappings == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(itemState);
        for (IPropertyMapping mapping : mappings) {
            IItemType refItemType;
            ISyncRule refSyncRule;
            Object value;
            String propName;
            if (!this.isReferenceMapping(mapping) || (propName = mapping.getItemPropertyName()) == null || propName.length() == 0 || (value = properties.get(propName)) == null || (refSyncRule = this.adminClient().findSyncRule(mapping.getReferenceSyncRule(), monitor)) == null || (refItemType = refSyncRule.getSyncItemType()) == null) continue;
            ArrayList<IItem> items = new ArrayList<IItem>();
            try {
                List<IItemHandle> handles = this.decodeItemHandleList(value.toString(), refItemType);
                for (IItemHandle handle : handles) {
                    items.add(this.fRepository.itemManager().fetchCompleteItem(handle, 0, monitor));
                }
            }
            catch (Exception exception) {
                items.clear();
                break;
            }
            if (items.size() == 1) {
                properties.put(propName, items.get(0));
                continue;
            }
            if (items.size() <= 1) continue;
            properties.put(propName, items);
        }
        return properties;
    }

    private Map<String, Object> resolveExternalState(IExternalState externalState, ISyncRule syncRule, IProgressMonitor monitor) {
        List mappings = syncRule.getPropertyMappings();
        if (mappings == null) {
            return null;
        }
        Map state = externalState.getState();
        HashMap<String, Object> properties = new HashMap<String, Object>(state);
        for (IPropertyMapping mapping : mappings) {
            Object value;
            String propName;
            if (!this.isReferenceMapping(mapping) || (propName = mapping.getExternalPropertyName()) == null || propName.length() == 0 || (value = properties.get(propName)) == null) continue;
            List<URI> uris = this.decodeURIList(value.toString());
            ArrayList<IExternalProxy> proxies = new ArrayList<IExternalProxy>();
            for (URI uri : uris) {
                try {
                    IExternalProxy proxy = this.adminClient().findProxybyUri(uri, monitor);
                    if (proxy == null) continue;
                    proxies.add(proxy);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    proxies.clear();
                    break;
                }
            }
            if (proxies.size() == 1) {
                properties.put(propName, proxies.get(0));
                continue;
            }
            if (proxies.size() <= 1) continue;
            properties.put(propName, proxies);
        }
        return properties;
    }

    private boolean isReferenceMapping(IPropertyMapping mapping) {
        String referenceSyncRuleName = mapping.getReferenceSyncRule();
        String transformExtension = mapping.getTransformExtension();
        return referenceSyncRuleName != null && referenceSyncRuleName.length() != 0 && (transformExtension == null || transformExtension.length() == 0);
    }

    private Map<String, String> getItemPropertyDipslayNamesMap(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fSyncRule == null) {
            return null;
        }
        String itemManagerId = this.fSyncRule.getItemManager();
        if (itemManagerId == null || itemManagerId.length() == 0) {
            return null;
        }
        IItemType itemType = this.fSyncRule.getSyncItemType();
        if (itemType == null) {
            return null;
        }
        IProjectArea projectArea = null;
        if (this.fSyncRule.getProjectArea() != null) {
            projectArea = (IProjectArea)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)this.fSyncRule.getProjectArea(), 0, monitor);
        }
        String itemTypeName = String.valueOf(itemType.getNamespaceURI()) + DOT + itemType.getName();
        String itemTypeQualifier = this.fSyncRule.getSyncItemTypeQualifier();
        IManagerInfoDTO[] managerInfoArray = this.adminClient().getItemManagerInfo(monitor);
        List propInfoList = null;
        IManagerInfoDTO[] iManagerInfoDTOArray = managerInfoArray;
        int n = managerInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IManagerInfoDTO managerInfo = iManagerInfoDTOArray[n2];
            if (itemManagerId.equals(managerInfo.getId())) {
                ITypeInfoDTO[] typeInfoArray;
                ITypeInfoDTO[] iTypeInfoDTOArray = typeInfoArray = this.adminClient().getItemManagerTypeInfo(managerInfo, (IProcessArea)projectArea, monitor);
                int n3 = typeInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeInfoDTO typeInfo = iTypeInfoDTOArray[n4];
                    if (itemTypeName.equals(typeInfo.getName())) {
                        String qualifier = typeInfo.getQualifierId();
                        if ((itemTypeQualifier == null || itemTypeQualifier.length() == 0) && (qualifier == null || qualifier.length() == 0) || itemTypeQualifier != null && itemTypeQualifier.equals(qualifier)) {
                            propInfoList = typeInfo.getProperties();
                            break;
                        }
                    }
                    ++n4;
                }
            }
            if (propInfoList != null) break;
            ++n2;
        }
        if (propInfoList == null) {
            return null;
        }
        HashMap<String, String> displayNameMap = new HashMap<String, String>();
        for (IPropertyInfoDTO propInfo : propInfoList) {
            if (propInfo.getName() == null || propInfo.getDisplayname() == null || propInfo.getDisplayname().length() == 0) continue;
            displayNameMap.put(propInfo.getName(), propInfo.getDisplayname());
        }
        return displayNameMap;
    }

    private void waitForRevertJob() {
        try {
            this.fRevertJob.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private void registerSharedItemListener() {
        if (this.fProxy != null && !this.fProxy.isNewItem()) {
            this.fRepository.itemManager().addItemChangeListener((IItem)this.fProxy, this.fProxyChangeListener);
        }
    }

    private void unregisterSharedItemListener() {
        if (this.fProxy != null && !this.fProxy.isNewItem() && this.fRepository != null) {
            this.fRepository.itemManager().removeItemChangeListener((IItem)this.fProxy, this.fProxyChangeListener);
        }
    }

    private void refreshLinkedItem(IProgressMonitor monitor) throws TeamRepositoryException {
        IItem sharedItem;
        IItemHandle itemHandle = this.adminClient().getTargetItem((IExternalProxyHandle)this.fProxy, monitor);
        if (itemHandle != null && (sharedItem = this.fRepository.itemManager().getSharedItemIfKnown(itemHandle)) != null) {
            this.fRepository.itemManager().refreshSharedItems(Collections.singletonList(sharedItem), monitor);
        }
    }

    private List<IItemHandle> decodeItemHandleList(String itemIds, IItemType itemType) {
        if (itemIds == null || itemIds.length() == 0) {
            return new ArrayList<IItemHandle>();
        }
        String[] uuids = itemIds.split("\\s+");
        ArrayList<IItemHandle> itemHandles = new ArrayList<IItemHandle>(uuids.length);
        String[] stringArray = uuids;
        int n = uuids.length;
        int n2 = 0;
        while (n2 < n) {
            String uuidString = stringArray[n2];
            UUID uuid = UUID.valueOf((String)uuidString);
            IItemHandle handle = itemType.createItemHandle(uuid, null);
            itemHandles.add(handle);
            ++n2;
        }
        return itemHandles;
    }

    private List<URI> decodeURIList(String uriStrings) {
        if (uriStrings == null || uriStrings.length() == 0) {
            return new ArrayList<URI>();
        }
        String[] uris = uriStrings.split("\\s+");
        ArrayList<URI> uriList = new ArrayList<URI>(uris.length);
        String[] stringArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            uriList.add(URI.create(uri));
            ++n2;
        }
        return uriList;
    }

    private synchronized IItemConnectorAdminClient adminClient() {
        if (this.fAdminClient == null) {
            this.fAdminClient = (IItemConnectorAdminClient)this.fRepository.getClientLibrary(IItemConnectorAdminClient.class);
        }
        return this.fAdminClient;
    }

    private class RevertJob
    extends Job {
        RevertJob() {
            super(Messages.ExternalProxyWorkingCopy_FETCHING_STATE_JOB_NAME);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ExternalProxyWorkingCopy.this.doRevert(RevertMode.FULL, monitor);
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                return StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RevertMode {
        FULL,
        LINKS;

    }
}

