﻿dojo.require("dojo.fx");
dojo.require("dojo.NodeList-fx");
dojo.addOnLoad(function() {

//CSH

	dojo.query('label.has_csh')
		.onmouseover(function(){
			var cshID = dojo.attr(this,'id') + '_csh';
			var cshNode = dojo.byId(cshID);
			var animArgs = {
				node: cshNode,
				duration: 250,
				delay: 0
				};
			
			dojo.style(cshNode, {'opacity':0, 'display': 'block'});
			dojo.fadeIn(animArgs).play();
			
			dojo.connect(this,"onmouseout",function() {
				dojo.style(cshNode, {'display': 'none'});
			});
			
		});

/*
 * BUTTON LOGIC PUZZLE #1
 * 
 * If you need to disable certain buttons when an option gets selected look no further
 * 
 * 
 * In the buttons array below, define objects with 4 elements as below. Use CSS notation (ie, for an id, use #id, for classes, use .class) to identify the elements 
 *
 * (1) buttonToClick : The button that you click that needs to disable something
 * (2) buttonToDisable : The button that gets disabled when you click (1)
 * (3) buttonReplacesDisabled : (OPTIONAL) If choosing (1) means another button should be chosen to replace (2), what is it? Use ONLY one id here.
 * (4) buttonFixesDisabled : What buttons can the user click to re-enabled (2)?
 *
 * You can add as many objects as you need to the "buttons" array. I have three below.
 *
 *
 */

	var buttons = [
			{
				buttonToClick: "#edition_expressC",
				buttonToDisable: "#server_was, #os_aix, #os_solaris, #im_yes",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#edition_enterprise, #edition_express, #edition_standard"
			}
		];
	
	dojo.forEach(buttons, function(b, i) {
	//cache the queries for the buttons
	
		var click = dojo.query(b.buttonToClick);
		var kill = dojo.query(b.buttonToDisable);
		var toReplace = b.buttonReplacesDisabled.replace('#','');
			if (toReplace) {
				var replace = dojo.byId(toReplace);
			}
		var fixers = dojo.query(b.buttonFixesDisabled);

	//add to the object a reusable function to remove the disabled attribute
	//we're doing this for two reasons: adding it to the objects lets me have unique functions, and I will use them later
	//for the reset() function
		b.fixIt = function() {
			kill.attr('disabled',false);
		};
		
	//add to the object a reusable function to disable and do whatever else has to be done
		b.killIt = function() {
			
		// if there's something to replace it with, do that;
		// BUG BUG BUG: If there's a lot going on with conflicting replacement and fixer elements, 
		// I can't guarantee that it'll work the second or subsequent times
			if (toReplace) {
				replace.click();
			}

		//disable the buttons we don't want and uncheck them
		//this is a partial response to the bug above: at the very least, they won't be stuck with a disabled and checked button
			kill.attr({
				'disabled': true,
				'checked': false
				});			
			
		//and finally, add an event handler to re-enable it if those other buttons get clicked
			fixers.onclick(function() {
				b.fixIt();
			});
		};

	//Certain browser fix: On load/reload, if something is still disabled, fix it. This might get overwritten in a second
		if (kill.attr('disabled')[0]) {
			b.fixIt();
		}
		
	//Certain browser fix: If on load/reload the Click button is checked, run the disable function
		if (click.attr('checked')[0]) {
			b.killIt();
		}

	//The main event listener
		click.onclick(function() {
			b.killIt();
		});
			
	});

//Need to simulate my own RESET function
	dojo.query('#form_reset')
		.onclick(function(e) {
		//reset the form
			dojo.byId('theForm').reset();
		//While we're at it, re-enabled any items that might have been disabled
			dojo.forEach(buttons, function(b, i){
				b.fixIt();
			});

		//Look for any highlighted form elements and remove the highlight class	
			dojo.query('td.option_selected','theForm').removeClass('option_selected');
		//And prevent the default behavior for the link
			dojo.stopEvent(e);
		});

//AND, finally, time to submit the thing.

	dojo.query('#theForm')
		.onsubmit(function(e) {
		//Remove any error messages
			dojo.query('p.error').orphan();
		
		//Validation time! Verify that they've selected all 5 options
			var hasSelected = true;
			dojo.query('div.needsSelected')
				.forEach(function(node) {
				//Check for a checked input
					var isOneSelected = dojo.query('input:checked',node).length;
					
				//If there isn't one
					if (!isOneSelected) {
					//Create an error message and cache it
						var theError = dojo.query(dojo.create('p',{ 
							innerHTML: errorMsg,
							'class': 'error' 
							}));
					//Find the table here and drop the error message in front of it
						theError.place(dojo.query('ul',node), 'before');

					//Add a handler to any of the inputs here, and remove the error message when they click one
						dojo.query('input', node)
							.onclick(function() {
								theError.orphan();
							});
							
					//If any of this happens, stop the presses
						hasSelected = false;
					}
				});

		// If you're good on each input, let's move on
			if (hasSelected) {
			//nice-looking list of your form output, for debugging
			//	var q = dojo.formToJson(this, true);
			//	console.log(q);
				

			//these are always shown
				dojo.query('#sysReq, #getInstallMedia, #editionsLicenses, #runWizard, #itsOver, #doEclipse').addClass('seen');
				
			//turn the values of the form into an object, with name: value
				var o = dojo.formToObject(this);
				
				var formED = o.edition;
				var formOS = o.os;
				var formAS = o.appserver;
				var formDB = o.dbserver;
				var formIM = o.im;
			
			//Here's the array of values to check, and the classes (in CSS3 selector syntax) to display if someone has selected those options
				var a = [
						{toCheck: formED, possibleValue: 'expressC', classToShow: '.forExpressC'},
						{toCheck: formED, possibleValue: 'express', classToShow: '.forExpress'},
						{toCheck: formED, possibleValue: 'standard', classToShow: '.forStandard'},
						{toCheck: formED, possibleValue: 'enterprise', classToShow: '.forEnterprise'},

						{toCheck: formOS, possibleValue: 'windows', classToShow: '.forWindows'},
						{toCheck: formOS, possibleValue: 'aix', classToShow: '.forAIX'},
						{toCheck: formOS, possibleValue: 'linux', classToShow: '.forLinux'},
						{toCheck: formOS, possibleValue: 'solaris', classToShow: '.forSolaris'},
						
						{toCheck: formAS, possibleValue: 'was', classToShow: '.forWAS'},
						{toCheck: formAS, possibleValue: 'tomcat', classToShow: '.forTomcat'},
						
						{toCheck: formDB, possibleValue: 'derby', classToShow: '.forDerby, .forNotServerSetupDB2'},
						{toCheck: formDB, possibleValue: 'db2', classToShow: '.forDB2, .forServerSetupDB2'},
						{toCheck: formDB, possibleValue: 'oracle', classToShow: '.forOracle, .forNotServerSetupDB2'},
						{toCheck: formDB, possibleValue: 'mssql', classToShow: '.forMsSQL, .forNotServerSetupDB2'},
						{toCheck: formDB, possibleValue: 'needdb', classToShow: '.forNeedDB2, .forDB2'},
						
						{toCheck: formIM, possibleValue: 'imYes', classToShow: '.forImYes'},
						{toCheck: formIM, possibleValue: 'imNo', classToShow: '.forImNo'}
					];

			//Cycle through the array
				dojo.forEach(a, function(field) {
				//If the field matches one of the possible values
					if (field.toCheck === field.possibleValue) {
					//then show those classes
						dojo.query(field.classToShow).addClass('seen');
					}
				});
				
				dojo.query('#qa')
					.wipeOut({duration: 500})
					.play();

				dojo.query('#results')
					.style({'display':'block','height':0,'overflow':'hidden'})
					.wipeIn({duration: 1000})
					.play();
					
				var i = 0;
				dojo.query('#results h3')
					.forEach(function(item) {
						if (dojo.style(item, "height")) {
						i = i+1;
						var stepNumber = '<span class="countNumber">' + i +'<\/span>';
						
						item.innerHTML = stepNumber + item.innerHTML;
						
						}
					});
			
			}
				
			dojo.stopEvent(e);
		
		});

});