/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal;

import com.ibm.team.foundation.common.IEventGroup;
import com.ibm.team.foundation.common.IEventType;
import com.ibm.team.foundation.common.IEventTypeManager;
import com.ibm.team.foundation.common.internal.EventGroup;
import com.ibm.team.foundation.common.internal.EventType;
import com.ibm.team.foundation.common.internal.Messages;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventTypeManager
implements IEventTypeManager {
    private static final String EVENTS_EXTENSION_POINT = "events";
    private static final String EVENT_TYPE_ID = "eventType";
    private static final String EVENT_GROUP_ID = "eventGroup";
    private static final String EVENT_TYPE_REFERENCE_ID = "eventTypeReference";
    protected static final String EXT_ID = "id";
    protected static final String EXT_ICONURI_ID = "iconUri";
    protected static final String EXT_NAME_ID = "name";
    protected static final String EXT_VISIBLE_BY_DEFAULT = "isVisibleByDefault";
    private ExtensionRegistryReader fRegistryReader;
    private Set<IEventType> fEventTypes = new HashSet<IEventType>();
    private Set<IEventGroup> fEventGroups = new HashSet<IEventGroup>();
    private boolean fIsDisposed;

    protected abstract URL createAbsoluteUrl(String var1, IConfigurationElement var2) throws MalformedURLException;

    protected void readContributions() {
        this.fRegistryReader = new ExtensionRegistryReader("com.ibm.team.foundation.common", EVENTS_EXTENSION_POINT){

            protected Object handleExtensionAdded(IConfigurationElement element) throws Exception {
                String id = element.getAttribute(AbstractEventTypeManager.EXT_ID);
                String pluginRelativeIconUri = element.getAttribute(AbstractEventTypeManager.EXT_ICONURI_ID);
                String name = element.getAttribute(AbstractEventTypeManager.EXT_NAME_ID);
                URL pluginAbsoluteIconUrl = null;
                try {
                    pluginAbsoluteIconUrl = AbstractEventTypeManager.this.createAbsoluteUrl(pluginRelativeIconUri, element);
                }
                catch (MalformedURLException e) {
                    throw new Exception(NLS.bind((String)Messages.getString("AbstractEventTypeManager.ERROR_INIT_EVENT_TYPE"), (Object)id, (Object[])new Object[0]), e);
                }
                if (AbstractEventTypeManager.EVENT_TYPE_ID.equals(element.getName())) {
                    this.handleEventTypeAdded(id, pluginAbsoluteIconUrl, name);
                } else if (AbstractEventTypeManager.EVENT_GROUP_ID.equals(element.getName())) {
                    this.handleEventGroupAdded(id, pluginAbsoluteIconUrl, name, element);
                }
                return null;
            }

            private void handleEventTypeAdded(String id, URL pluginAbsoluteIconUrl, String name) throws Exception {
                AbstractEventTypeManager.this.fEventTypes.add(new EventType(id, pluginAbsoluteIconUrl, name));
            }

            private void handleEventGroupAdded(String id, URL pluginAbsoluteIconUrl, String name, IConfigurationElement element) throws Exception {
                String visibleByDefault = element.getAttribute(AbstractEventTypeManager.EXT_VISIBLE_BY_DEFAULT);
                IConfigurationElement[] eventTypeReferences = element.getChildren(AbstractEventTypeManager.EVENT_TYPE_REFERENCE_ID);
                ArrayList<String> eventTypeIds = new ArrayList<String>(eventTypeReferences.length);
                IConfigurationElement[] iConfigurationElementArray = eventTypeReferences;
                int n = eventTypeReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement eventTypeReference = iConfigurationElementArray[n2];
                    String eventTypeId = eventTypeReference.getAttribute(AbstractEventTypeManager.EXT_ID);
                    eventTypeIds.add(eventTypeId);
                    ++n2;
                }
                EventGroup group = new EventGroup(id, pluginAbsoluteIconUrl, name, visibleByDefault == null || Boolean.valueOf(visibleByDefault) != false, eventTypeIds);
                AbstractEventTypeManager.this.fEventGroups.add(group);
            }
        };
        this.fRegistryReader.start();
    }

    @Override
    public Collection<IEventType> getEventTypes() {
        return this.fEventTypes;
    }

    @Override
    public Collection<IEventGroup> getEventGroups() {
        return this.fEventGroups;
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.fRegistryReader.stop();
            this.fIsDisposed = true;
        }
    }
}

