/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URILinkDetector
extends TextLinkDetector {
    private static final String protocol = "[\\w]";
    private static final String end = "[\\w/]";
    private static final String any = "[\\w-%=\\./?#&:@+~!$;,]";
    private static final Pattern PATTERN = Pattern.compile("((([\\w])*://([\\w-%=\\./?#&:@+~!$;,])*([\\w/]))|(www\\.([\\w-%=\\./?#&:@+~!$;,])*\\.([\\w-%=\\./?#&:@+~!$;,])*([\\w/])))", 66);
    private static final int COMPLETE_URL_GROUP = 2;
    private static final int WWW_URL_GROUP = 6;

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        String url;
        int length;
        int offset;
        String complete = matcher.group(2);
        if (complete != null) {
            offset = matcher.start(2);
            length = matcher.end(2) - offset;
            url = matcher.group(2);
            if (url == null) {
                return null;
            }
        } else {
            offset = matcher.start(6);
            length = matcher.end(6) - offset;
            url = matcher.group(6);
            if (url == null) {
                return null;
            }
            url = "http://" + url;
        }
        try {
            new URI(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return new DetectedURITextLink(offset, length, url);
    }

    protected Pattern getPattern() {
        return PATTERN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DetectedURITextLink
    extends DetectedTextLink {
        private String fURL;

        public DetectedURITextLink(int offset, int length, String url) {
            super(offset, length);
            this.fURL = url;
        }

        @Override
        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>(1);
            try {
                URI uri = new URI(this.fURL);
                uris.add(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
            return uris;
        }
    }
}

