/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.ui.text;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.jface.internal.util.TextViewerDecorator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.model.ItemHandle;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class CollaborationPresenceTextDecorator
extends TextViewerDecorator {
    private final CollaborationServiceListener fCollaborationServiceListener = new CollaborationServiceListener();
    private ResourceManager fResourceManager = null;
    private final Map<CollaborationPresenceStatus, TextAttribute> fTextAttributeCache = new HashMap<CollaborationPresenceStatus, TextAttribute>(6);
    TextViewer fTextViewer;

    static StyleRange createStyleRange(int offset, int length, TextAttribute attribute) {
        StyleRange range = new StyleRange(offset, length, attribute.getForeground(), null, attribute.getStyle() & 0x9FFFFFFF);
        range.strikeout = false;
        range.underline = true;
        return range;
    }

    public void install(TextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        if (this.fTextViewer != null) {
            return;
        }
        this.fTextViewer = viewer;
        this.fTextViewer.addTextPresentationListener((ITextPresentationListener)this.fCollaborationServiceListener);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.addSessionListener((ICollaborationSessionListener)this.fCollaborationServiceListener);
        service.addPresenceListener((ICollaborationPresenceListener)this.fCollaborationServiceListener);
    }

    public void uninstall() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextPresentationListener((ITextPresentationListener)this.fCollaborationServiceListener);
            this.fTextViewer = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        this.fTextAttributeCache.clear();
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.removeSessionListener((ICollaborationSessionListener)this.fCollaborationServiceListener);
        service.removePresenceListener((ICollaborationPresenceListener)this.fCollaborationServiceListener);
    }

    TextAttribute getTextAttribute(CollaborationPresenceStatus standard) {
        TextAttribute result = this.fTextAttributeCache.get(standard);
        if (result == null && this.fResourceManager != null) {
            result = new TextAttribute(this.fResourceManager.createColor(CollaborationUI.getForegroundColor(standard, true)), null, 0x40000000 | CollaborationUI.getFontStyle(standard));
            this.fTextAttributeCache.put(standard, result);
        }
        return result;
    }

    private final class CollaborationServiceListener
    implements ICollaborationSessionListener,
    ICollaborationPresenceListener,
    ITextPresentationListener {
        CollaborationServiceListener() {
        }

        public void applyTextPresentation(TextPresentation presentation) {
            IDocument document = CollaborationPresenceTextDecorator.this.fTextViewer.getDocument();
            if (document instanceof IStyledDocument) {
                IStyledDocument extended = (IStyledDocument)document;
                try {
                    IRegion extent = presentation.getExtent();
                    int offset = extent.getOffset();
                    int length = extent.getLength();
                    ReferencePosition[] persistent = extended.getReferencePositions(offset, length, false);
                    ReferencePosition[] temporary = extended.getReferencePositions(offset, length, true);
                    int total = persistent.length + temporary.length;
                    if (total == 0) {
                        return;
                    }
                    ReferencePosition[] positions = new ReferencePosition[total];
                    System.arraycopy(persistent, 0, positions, 0, persistent.length);
                    System.arraycopy(temporary, 0, positions, persistent.length, temporary.length);
                    ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(positions.length);
                    ReferencePosition[] referencePositionArray = positions;
                    int n = positions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferencePosition position = referencePositionArray[n2];
                        try {
                            Location location;
                            IItemHandle result;
                            URI uri = position.getReference();
                            if (uri != null && (result = (location = Location.location((URI)uri)).getItemHandle()) instanceof ItemHandle) {
                                ItemHandle handle = (ItemHandle)result;
                                ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(location.getRepoUri(), 4);
                                if (repository != null) {
                                    handle.setOrigin((Object)repository);
                                    if (handle instanceof IContributorHandle) {
                                        CollaborationPresenceStatus status = CollaborationCore.getCollaborationService().getPresenceStatus((IContributorHandle)handle);
                                        ranges.add(CollaborationPresenceTextDecorator.createStyleRange(position.getOffset(), position.getLength(), CollaborationPresenceTextDecorator.this.getTextAttribute(status.getStandard())));
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {}
                        ++n2;
                    }
                    presentation.replaceStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
                }
                catch (BadLocationException exception) {
                    CollaborationUIPlugin.getInstance().log(exception);
                }
            }
        }

        public void presenceNotification(CollaborationPresenceEvent event) {
            Object origin;
            Assert.isNotNull((Object)event);
            IContributorHandle handle = event.getPresence().getUser().getContributor();
            if (handle != null && (origin = handle.getOrigin()) instanceof ITeamRepository) {
                ITeamRepository repository = (ITeamRepository)origin;
                String root = repository.publicUriRoot();
                if (root == null) {
                    root = repository.getRepositoryURI();
                }
                final URI uri = Location.itemLocation((IItemHandle)handle, (String)root).toAbsoluteUri();
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            IDocument document;
                            if (((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer != null && ((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.getTextWidget() != null && !((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.getTextWidget().isDisposed() && (document = ((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.getDocument()) instanceof IStyledDocument) {
                                ReferencePosition[] temporary;
                                IStyledDocument extended = (IStyledDocument)document;
                                ReferencePosition[] persistent = extended.getReferencePositions(false);
                                int total = persistent.length + (temporary = extended.getReferencePositions(true)).length;
                                if (total == 0) {
                                    return;
                                }
                                ReferencePosition[] positions = new ReferencePosition[total];
                                System.arraycopy(persistent, 0, positions, 0, persistent.length);
                                System.arraycopy(temporary, 0, positions, persistent.length, temporary.length);
                                ReferencePosition[] referencePositionArray = positions;
                                int n = positions.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ReferencePosition position = referencePositionArray[n2];
                                    if (uri.equals(position.getReference())) {
                                        ((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.invalidateTextPresentation(position.getOffset(), position.getLength());
                                    }
                                    ++n2;
                                }
                            }
                        }
                    });
                }
            }
        }

        public void sessionNotification(CollaborationSessionEvent event) {
            Display display;
            int type = event.getType();
            if (!(type != 0 && type != 1 || (display = PlatformUI.getWorkbench().getDisplay()).isDisposed())) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer != null && ((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.getTextWidget() != null && !((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.getTextWidget().isDisposed()) {
                            ((CollaborationServiceListener)CollaborationServiceListener.this).CollaborationPresenceTextDecorator.this.fTextViewer.invalidateTextPresentation();
                        }
                    }
                });
            }
        }
    }
}

