/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.ui.preference;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountInfo;
import com.ibm.team.collaboration.core.account.ICollaborationAccountManager;
import com.ibm.team.collaboration.core.provider.ICollaborationProvider;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.CollaborationUserEvent;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.core.session.ICollaborationUserListener;
import com.ibm.team.collaboration.internal.core.account.CollaborationAccountManager;
import com.ibm.team.collaboration.internal.core.service.DefaultCollaborationService;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationAccountDialog;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationPreferenceUIProxy;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationPreferenceUIRegistry;
import com.ibm.team.collaboration.internal.ui.util.ChangePresenceMenuCreator;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollaborationAccountPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    TableViewer fAccountViewer = null;
    Button fAddButton = null;
    final CollaborationAutoLoginListener fAutoLoginListener = new CollaborationAutoLoginListener();
    private Button fConnectButton = null;
    Link fConnectionLink = null;
    Collection<CollaborationUser> fCurrentIdentities;
    private Button fDefaultButton = null;
    CollaborationAccountInfoWorkingCopy fDefaultWorkingCopy = null;
    private Button fDisconnectButton = null;
    private Button fEditButton = null;
    ControlEnableState fLastAccountGroupState = null;
    final ChangePresenceMenuCreator fMenuCreator = new ChangePresenceMenuCreator();
    final String fPageId;
    private Button fRemoveButton = null;
    Composite fViewerComposite = null;

    protected CollaborationAccountPreferencePage(String pageId, String description) {
        ITeamRepository[] repositories;
        Assert.isNotNull((Object)pageId);
        Assert.isNotNull((Object)description);
        this.fPageId = pageId;
        this.setDescription(description);
        this.fCurrentIdentities = CollaborationCore.getCollaborationService().getAccountManager().getIdentities();
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fAutoLoginListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.addGenericListener((Object)"state", (IListener)this.fAutoLoginListener);
            ++n2;
        }
    }

    final Map<ICollaborationProvider, Boolean> computeEnforcementMap(CollaborationAccountInfo info) {
        DefaultCollaborationService service = DefaultCollaborationService.getInstance();
        ArrayList providers = new ArrayList(service.getProviders(this.getPrimaryCapabilities()));
        Collections.sort(providers, new Comparator<ICollaborationProvider>(){

            @Override
            public int compare(ICollaborationProvider first, ICollaborationProvider second) {
                return Collator.getInstance().compare(first.getDisplayName(), second.getDisplayName());
            }
        });
        LinkedHashMap<ICollaborationProvider, Boolean> result = new LinkedHashMap<ICollaborationProvider, Boolean>(providers.size());
        for (ICollaborationProvider provider : providers) {
            boolean enforce = false;
            if (service.hasSingletonAccounts(provider)) {
                String id = provider.getId();
                Collection copies = (Collection)this.fAccountViewer.getInput();
                if (copies != null) {
                    for (CollaborationAccountInfoWorkingCopy copy : copies) {
                        CollaborationAccountInfo current = copy.getInfo();
                        if (current.equals((Object)info) || !current.getProviderId().equals(id)) continue;
                        enforce = true;
                        break;
                    }
                }
            }
            result.put(provider, enforce);
        }
        return result;
    }

    protected Composite createAccountControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        return parent;
    }

    final GridData createButtonGridData() {
        GridData data = new GridData(4, 4, false, false);
        return data;
    }

    final Label createButtonSeparator(Composite parent) {
        Assert.isNotNull((Object)parent);
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Control createContents(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.fViewerComposite = new Composite(composite, 0);
        this.fViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.fViewerComposite.setLayout((Layout)layout);
        this.createAccountControls(composite);
        if (TeamPlatform.getTeamRepositoryService().getTeamRepositories().length == 0) {
            this.fConnectionLink = new Link(composite, 0);
            this.fConnectionLink.setLayoutData((Object)new GridData(4, 128, true, false));
            this.fConnectionLink.setText(CollaborationMessages.CollaborationAccountPreferencePage_29);
            this.fConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IPreferencePageContainer container = CollaborationAccountPreferencePage.this.getContainer();
                    if (container instanceof Window) {
                        Shell shell;
                        Window dialogWindow = (Window)container;
                        CollaborationAccountPreferencePage.this.performCancel();
                        dialogWindow.close();
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (workbenchWindow != null && (shell = workbenchWindow.getShell()) != null && !shell.isDisposed()) {
                            List proxies = CollaborationPreferenceUIRegistry.getInstance().getDescriptors();
                            if (!proxies.isEmpty()) {
                                ITeamRepository result = null;
                                for (CollaborationPreferenceUIProxy proxy : proxies) {
                                    ITeamRepository repository = proxy.createRepositoryConnection(shell);
                                    if (repository == null) continue;
                                    result = repository;
                                    break;
                                }
                                if (result != null) {
                                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)CollaborationAccountPreferencePage.this.fPageId, null, null).open();
                                } else {
                                    MessageDialog.openInformation((Shell)shell, (String)CollaborationMessages.CollaborationAccountPreferencePage_34, (String)CollaborationMessages.CollaborationAccountPreferencePage_45);
                                }
                            } else {
                                MessageDialog.openInformation((Shell)shell, (String)CollaborationMessages.CollaborationAccountPreferencePage_34, (String)CollaborationMessages.CollaborationAccountPreferencePage_40);
                            }
                        }
                    }
                }
            });
        }
        new Label(composite, 0).setLayoutData((Object)new GridData());
        this.fAccountViewer = new TableViewer(this.fViewerComposite);
        Table table = this.fAccountViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAccountViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fAccountViewer.setLabelProvider((IBaseLabelProvider)new CollaborationAccountInfoLabelProvider());
        this.fAccountViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Assert.isNotNull((Object)event);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection extended = (IStructuredSelection)selection;
                    CollaborationAccountInfoWorkingCopy copy = null;
                    int size = extended.size();
                    if (size == 1) {
                        copy = (CollaborationAccountInfoWorkingCopy)extended.iterator().next();
                    }
                    CollaborationAccountPreferencePage.this.updateButtons(copy, size);
                }
            }
        });
        this.fAccountViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CollaborationAccountInfoWorkingCopy copy;
                IStructuredSelection extended;
                Object object;
                Assert.isNotNull((Object)event);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (object = (extended = (IStructuredSelection)selection).getFirstElement()) instanceof CollaborationAccountInfoWorkingCopy && CollaborationAccountPreferencePage.this.fCurrentIdentities.contains((copy = (CollaborationAccountInfoWorkingCopy)object).getInfo().getUser())) {
                    CollaborationAccountPreferencePage.this.handleEditAccount(copy);
                }
            }
        });
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                CollaborationAccountPreferencePage.this.fMenuCreator.fillContextMenu(menu);
            }
        });
        table.setMenu(manager.createContextMenu((Control)table));
        this.fAccountViewer.setComparator((ViewerComparator)new CollaborationAccountInfoViewerSorter());
        new TooltipSupport((Control)table, true, true){
            private CollaborationAccountInfoWorkingCopy fCopy;
            {
                this.fCopy = null;
            }

            public Object getElement(Control control, int x, int y) {
                this.fCopy = null;
                Object element = super.getElement(control, x, y);
                if (element instanceof CollaborationAccountInfoWorkingCopy) {
                    CollaborationAccountInfoWorkingCopy copy;
                    this.fCopy = copy = (CollaborationAccountInfoWorkingCopy)element;
                    return this.fCopy.getInfo().getUser().getContributor();
                }
                return null;
            }

            protected void openRequested(Object element) {
                if (this.fCopy != null) {
                    CollaborationAccountPreferencePage.this.handleEditAccount(this.fCopy);
                }
            }
        };
        CollaborationCore.getCollaborationService().scheduleJob((CollaborationServiceJob)new CollaborationAccountInitializerJob(CollaborationMessages.CollaborationAccountPreferencePage_16));
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite buttons = new Composite(this.fViewerComposite, 0);
        buttons.setLayoutData((Object)this.createButtonGridData());
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setEnabled(!this.fCurrentIdentities.isEmpty());
        this.fAddButton.setText(CollaborationMessages.CollaborationAccountPreferencePage_0);
        this.fAddButton.setLayoutData((Object)this.createButtonGridData());
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                CollaborationAccountPreferencePage.this.handleAddAccount();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setEnabled(false);
        this.fEditButton.setText(CollaborationMessages.CollaborationAccountPreferencePage_1);
        this.fEditButton.setLayoutData((Object)this.createButtonGridData());
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection extended;
                Object object;
                Assert.isNotNull((Object)event);
                ISelection selection = CollaborationAccountPreferencePage.this.fAccountViewer.getSelection();
                if (selection instanceof IStructuredSelection && (object = (extended = (IStructuredSelection)selection).getFirstElement()) instanceof CollaborationAccountInfoWorkingCopy) {
                    CollaborationAccountInfoWorkingCopy copy = (CollaborationAccountInfoWorkingCopy)object;
                    CollaborationAccountPreferencePage.this.handleEditAccount(copy);
                }
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.setText(CollaborationMessages.CollaborationAccountPreferencePage_2);
        this.fRemoveButton.setLayoutData((Object)this.createButtonGridData());
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                CollaborationAccountPreferencePage.this.handleRemoveAccount();
            }
        });
        this.createButtonSeparator(buttons);
        this.fConnectButton = new Button(buttons, 8);
        this.fConnectButton.setEnabled(false);
        this.fConnectButton.setText(CollaborationMessages.CollaborationAccountPreferencePage_3);
        this.fConnectButton.setLayoutData((Object)this.createButtonGridData());
        this.fConnectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                CollaborationAccountPreferencePage.this.handleConnect();
            }
        });
        this.fDisconnectButton = new Button(buttons, 8);
        this.fDisconnectButton.setEnabled(false);
        this.fDisconnectButton.setText(CollaborationMessages.CollaborationAccountPreferencePage_5);
        this.fDisconnectButton.setLayoutData((Object)this.createButtonGridData());
        this.fDisconnectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                CollaborationAccountPreferencePage.this.handleDisconnect();
            }
        });
        this.createButtonSeparator(buttons);
        this.fDefaultButton = new Button(buttons, 8);
        this.fDefaultButton.setEnabled(false);
        this.fDefaultButton.setText(CollaborationMessages.CollaborationAccountPreferencePage_15);
        this.fDefaultButton.setLayoutData((Object)this.createButtonGridData());
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                CollaborationAccountPreferencePage.this.handleDefault();
            }
        });
        if (this.fCurrentIdentities.isEmpty()) {
            this.fLastAccountGroupState = ControlEnableState.disable((Control)this.fViewerComposite);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getApplyButton().setEnabled(false);
        this.getDefaultsButton().setEnabled(false);
    }

    final CollaborationAccountInfoWorkingCopy createWorkingCopy(CollaborationAccountInfo info, IProgressMonitor monitor) {
        try {
            monitor.beginTask(CollaborationMessages.CollaborationAccountPreferencePage_9, 200);
            DefaultCollaborationService service = DefaultCollaborationService.getInstance();
            String providerName = service.getProvider(info.getProviderId()).getDisplayName();
            String label = MessageFormat.format(CollaborationMessages.CollaborationAccountPreferencePage_11, info.getUser().getUserId((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)), info.getUserId(), providerName);
            CollaborationAccountInfoWorkingCopy collaborationAccountInfoWorkingCopy = new CollaborationAccountInfoWorkingCopy(info, label, service.getPresenceStatus(info, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
            return collaborationAccountInfoWorkingCopy;
        }
        finally {
            monitor.done();
        }
    }

    public void dispose() {
        ITeamRepository[] repositories;
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fAutoLoginListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.removeGenericListener((Object)"state", (IListener)this.fAutoLoginListener);
            ++n2;
        }
        this.fMenuCreator.dispose();
        super.dispose();
    }

    protected abstract String getAddAccountTitle();

    protected abstract String getEditAccountTitle();

    protected abstract int getPrimaryCapabilities();

    final void handleAddAccount() {
        Map<ICollaborationProvider, Boolean> providers = this.computeEnforcementMap(null);
        if (providers.isEmpty()) {
            return;
        }
        CollaborationAccountDialog dialog = new CollaborationAccountDialog(this.getShell(), this.getAddAccountTitle(), providers, this.fCurrentIdentities);
        if (dialog.open() != 0) {
            return;
        }
        final CollaborationAccountInfo info = dialog.getAccountInfo();
        if (info != null) {
            this.getApplyButton().setEnabled(true);
            FoundationJob addJob = new FoundationJob(CollaborationMessages.CollaborationAccountPreferencePage_18){

                public IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    final CollaborationAccountInfoWorkingCopy copy = CollaborationAccountPreferencePage.this.createWorkingCopy(info, monitor);
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                Control control;
                                if ((this).CollaborationAccountPreferencePage.this.fAccountViewer != null && (control = (this).CollaborationAccountPreferencePage.this.fAccountViewer.getControl()) != null && !control.isDisposed()) {
                                    ArrayList<CollaborationAccountInfoWorkingCopy> successors = new ArrayList<CollaborationAccountInfoWorkingCopy>(4);
                                    Collection predecessors = (Collection)(this).CollaborationAccountPreferencePage.this.fAccountViewer.getInput();
                                    if (predecessors != null && !predecessors.isEmpty()) {
                                        successors.addAll(predecessors);
                                    } else {
                                        (this).CollaborationAccountPreferencePage.this.fDefaultWorkingCopy = copy;
                                    }
                                    successors.add(copy);
                                    (this).CollaborationAccountPreferencePage.this.fAccountViewer.setInput(successors);
                                    (this).CollaborationAccountPreferencePage.this.fAccountViewer.setSelection((ISelection)new StructuredSelection((Object)copy), true);
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            addJob.setPriority(10);
            addJob.setSystem(true);
            addJob.schedule();
        }
    }

    final void handleConnect() {
        IStructuredSelection extended;
        Object element;
        ISelection selection = this.fAccountViewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = (extended = (IStructuredSelection)selection).getFirstElement()) instanceof CollaborationAccountInfoWorkingCopy) {
            CollaborationAccountInfoWorkingCopy copy = (CollaborationAccountInfoWorkingCopy)element;
            ICollaborationService service = CollaborationCore.getCollaborationService();
            if (!service.getAccountManager().hasAccount(copy.getInfo())) {
                this.updateAccounts();
            }
            service.scheduleJob((CollaborationServiceJob)new CollaborationAccountConnectionJob(CollaborationMessages.CollaborationAccountPreferencePage_4, copy, true));
        }
    }

    final void handleDefault() {
        IStructuredSelection extended;
        Object element;
        ISelection selection = this.fAccountViewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = (extended = (IStructuredSelection)selection).getFirstElement()) instanceof CollaborationAccountInfoWorkingCopy) {
            CollaborationAccountInfoWorkingCopy copy;
            this.fDefaultWorkingCopy = copy = (CollaborationAccountInfoWorkingCopy)element;
            this.fAccountViewer.refresh(true);
            this.updateButtons(copy, 1);
        }
    }

    final void handleDisconnect() {
        IStructuredSelection extended;
        Object element;
        ISelection selection = this.fAccountViewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = (extended = (IStructuredSelection)selection).getFirstElement()) instanceof CollaborationAccountInfoWorkingCopy) {
            CollaborationAccountInfoWorkingCopy copy = (CollaborationAccountInfoWorkingCopy)element;
            ICollaborationService service = CollaborationCore.getCollaborationService();
            if (!service.getAccountManager().hasAccount(copy.getInfo())) {
                this.updateAccounts();
            }
            service.scheduleJob((CollaborationServiceJob)new CollaborationAccountConnectionJob(CollaborationMessages.CollaborationAccountPreferencePage_6, copy, false));
        }
    }

    final void handleEditAccount(CollaborationAccountInfoWorkingCopy copy) {
        Assert.isNotNull((Object)copy);
        final CollaborationAccountInfo predecessor = copy.getInfo();
        Map<ICollaborationProvider, Boolean> providers = this.computeEnforcementMap(predecessor);
        if (providers.isEmpty()) {
            return;
        }
        CollaborationAccountDialog dialog = new CollaborationAccountDialog(this.getShell(), this.getEditAccountTitle(), providers, predecessor, this.fCurrentIdentities);
        if (dialog.open() != 0) {
            return;
        }
        final CollaborationAccountInfo successor = dialog.getAccountInfo();
        if (successor != null) {
            this.getApplyButton().setEnabled(true);
            FoundationJob editJob = new FoundationJob(CollaborationMessages.CollaborationAccountPreferencePage_21){

                public IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    final CollaborationAccountInfoWorkingCopy successorCopy = CollaborationAccountPreferencePage.this.createWorkingCopy(successor, monitor);
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                Control control;
                                if ((this).CollaborationAccountPreferencePage.this.fAccountViewer != null && (control = (this).CollaborationAccountPreferencePage.this.fAccountViewer.getControl()) != null && !control.isDisposed()) {
                                    ArrayList<CollaborationAccountInfoWorkingCopy> successorCopies = new ArrayList<CollaborationAccountInfoWorkingCopy>(4);
                                    Collection predecessorCopies = (Collection)(this).CollaborationAccountPreferencePage.this.fAccountViewer.getInput();
                                    if (predecessorCopies != null) {
                                        for (CollaborationAccountInfoWorkingCopy predecessorCopy : predecessorCopies) {
                                            if (predecessor.equals((Object)predecessorCopy.getInfo())) {
                                                successorCopies.add(successorCopy);
                                                continue;
                                            }
                                            successorCopies.add(predecessorCopy);
                                        }
                                    } else {
                                        successorCopies.add(successorCopy);
                                    }
                                    (this).CollaborationAccountPreferencePage.this.fAccountViewer.setInput(successorCopies);
                                    (this).CollaborationAccountPreferencePage.this.fAccountViewer.setSelection((ISelection)new StructuredSelection((Object)successorCopy), true);
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            editJob.setPriority(10);
            editJob.setSystem(true);
            editJob.schedule();
        }
    }

    final void handleRemoveAccount() {
        ISelection selection = this.fAccountViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection extended = (IStructuredSelection)selection;
            Collection copies = (Collection)this.fAccountViewer.getInput();
            if (copies != null) {
                for (CollaborationAccountInfoWorkingCopy copy : extended.toList()) {
                    if (!copies.remove(copy)) continue;
                    CollaborationCore.getCollaborationService().scheduleJob((CollaborationServiceJob)new CollaborationAccountConnectionJob(CollaborationMessages.CollaborationAccountPreferencePage_6, copy, false));
                }
                this.fAccountViewer.setInput(new ArrayList(copies));
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        super.performApply();
        this.getApplyButton().setEnabled(false);
    }

    public boolean performOk() {
        return this.updateAccounts();
    }

    protected final void saveAccounts() {
        DefaultCollaborationService.getInstance().getAccountManager().saveAccounts();
    }

    final boolean updateAccounts() {
        Collection copies = (Collection)this.fAccountViewer.getInput();
        if (copies != null) {
            ICollaborationAccountManager manager = CollaborationCore.getCollaborationService().getAccountManager();
            HashSet<Object> unchanged = new HashSet<Object>(4);
            Collection infos = manager.getAccounts();
            for (CollaborationAccountInfoWorkingCopy copy : copies) {
                CollaborationAccountInfo successor = copy.getInfo();
                for (CollaborationAccountInfo predecessor : infos) {
                    if (!predecessor.equals((Object)successor)) continue;
                    unchanged.add(successor);
                }
            }
            ArrayList remove = new ArrayList(infos);
            remove.removeAll(unchanged);
            for (CollaborationAccountInfo info : remove) {
                manager.removeAccount(info);
            }
            ArrayList<CollaborationAccountInfo> add = new ArrayList<CollaborationAccountInfo>(copies.size());
            for (CollaborationAccountInfoWorkingCopy copy : copies) {
                add.add(copy.getInfo());
            }
            add.removeAll(unchanged);
            for (CollaborationAccountInfo info : add) {
                manager.addAccount(info);
            }
            infos = manager.getAccounts();
            if (this.fDefaultWorkingCopy != null && !this.fDefaultWorkingCopy.getInfo().equals((Object)manager.getDefaultAccount())) {
                manager.setDefault(this.fDefaultWorkingCopy.getInfo());
            }
            this.saveAccounts();
            return true;
        }
        return false;
    }

    final void updateButtons(CollaborationAccountInfoWorkingCopy copy, int size) {
        boolean hasIdentities = !this.fCurrentIdentities.isEmpty();
        DefaultCollaborationService service = DefaultCollaborationService.getInstance();
        this.fAddButton.setEnabled(hasIdentities && !this.computeEnforcementMap(null).isEmpty());
        this.fEditButton.setEnabled(copy != null ? this.fCurrentIdentities.contains(copy.getInfo().getUser()) : false);
        this.fRemoveButton.setEnabled(size > 0 && hasIdentities);
        boolean loggedIn = copy != null ? service.isLoggedIn(copy.getInfo()) : false;
        boolean validSingleton = size == 1 && hasIdentities && copy != null;
        this.fConnectButton.setEnabled(validSingleton && !loggedIn);
        this.fDisconnectButton.setEnabled(validSingleton && loggedIn);
        this.fDefaultButton.setEnabled(validSingleton && copy != null && !copy.equals(this.fDefaultWorkingCopy));
    }

    private final class CollaborationAccountConnectionJob
    extends CollaborationServiceJob {
        private final boolean fConnect;
        private final String fName;
        final CollaborationAccountInfoWorkingCopy fWorkingCopy;

        CollaborationAccountConnectionJob(String name, CollaborationAccountInfoWorkingCopy copy, boolean connect) {
            Assert.isNotNull((Object)name);
            Assert.isNotNull((Object)copy);
            this.fName = name;
            this.fWorkingCopy = copy;
            this.fConnect = connect;
        }

        public String getName() {
            return this.fName;
        }

        public IStatus run(IProgressMonitor monitor) {
            Display display;
            Assert.isNotNull((Object)monitor);
            CollaborationAccountInfo info = this.fWorkingCopy.getInfo();
            DefaultCollaborationService service = DefaultCollaborationService.getInstance();
            IStatus result = Status.OK_STATUS;
            try {
                if (this.fConnect) {
                    if (!service.isLoggedIn(info)) {
                        result = service.login(info, monitor);
                    }
                } else if (service.isLoggedIn(info)) {
                    result = service.logout(info, monitor);
                }
            }
            catch (Throwable throwable) {
                Display display2 = PlatformUI.getWorkbench().getDisplay();
                if (!display2.isDisposed()) {
                    display2.asyncExec(new Runnable(){

                        public void run() {
                            Control control;
                            if (((CollaborationAccountConnectionJob)CollaborationAccountConnectionJob.this).CollaborationAccountPreferencePage.this.fAccountViewer != null && (control = ((CollaborationAccountConnectionJob)CollaborationAccountConnectionJob.this).CollaborationAccountPreferencePage.this.fAccountViewer.getControl()) != null && !control.isDisposed()) {
                                ((CollaborationAccountConnectionJob)CollaborationAccountConnectionJob.this).CollaborationAccountPreferencePage.this.fAccountViewer.refresh(true);
                                ISelection selection = ((CollaborationAccountConnectionJob)CollaborationAccountConnectionJob.this).CollaborationAccountPreferencePage.this.fAccountViewer.getSelection();
                                if (selection instanceof IStructuredSelection) {
                                    IStructuredSelection extended = (IStructuredSelection)selection;
                                    CollaborationAccountPreferencePage.this.updateButtons(CollaborationAccountConnectionJob.this.fWorkingCopy, extended.size());
                                }
                            }
                        }
                    });
                }
                throw throwable;
            }
            if (!(display = PlatformUI.getWorkbench().getDisplay()).isDisposed()) {
                display.asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
            return CollaborationExceptionHandler.handleErrorStatus(result);
        }
    }

    private final class CollaborationAccountInfoLabelProvider
    extends CellLabelProvider
    implements ICollaborationPresenceListener,
    ICollaborationSessionListener,
    ICollaborationUserListener {
        private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        CollaborationAccountInfoLabelProvider() {
            ICollaborationService service = CollaborationCore.getCollaborationService();
            service.addPresenceListener((ICollaborationPresenceListener)this);
            service.addSessionListener((ICollaborationSessionListener)this);
            service.addUserListener((ICollaborationUserListener)this);
        }

        public void dispose() {
            ICollaborationService service = CollaborationCore.getCollaborationService();
            service.removeSessionListener((ICollaborationSessionListener)this);
            service.removePresenceListener((ICollaborationPresenceListener)this);
            service.removeUserListener((ICollaborationUserListener)this);
            this.fResourceManager.dispose();
            super.dispose();
        }

        private void presenceChanged(CollaborationUser user) {
            Assert.isNotNull((Object)user);
            Collection copies = (Collection)CollaborationAccountPreferencePage.this.fAccountViewer.getInput();
            if (copies != null) {
                final ArrayList<CollaborationAccountInfoWorkingCopy> affected = new ArrayList<CollaborationAccountInfoWorkingCopy>(copies.size());
                for (CollaborationAccountInfoWorkingCopy copy : copies) {
                    if (!copy.getInfo().getUser().equals((Object)user)) continue;
                    affected.add(copy);
                }
                FoundationJob job = new FoundationJob(CollaborationMessages.CollaborationAccountPreferencePage_13){

                    public IStatus runProtected(IProgressMonitor monitor) {
                        Assert.isNotNull((Object)monitor);
                        DefaultCollaborationService service = DefaultCollaborationService.getInstance();
                        for (CollaborationAccountInfoWorkingCopy copy : affected) {
                            copy.setStatus(service.getPresenceStatus(copy.getInfo(), (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
                        }
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    CollaborationAccountInfoLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)CollaborationAccountInfoLabelProvider.this, affected.toArray()));
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.setSystem(true);
                job.schedule();
            }
        }

        public void presenceNotification(CollaborationPresenceEvent event) {
            Assert.isNotNull((Object)event);
            this.presenceChanged(event.getUser());
        }

        public void sessionNotification(CollaborationSessionEvent event) {
            Assert.isNotNull((Object)event);
            CollaborationUser user = event.getUser();
            if (user != null) {
                this.presenceChanged(user);
            }
        }

        public void update(ViewerCell cell) {
            Assert.isNotNull((Object)cell);
            Object element = cell.getElement();
            if (element instanceof CollaborationAccountInfoWorkingCopy) {
                CollaborationAccountInfoWorkingCopy copy = (CollaborationAccountInfoWorkingCopy)element;
                CollaborationPresenceStatus status = copy.getStatus().getStandard();
                if (CollaborationAccountPreferencePage.this.fDefaultWorkingCopy != null && copy.equals(CollaborationAccountPreferencePage.this.fDefaultWorkingCopy)) {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                    imageDescriptorArray[1] = CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/current_account_ovr.gif");
                    cell.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)new OverlayIcon(CollaborationUI.getImageDescriptor(status, true), imageDescriptorArray, 17408)));
                    cell.setText(MessageFormat.format(CollaborationMessages.CollaborationAccountPreferencePage_24, copy.getDescription()));
                } else {
                    cell.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)CollaborationUI.getImageDescriptor(status, true)));
                    cell.setText(copy.getDescription());
                }
                cell.setForeground(JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)CollaborationUI.getForegroundColor(status, true)));
                int style = CollaborationUI.getFontStyle(status);
                FontRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
                FontDescriptor descriptor = registry.getDescriptor("org.eclipse.jface.defaultfont").withStyle(style);
                cell.setFont(JazzResources.getFont((ResourceManager)this.fResourceManager, (FontDescriptor)descriptor, null));
            }
        }

        public void userNotification(CollaborationUserEvent event) {
            Assert.isNotNull((Object)event);
            CollaborationCore.getCollaborationService().scheduleJob((CollaborationServiceJob)new CollaborationAccountInitializerJob(CollaborationMessages.CollaborationAccountPreferencePage_16));
        }
    }

    private static final class CollaborationAccountInfoViewerSorter
    extends ViewerComparator {
        private final Map<String, Integer> fIndexMap = new HashMap<String, Integer>(4);

        CollaborationAccountInfoViewerSorter() {
            Collection providers = CollaborationCore.getCollaborationService().getProviders(0);
            int index = 1;
            for (ICollaborationProvider provider : providers) {
                this.fIndexMap.put(provider.getId(), index);
                ++index;
            }
        }

        public int category(Object element) {
            CollaborationAccountInfoWorkingCopy copy = (CollaborationAccountInfoWorkingCopy)element;
            Integer result = this.fIndexMap.get(copy.getInfo().getProviderId());
            if (result != null) {
                return result;
            }
            return 0;
        }

        public int compare(Viewer viewer, Object first, Object second) {
            CollaborationAccountInfoWorkingCopy predecessor = (CollaborationAccountInfoWorkingCopy)first;
            CollaborationAccountInfoWorkingCopy successor = (CollaborationAccountInfoWorkingCopy)second;
            return Collator.getInstance().compare(predecessor.getDescription(), successor.getDescription());
        }
    }

    private static final class CollaborationAccountInfoWorkingCopy
    implements IModelAccessor {
        private String fDescription;
        private final CollaborationAccountInfo fInfo;
        private CollaborationPresenceStatus fStatus;

        CollaborationAccountInfoWorkingCopy(CollaborationAccountInfo info, String description, CollaborationPresenceStatus status) {
            Assert.isNotNull((Object)info);
            Assert.isNotNull((Object)description);
            Assert.isNotNull((Object)status);
            this.fInfo = info;
            this.fDescription = description;
            this.fStatus = status;
        }

        public boolean equals(Object object) {
            if (object instanceof CollaborationAccountInfoWorkingCopy) {
                CollaborationAccountInfoWorkingCopy copy = (CollaborationAccountInfoWorkingCopy)object;
                return this.fInfo.equals((Object)copy.getInfo());
            }
            return false;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public CollaborationAccountInfo getInfo() {
            return this.fInfo;
        }

        public CollaborationAccountInfo getModelInstance() {
            return this.fInfo;
        }

        public CollaborationPresenceStatus getStatus() {
            return this.fStatus;
        }

        public int hashCode() {
            return this.fInfo.hashCode();
        }

        public void setDescription(String description) {
            Assert.isNotNull((Object)description);
            this.fDescription = description;
        }

        public void setStatus(CollaborationPresenceStatus status) {
            Assert.isNotNull((Object)status);
            this.fStatus = status;
        }
    }

    private final class CollaborationAccountInitializerJob
    extends CollaborationServiceJob {
        private final String fName;

        CollaborationAccountInitializerJob(String name) {
            Assert.isNotNull((Object)name);
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isSystem() {
            return true;
        }

        public IStatus run(IProgressMonitor monitor) {
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask(CollaborationMessages.CollaborationAccountPreferencePage_8, 300);
                CollaborationAccountManager manager = DefaultCollaborationService.getInstance().getAccountManager();
                manager.loadAccounts((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                Collection infos = manager.getAccounts();
                if (!infos.isEmpty()) {
                    final ArrayList<CollaborationAccountInfoWorkingCopy> copies = new ArrayList<CollaborationAccountInfoWorkingCopy>(4);
                    for (CollaborationAccountInfo info : infos) {
                        CollaborationAccountInfoWorkingCopy copy = CollaborationAccountPreferencePage.this.createWorkingCopy(info, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                        if (copy == null) continue;
                        if (info.isDefault()) {
                            CollaborationAccountPreferencePage.this.fDefaultWorkingCopy = copy;
                        }
                        copies.add(copy);
                    }
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                Control control;
                                if (((CollaborationAccountInitializerJob)CollaborationAccountInitializerJob.this).CollaborationAccountPreferencePage.this.fAccountViewer != null && (control = ((CollaborationAccountInitializerJob)CollaborationAccountInitializerJob.this).CollaborationAccountPreferencePage.this.fAccountViewer.getControl()) != null && !control.isDisposed()) {
                                    ((CollaborationAccountInitializerJob)CollaborationAccountInitializerJob.this).CollaborationAccountPreferencePage.this.fAccountViewer.setInput((Object)copies);
                                }
                            }
                        });
                    }
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }

    private final class CollaborationAutoLoginListener
    implements ITeamRepositoryService.IRepositoryServiceListener,
    IListener {
        CollaborationAutoLoginListener() {
        }

        public void addedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.addGenericListener((Object)"state", (IListener)CollaborationAccountPreferencePage.this.fAutoLoginListener);
        }

        public void handleEvents(List events) {
            Assert.isNotNull((Object)events);
            for (Object event : events) {
                IEventSource source;
                PropertyChangeEvent extended;
                Object property;
                if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
                ITeamRepository repository = (ITeamRepository)source;
                int state = repository.getState();
                switch (state) {
                    case 1: {
                        this.handleLogin(repository);
                        break;
                    }
                    case 3: {
                        this.handleLogout(repository);
                    }
                }
            }
        }

        void handleLogin(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        ICollaborationService service = CollaborationCore.getCollaborationService();
                        ((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fCurrentIdentities = service.getAccountManager().getIdentities();
                        Control control = ((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fAccountViewer.getControl();
                        if (control != null && !control.isDisposed()) {
                            if (((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fLastAccountGroupState != null) {
                                ((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fLastAccountGroupState.restore();
                            } else if (((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fViewerComposite != null && !((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fViewerComposite.isDisposed()) {
                                ((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fViewerComposite.setEnabled(true);
                                control.setEnabled(true);
                            }
                            service.scheduleJob((CollaborationServiceJob)new CollaborationAccountInitializerJob(CollaborationMessages.CollaborationAccountPreferencePage_16));
                            CollaborationAccountPreferencePage.this.updateButtons(null, 0);
                        }
                    }
                });
            }
        }

        void handleLogout(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fViewerComposite != null && !((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fViewerComposite.isDisposed()) {
                            CollaborationAccountPreferencePage.this.updateButtons(null, 0);
                            ((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fLastAccountGroupState = ControlEnableState.disable((Control)((CollaborationAutoLoginListener)CollaborationAutoLoginListener.this).CollaborationAccountPreferencePage.this.fViewerComposite);
                        }
                    }
                });
            }
        }

        public void removedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.removeGenericListener((Object)"state", (IListener)CollaborationAccountPreferencePage.this.fAutoLoginListener);
        }
    }
}

