/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.ui.preference;

import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.ui.preference.CollaborationAccountControlConfiguration;
import com.ibm.team.collaboration.ui.preference.ICollaborationAccountControl;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCollaborationAccountControl
implements ICollaborationAccountControl {
    final CollaborationAccountControlConfiguration fConfiguration;
    private CollaborationUser fCurrentIdentity;
    Combo fIdentityCombo = null;

    private static final boolean sameCollaborationUsers(CollaborationUser first, CollaborationUser second) {
        Assert.isNotNull((Object)first);
        Assert.isNotNull((Object)second);
        UUID firstUUID = first.getUUID();
        UUID secondUUID = second.getUUID();
        if (!firstUUID.equals((Object)secondUUID)) {
            return false;
        }
        IContributorHandle firstHandle = first.getContributor();
        IContributorHandle secondHandle = second.getContributor();
        if (firstHandle == null && secondHandle == null) {
            return firstUUID.equals((Object)secondUUID);
        }
        if (firstHandle == null || secondHandle == null) {
            return false;
        }
        ITeamRepository firstRepository = null;
        ITeamRepository secondRepository = null;
        Object object = firstHandle.getOrigin();
        if (object instanceof ITeamRepository) {
            firstRepository = (ITeamRepository)object;
        }
        if ((object = secondHandle.getOrigin()) instanceof ITeamRepository) {
            secondRepository = (ITeamRepository)object;
        }
        if (firstRepository == null || secondRepository == null) {
            return false;
        }
        return firstRepository.getRepositoryURI().equalsIgnoreCase(secondRepository.getRepositoryURI());
    }

    protected AbstractCollaborationAccountControl(CollaborationAccountControlConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fConfiguration = configuration;
        this.fCurrentIdentity = configuration.getIdentities().iterator().next();
    }

    protected final void configureTraversal(final Control predecessor, final Control successor) {
        if (predecessor != null) {
            predecessor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    Assert.isNotNull((Object)event);
                    switch (event.detail) {
                        case 16: {
                            if (!(successor instanceof Text)) break;
                            ((Text)successor).selectAll();
                        }
                    }
                }
            });
        }
        if (successor != null) {
            successor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    Assert.isNotNull((Object)event);
                    switch (event.detail) {
                        case 8: {
                            if (!(predecessor instanceof Text)) break;
                            ((Text)predecessor).selectAll();
                        }
                    }
                }
            });
        }
    }

    protected final Control createIdentityControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(CollaborationMessages.AbstractCollaborationAccountControl_0);
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(CollaborationMessages.AbstractCollaborationAccountControl_1);
        this.fIdentityCombo = new Combo((Composite)group, 12);
        this.fIdentityCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        FoundationJob job = new FoundationJob(CollaborationMessages.AbstractCollaborationAccountControl_2){

            public IStatus runProtected(IProgressMonitor monitor) {
                Assert.isNotNull((Object)monitor);
                try {
                    Collection<CollaborationUser> identities = AbstractCollaborationAccountControl.this.fConfiguration.getIdentities();
                    final ArrayList<String> labels = new ArrayList<String>(identities.size());
                    final HashMap<String, CollaborationUser> mapping = new HashMap<String, CollaborationUser>(identities.size());
                    monitor.beginTask(CollaborationMessages.AbstractCollaborationAccountControl_3, identities.size() * 200);
                    StringBuilder builder = new StringBuilder(128);
                    for (CollaborationUser identity : identities) {
                        ITeamRepository repository;
                        Object origin;
                        builder.setLength(0);
                        String name = null;
                        IContributorHandle handle = identity.getContributor();
                        if (handle != null && (origin = handle.getOrigin()) instanceof ITeamRepository && ((name = (repository = (ITeamRepository)origin).getName()) == null || "".equals(name)) && ((name = repository.publicUriRoot()) == null || "".equals(name))) {
                            name = repository.getRepositoryURI();
                            try {
                                name = new URI(name).getHost();
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                        if (name == null || "".equals(name)) {
                            name = CollaborationMessages.AbstractCollaborationAccountControl_5;
                        }
                        builder.append(MessageFormat.format(CollaborationMessages.AbstractCollaborationAccountControl_4, identity.getUserName((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)), identity.getUserId((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)), name));
                        String string = builder.toString();
                        labels.add(string);
                        mapping.put(string, identity);
                    }
                    AbstractCollaborationAccountControl.this.fIdentityCombo.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!(this).AbstractCollaborationAccountControl.this.fIdentityCombo.isDisposed()) {
                                (this).AbstractCollaborationAccountControl.this.fIdentityCombo.setData((Object)mapping);
                                for (String string : labels) {
                                    (this).AbstractCollaborationAccountControl.this.fIdentityCombo.add(string);
                                }
                                AbstractCollaborationAccountControl.this.setCurrentIdentity((this).AbstractCollaborationAccountControl.this.fConfiguration.getIdentity());
                            }
                        }
                    });
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
        this.fIdentityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CollaborationUser user;
                Map mapping;
                Assert.isNotNull((Object)event);
                int index = AbstractCollaborationAccountControl.this.fIdentityCombo.getSelectionIndex();
                if (index >= 0 && (mapping = (Map)AbstractCollaborationAccountControl.this.fIdentityCombo.getData()) != null && (user = (CollaborationUser)mapping.get(AbstractCollaborationAccountControl.this.fIdentityCombo.getItem(index))) != null) {
                    AbstractCollaborationAccountControl.this.handleIdentityChanged(user);
                }
            }
        });
        return group;
    }

    protected final CollaborationAccountControlConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    public final CollaborationUser getCurrentIdentity() {
        return this.fCurrentIdentity;
    }

    protected void handleIdentityChanged(CollaborationUser identity) {
        Assert.isNotNull((Object)identity);
        this.fCurrentIdentity = identity;
    }

    public final void setCurrentIdentity(CollaborationUser identity) {
        Map mapping;
        Assert.isNotNull((Object)identity);
        Assert.isLegal((boolean)this.fConfiguration.getIdentities().contains(identity), (String)"Current identities must include identity.");
        this.fCurrentIdentity = identity;
        if (this.fIdentityCombo != null && !this.fIdentityCombo.isDisposed() && (mapping = (Map)this.fIdentityCombo.getData()) != null) {
            for (Map.Entry entry : mapping.entrySet()) {
                if (!AbstractCollaborationAccountControl.sameCollaborationUsers(identity, (CollaborationUser)entry.getValue())) continue;
                String[] items = this.fIdentityCombo.getItems();
                int index = 0;
                while (index < items.length) {
                    if (items[index].equals(entry.getKey())) {
                        this.fIdentityCombo.select(index);
                        return;
                    }
                    ++index;
                }
            }
        }
    }
}

