/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.ui.context;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCollaborationContextProvider
implements ICollaborationContextProvider {
    final ISelectionProvider fSelectionProvider;

    public DefaultCollaborationContextProvider(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fSelectionProvider = provider;
    }

    @Override
    public CollaborationData getContext(Collection<CollaborationUser> users, IProgressMonitor monitor) {
        Assert.isNotNull(users);
        return null;
    }

    public final ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    @Override
    public Collection<URIReference> getTopics(final Collection<CollaborationUser> users, final IProgressMonitor monitor) {
        final ArrayList<URIReference> topics = new ArrayList<URIReference>(4);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public final void run() {
                    ISelection selection = DefaultCollaborationContextProvider.this.fSelectionProvider.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        Object[] elements;
                        IStructuredSelection extended = (IStructuredSelection)selection;
                        Object[] objectArray = elements = extended.toArray();
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            URIReference reference;
                            Object element = objectArray[n2];
                            boolean found = false;
                            if (element instanceof IContributorHandle) {
                                IContributorHandle handle = (IContributorHandle)element;
                                for (CollaborationUser user : users) {
                                    if (!handle.getItemId().equals((Object)user.getUUID())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found && (reference = Hyperlinks.create((Object)element, (IProgressMonitor)monitor)) != null) {
                                topics.add(reference);
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
        return topics;
    }
}

