/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.ui;

import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.internal.ui.action.ContactContributorsActionDelegate;
import com.ibm.team.collaboration.internal.ui.util.CollaborationUserImageManager;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollaborationUI {
    private static final String COLOR_ACTIVE_ID = "com.ibm.team.collaboration.ui.CollaborationUI.COLOR_ACTIVE";
    private static final String COLOR_INACTIVE_ID = "com.ibm.team.collaboration.ui.CollaborationUI.COLOR_INACTIVE";

    public static IStatus contactContributors(IWorkbenchPart part, Collection<IContributorHandle> handles, final ICollaborationContextProvider provider, IProgressMonitor monitor) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull(handles);
        Assert.isLegal((!handles.isEmpty() ? 1 : 0) != 0, (String)"Contributors must not be empty.");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ContactContributorsActionDelegate delegate = new ContactContributorsActionDelegate(){

            protected ICollaborationContextProvider getContextProvider() {
                if (provider != null) {
                    return provider;
                }
                return super.getContextProvider();
            }
        };
        Action dummy = new Action(){};
        delegate.setActivePart((IAction)dummy, part);
        delegate.selectionChanged((IAction)dummy, (ISelection)new StructuredSelection(handles.toArray()));
        return delegate.run(monitor);
    }

    public static int getFontStyle(CollaborationPresenceStatus status) {
        Assert.isNotNull((Object)status);
        CollaborationPresenceStatus standard = status.getStandard();
        if (standard != null && standard.isAvailable()) {
            return 1;
        }
        return 0;
    }

    public static RGB getForegroundColor(CollaborationPresenceStatus status, boolean enabled) {
        CollaborationPresenceStatus standard;
        Assert.isNotNull((Object)status);
        if (enabled && (standard = status.getStandard()) != null && standard.isActive()) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(COLOR_ACTIVE_ID);
        }
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(COLOR_INACTIVE_ID);
    }

    public static RGB getHighlightColor(CollaborationPresenceStatus status) {
        Assert.isNotNull((Object)status);
        return ColorUtils.blend((RGB)new RGB(0, 0, 0), (RGB)CollaborationUI.getForegroundColor(status, true), (int)60);
    }

    public static ImageDescriptor getImageDescriptor(CollaborationPresenceStatus status, boolean enabled) {
        Assert.isNotNull((Object)status);
        String prefix = enabled ? "$nl$/icons/full/elcl16/" : "$nl$/icons/full/dlcl16/";
        CollaborationPresenceStatus standard = status.getStandard();
        if (standard != null) {
            if (CollaborationPresenceStatus.STATUS_OFFLINE.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor(String.valueOf(prefix) + "presence_offline.gif");
            }
            if (CollaborationPresenceStatus.STATUS_AVAILABLE.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor(String.valueOf(prefix) + "presence_available.gif");
            }
            if (CollaborationPresenceStatus.STATUS_AWAY.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor(String.valueOf(prefix) + "presence_away.gif");
            }
            if (CollaborationPresenceStatus.STATUS_DO_NOT_DISTURB.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor(String.valueOf(prefix) + "presence_dnd.gif");
            }
            if (CollaborationPresenceStatus.STATUS_IN_A_MEETING.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor(String.valueOf(prefix) + "presence_meeting.gif");
            }
        }
        return CollaborationUIPlugin.getImageDescriptor(String.valueOf(prefix) + "presence_offline.gif");
    }

    public static ImageDescriptor getImageDescriptor(IContributorHandle handle, int width, int height, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handle);
        Assert.isLegal((width > 0 ? 1 : 0) != 0, (String)"Width must be greater than zero");
        Assert.isLegal((height > 0 ? 1 : 0) != 0, (String)"Height must be greater than zero");
        return CollaborationUserImageManager.getImageDescriptor(handle, width, height, monitor);
    }

    public static ImageDescriptor getOverlayDescriptor(CollaborationPresenceStatus status) {
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)status);
        CollaborationPresenceStatus standard = status.getStandard();
        if (standard != null) {
            if (CollaborationPresenceStatus.STATUS_OFFLINE.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/presence_offline_ovr.gif");
            }
            if (CollaborationPresenceStatus.STATUS_AVAILABLE.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/presence_available_ovr.gif");
            }
            if (CollaborationPresenceStatus.STATUS_AWAY.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/presence_away_ovr.gif");
            }
            if (CollaborationPresenceStatus.STATUS_DO_NOT_DISTURB.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/presence_dnd_ovr.gif");
            }
            if (CollaborationPresenceStatus.STATUS_IN_A_MEETING.equals((Object)standard)) {
                return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/presence_meeting_ovr.gif");
            }
        }
        return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/presence_offline_ovr.gif");
    }

    public static ImageDescriptor getOverlayDescriptor(IContributorHandle handle) {
        ITeamRepository repository;
        Assert.isNotNull((Object)handle);
        Object origin = handle.getOrigin();
        if (origin instanceof ITeamRepository && handle.sameItemId((IItemHandle)(repository = (ITeamRepository)origin).loggedInContributor())) {
            return CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/ovr16/self_presence_ovr.gif");
        }
        return null;
    }

    private CollaborationUI() {
    }
}

