/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.viewer;

import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.internal.ui.viewer.CollaborationViewerUIProxy;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollaborationViewerUIRegistry
extends ExtensionRegistryReader<CollaborationViewerUIProxy> {
    private static final String ATTRIBUTE_PROVIDER_ID = "providerId";
    private static final String ATTRIBUTE_VIEWER_ID = "viewerId";
    private static final String ELEMENT_VIEWER_ASSOCIATION = "viewerAssociation";
    private static final String EXTENSION_POINT_ID = "collaborationViewerUI";
    private static CollaborationViewerUIRegistry fgInstance = null;
    private final Map<String, String> fViewerAssociations = new HashMap<String, String>(4);
    private final Map<String, CollaborationViewerUIProxy> fViewerContributions = new HashMap<String, CollaborationViewerUIProxy>(4);

    public static CollaborationViewerUIRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new CollaborationViewerUIRegistry();
        }
        return fgInstance;
    }

    private CollaborationViewerUIRegistry() {
        super("com.ibm.team.collaboration.rcp.ui", EXTENSION_POINT_ID);
    }

    public CollaborationViewerUIProxy getViewerUI(String providerId) {
        Assert.isNotNull((Object)providerId);
        String viewerId = this.fViewerAssociations.get(providerId);
        if (viewerId != null) {
            return this.fViewerContributions.get(viewerId);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CollaborationViewerUIProxy handleExtensionAdded(IConfigurationElement element) throws Exception {
        Assert.isNotNull((Object)element);
        if ("viewerUI".equals(element.getName())) {
            String id = element.getAttribute("id");
            String qualified = element.getAttribute("class");
            if (id == null || "".equals(id)) {
                CollaborationUIPlugin.getInstance().log(CollaborationMessages.CollaborationViewerUIRegistry_0);
                return null;
            }
            if (qualified != null && !"".equals(qualified)) {
                CollaborationViewerUIProxy proxy = new CollaborationViewerUIProxy(element);
                this.fViewerContributions.put(id, proxy);
                return proxy;
            }
            CollaborationUIPlugin.getInstance().log(CollaborationMessages.CollaborationViewerUIRegistry_1);
            return null;
        }
        if (!ELEMENT_VIEWER_ASSOCIATION.equals(element.getName())) return null;
        String providerId = element.getAttribute(ATTRIBUTE_PROVIDER_ID);
        String viewerId = element.getAttribute(ATTRIBUTE_VIEWER_ID);
        if (providerId == null || "".equals(providerId)) {
            CollaborationUIPlugin.getInstance().log(CollaborationMessages.CollaborationViewerUIRegistry_2);
            return null;
        }
        if (viewerId != null && !"".equals(viewerId)) {
            this.fViewerAssociations.put(providerId, viewerId);
            return null;
        }
        CollaborationUIPlugin.getInstance().log(CollaborationMessages.CollaborationViewerUIRegistry_3);
        return null;
    }

    protected void handleExtensionRemoved(IConfigurationElement element, CollaborationViewerUIProxy descriptor) throws Exception {
        Assert.isNotNull((Object)element);
        String name = element.getName();
        if ("viewerUI".equals(name)) {
            String id = element.getAttribute("id");
            if (id != null) {
                this.fViewerContributions.remove(id);
            }
        } else if (ELEMENT_VIEWER_ASSOCIATION.equals(name)) {
            String test;
            String providerId = element.getAttribute(ATTRIBUTE_PROVIDER_ID);
            String viewerId = element.getAttribute(ATTRIBUTE_VIEWER_ID);
            if (providerId != null && viewerId != null && viewerId.equals(test = this.fViewerAssociations.get(providerId))) {
                this.fViewerAssociations.remove(providerId);
            }
        }
    }

    public boolean hasViewerUI(String providerId) {
        Assert.isNotNull((Object)providerId);
        return this.fViewerAssociations.get(providerId) != null;
    }
}

