/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.viewer;

import com.ibm.team.collaboration.core.meeting.CollaborationMeetingEvent;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.ui.viewer.ICollaborationViewerUI;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class CollaborationViewerUIProxy
implements ICollaborationViewerUI {
    static final String ATTRIBUTE_CLASS = "class";
    static final String ATTRIBUTE_ID = "id";
    static final String ELEMENT_VIEWER_UI = "viewerUI";
    private final IConfigurationElement fElement;
    private Reference<ICollaborationViewerUI> fReference = null;

    public CollaborationViewerUIProxy(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public String getId() {
        return this.fElement.getAttribute(ATTRIBUTE_ID);
    }

    private void lazyLoadViewerUI() {
        if (this.fReference == null || this.fReference.get() == null) {
            try {
                Object object = this.fElement.createExecutableExtension(ATTRIBUTE_CLASS);
                if (object instanceof ICollaborationViewerUI) {
                    this.fReference = new WeakReference<ICollaborationViewerUI>((ICollaborationViewerUI)object);
                }
            }
            catch (CoreException exception) {
                CollaborationUIPlugin plugin = CollaborationUIPlugin.getInstance();
                plugin.log(MessageFormat.format(CollaborationMessages.CollaborationViewerUIProxy_0, this.getId()));
                plugin.log(exception);
            }
        }
    }

    public IStatus manageMeeting(CollaborationMeetingEvent event, IProgressMonitor monitor) {
        this.lazyLoadViewerUI();
        if (this.fReference != null) {
            ICollaborationViewerUI viewerUI = this.fReference.get();
            if (viewerUI == null) {
                this.lazyLoadViewerUI();
            }
            if ((viewerUI = this.fReference.get()) != null) {
                return viewerUI.manageMeeting(event, monitor);
            }
        }
        return new Status(4, "com.ibm.team.collaboration.rcp.ui", CollaborationMessages.CollaborationViewerUIProxy_1);
    }
}

