/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.util;

import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorDetailsHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class CollaborationUserImageManager {
    private static ImageDescriptor associateImageData(String uuid, ImageData data) throws MalformedURLException {
        Assert.isNotNull((Object)uuid);
        Assert.isNotNull((Object)data);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        String osPath = JazzResources.getFilePathFromConfigArea((String)"com.ibm.team.collaboration.rcp.ui", (String)(String.valueOf(uuid) + ".jpg")).toOSString();
        loader.save(osPath, 4);
        File file = new File(osPath);
        file.deleteOnExit();
        URL url = file.toURI().toURL();
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        JazzResources.registerUrl((ImageDescriptor)descriptor, (URL)url);
        return descriptor;
    }

    private static ImageData fetchImageData(IContributorHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent content;
        IContributorDetails details;
        IContributorDetailsHandle detailsHandle;
        IItemManager manager;
        IContributor contributor;
        ITeamRepository repository;
        Assert.isNotNull((Object)handle);
        Object origin = handle.getOrigin();
        if (!(!(origin instanceof ITeamRepository) || !(repository = (ITeamRepository)origin).loggedIn() || (contributor = (IContributor)(manager = repository.itemManager()).fetchPartialItem((IItemHandle)handle, 0, CollaborationUser.CONTRIBUTOR_PROPERTIES, monitor)) == null || monitor != null && monitor.isCanceled() || (detailsHandle = contributor.getDetails()) == null || (details = (IContributorDetails)manager.fetchCompleteItem((IItemHandle)detailsHandle, 0, monitor)) == null || monitor != null && monitor.isCanceled() || (content = details.getPhoto()) == null)) {
            InputStream stream;
            block9: {
                ImageData imageData;
                stream = repository.contentManager().retrieveContentStream(content, monitor);
                try {
                    if (monitor != null && monitor.isCanceled()) break block9;
                    imageData = new ImageData(stream);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                return imageData;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static synchronized ImageDescriptor getImageDescriptor(IContributorHandle handle, int width, int height, IProgressMonitor monitor) {
        ImageData data;
        Assert.isNotNull((Object)handle);
        ImageRegistry registry = CollaborationUIPlugin.getInstance().getImageRegistry();
        StringBuilder builder = new StringBuilder(256);
        builder.append(handle.getItemId().getUuidValue());
        builder.append('_');
        builder.append(width);
        builder.append('x');
        builder.append(height);
        String uuid = builder.toString();
        ImageDescriptor descriptor = registry.getDescriptor(uuid);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = JazzResources.getImageDescriptorFromFileCache((String)"com.ibm.team.collaboration.rcp.ui", (String)(String.valueOf(uuid) + ".jpg"));
        if (descriptor == null) {
            try {
                data = CollaborationUserImageManager.fetchImageData(handle, monitor);
                if (data != null) {
                    descriptor = CollaborationUserImageManager.associateImageData(uuid, data.scaledTo(width, height));
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (MalformedURLException exception) {
                CollaborationUIPlugin.getInstance().log(exception);
            }
        }
        if (descriptor == null) {
            descriptor = CollaborationUIPlugin.getImageDescriptor("$nl$/icons/full/obj16/user_unknown.gif");
            try {
                data = descriptor.getImageData();
                if (data != null) {
                    descriptor = CollaborationUserImageManager.associateImageData(uuid, data.scaledTo(width, height));
                }
            }
            catch (MalformedURLException exception) {
                CollaborationUIPlugin.getInstance().log(exception);
            }
        }
        registry.put(uuid, descriptor);
        return descriptor;
    }

    private CollaborationUserImageManager() {
    }
}

