/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.util;

import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class CollaborationExceptionHandler {
    private CollaborationExceptionHandler() {
    }

    public static IStatus handleErrorStatus(IStatus status) {
        Assert.isNotNull((Object)status);
        final IStatus result = CollaborationExceptionHandler.compressStatus(status);
        if (result == null) {
            return Status.OK_STATUS;
        }
        String caption = null;
        String message = null;
        boolean log = true;
        switch (result.getCode()) {
            case 3: {
                caption = CollaborationMessages.ExceptionHandler_0;
                message = CollaborationMessages.ExceptionHandler_1;
                log = false;
                break;
            }
            case 7: {
                caption = CollaborationMessages.ExceptionHandler_2;
                message = CollaborationMessages.ExceptionHandler_3;
                log = false;
                break;
            }
            case 18: {
                caption = CollaborationMessages.ExceptionHandler_17;
                message = CollaborationMessages.ExceptionHandler_18;
                break;
            }
            case 4: {
                caption = CollaborationMessages.ExceptionHandler_16;
                message = CollaborationMessages.ExceptionHandler_19;
                break;
            }
            case 1: {
                caption = CollaborationMessages.ExceptionHandler_4;
                message = CollaborationMessages.ExceptionHandler_5;
                break;
            }
            case 13: {
                caption = CollaborationMessages.ExceptionHandler_6;
                message = CollaborationMessages.ExceptionHandler_7;
                log = false;
                break;
            }
            case 17: {
                caption = CollaborationMessages.ExceptionHandler_8;
                message = CollaborationMessages.ExceptionHandler_9;
                break;
            }
            case 14: {
                caption = CollaborationMessages.ExceptionHandler_10;
                message = CollaborationMessages.ExceptionHandler_11;
                log = false;
                break;
            }
            case 12: {
                caption = CollaborationMessages.ExceptionHandler_20;
                message = CollaborationMessages.ExceptionHandler_21;
                log = false;
                break;
            }
            case 15: {
                caption = CollaborationMessages.ExceptionHandler_12;
                message = CollaborationMessages.ExceptionHandler_13;
                log = false;
                break;
            }
            case 16: {
                caption = CollaborationMessages.ExceptionHandler_14;
                message = CollaborationMessages.ExceptionHandler_15;
                log = false;
            }
        }
        if (caption != null && message != null) {
            final String finalCaption = caption;
            final String finalMessage = message;
            final boolean finalLog = log;
            final IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        Shell shell;
                        IWorkbenchWindow window;
                        if (finalLog) {
                            CollaborationUIPlugin.getInstance().log(result);
                        }
                        if ((window = workbench.getActiveWorkbenchWindow()) != null && (shell = window.getShell()) != null && !shell.isDisposed()) {
                            ErrorDialog.openError((Shell)shell, (String)finalCaption, (String)finalMessage, (IStatus)result);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
        return result;
    }

    private static IStatus compressStatus(IStatus status) {
        Assert.isNotNull((Object)status);
        if (status.isOK()) {
            return null;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            ArrayList<IStatus> collection = new ArrayList<IStatus>(children.length);
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                IStatus compressed = CollaborationExceptionHandler.compressStatus(child);
                if (compressed != null) {
                    collection.add(compressed);
                }
                ++n2;
            }
            if (!collection.isEmpty()) {
                return new MultiStatus(status.getPlugin(), status.getCode(), collection.toArray(new IStatus[collection.size()]), status.getMessage(), status.getException());
            }
            return null;
        }
        return status;
    }
}

