/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.util;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ChangePresenceMenuCreator
implements IMenuCreator {
    private static final CollaborationPresenceStatus[] STATUS_CONSTANTS = new CollaborationPresenceStatus[]{CollaborationPresenceStatus.STATUS_AVAILABLE, CollaborationPresenceStatus.STATUS_AWAY, CollaborationPresenceStatus.STATUS_DO_NOT_DISTURB, CollaborationPresenceStatus.STATUS_IN_A_MEETING};
    private final MenuManager fMenuManager = new MenuManager();

    private static boolean hasLoggedInRepositories() {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void dispose() {
        this.fMenuManager.dispose();
    }

    public void fillContextMenu(IMenuManager manager) {
        boolean disconnectEnabled;
        Assert.isNotNull((Object)manager);
        final ICollaborationService service = CollaborationCore.getCollaborationService();
        boolean hasLoggedInRepositories = ChangePresenceMenuCreator.hasLoggedInRepositories();
        boolean loggedIn = service.isLoggedIn(0);
        boolean connectEnabled = hasLoggedInRepositories && service.isLoggedOut(0);
        boolean bl = disconnectEnabled = hasLoggedInRepositories && loggedIn;
        if (!connectEnabled && !disconnectEnabled) {
            Action configureAction = new Action(CollaborationMessages.ChangePresenceAction_7){

                public void run() {
                    Shell shell;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (shell = window.getShell()) != null) {
                        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.ibm.team.collaboration.ui.imAccountsPage", null, null).open();
                    }
                }
            };
            manager.add((IAction)configureAction);
        } else {
            Action connectAction = new Action(CollaborationMessages.ChangePresenceAction_0){

                public void run() {
                    service.scheduleJob(new CollaborationServiceJob(){

                        public String getName() {
                            return CollaborationMessages.ChangePresenceAction_1;
                        }

                        public boolean isSystem() {
                            return false;
                        }

                        public boolean isUser() {
                            return true;
                        }

                        public IStatus run(IProgressMonitor monitor) {
                            return CollaborationExceptionHandler.handleErrorStatus(service.login(0, monitor));
                        }
                    });
                }
            };
            connectAction.setEnabled(connectEnabled);
            manager.add((IAction)connectAction);
            Action disconnectAction = new Action(CollaborationMessages.ChangePresenceAction_2){

                public void run() {
                    service.scheduleJob(new CollaborationServiceJob(){

                        public String getName() {
                            return CollaborationMessages.ChangePresenceAction_3;
                        }

                        public boolean isSystem() {
                            return false;
                        }

                        public boolean isUser() {
                            return true;
                        }

                        public IStatus run(IProgressMonitor monitor) {
                            return CollaborationExceptionHandler.handleErrorStatus(service.logout(0, monitor));
                        }
                    });
                }
            };
            disconnectAction.setEnabled(disconnectEnabled);
            manager.add((IAction)disconnectAction);
            if (loggedIn) {
                manager.add((IContributionItem)new Separator());
                CollaborationPresenceStatus[] collaborationPresenceStatusArray = STATUS_CONSTANTS;
                int n = STATUS_CONSTANTS.length;
                int n2 = 0;
                while (n2 < n) {
                    final CollaborationPresenceStatus status = collaborationPresenceStatusArray[n2];
                    Action statusAction = new Action(status.getText(), CollaborationUI.getImageDescriptor(status, true)){

                        public void run() {
                            FoundationJob job = new FoundationJob(CollaborationMessages.ChangePresenceAction_4){

                                protected IStatus runProtected(IProgressMonitor monitor) {
                                    return CollaborationCore.getCollaborationService().setPresenceStatus(status, monitor);
                                }
                            };
                            job.setPriority(20);
                            job.schedule();
                        }
                    };
                    manager.add((IAction)statusAction);
                    ++n2;
                }
            }
        }
    }

    public Menu getMenu(Control parent) {
        Assert.isNotNull((Object)parent);
        this.fMenuManager.removeAll();
        this.fillContextMenu((IMenuManager)this.fMenuManager);
        Menu menu = this.fMenuManager.createContextMenu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(final MenuEvent event) {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        event.widget.dispose();
                    }
                });
            }
        });
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Assert.isNotNull((Object)parent);
        return null;
    }
}

