/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.preference;

import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.ui.preference.CollaborationAccountPreferencePage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;

public final class IMAccountsPreferencePage
extends CollaborationAccountPreferencePage {
    public static final String PAGE_ID = "com.ibm.team.collaboration.ui.imAccountsPage";
    private Button fShowPresenceTrim;

    private static boolean isPresenceTrimVisible() {
        Control control;
        IWindowTrim trim;
        WorkbenchWindow extended;
        ITrimManager manager;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow && (manager = (extended = (WorkbenchWindow)window).getTrimManager()) != null && (trim = manager.getTrim("com.ibm.team.collaboration.rcp.ui.ChangePresenceGroup")) != null && (control = trim.getControl()) != null) {
            return control.isVisible();
        }
        return false;
    }

    public IMAccountsPreferencePage() {
        super(PAGE_ID, CollaborationMessages.IMAccountsPreferencePage_19);
    }

    protected Composite createAccountControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fShowPresenceTrim = new Button(parent, 32);
        this.fShowPresenceTrim.setText(CollaborationMessages.IMAccountsPreferencePage_18);
        this.fShowPresenceTrim.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fShowPresenceTrim.setSelection(IMAccountsPreferencePage.isPresenceTrimVisible());
        this.createLabelSeparator(parent);
        return parent;
    }

    protected Control createContents(Composite parent) {
        Assert.isNotNull((Object)parent);
        Control control = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.collaboration.ui.im_account_preferences");
        return control;
    }

    final Label createLabelSeparator(Composite parent) {
        Assert.isNotNull((Object)parent);
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected String getAddAccountTitle() {
        return CollaborationMessages.IMAccountsPreferencePage_21;
    }

    protected String getEditAccountTitle() {
        return CollaborationMessages.IMAccountsPreferencePage_22;
    }

    protected int getPrimaryCapabilities() {
        return 1;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateChangePresenceTrim(true);
    }

    public boolean performOk() {
        this.updateChangePresenceTrim(this.fShowPresenceTrim.getSelection());
        return super.performOk();
    }

    private void updateChangePresenceTrim(boolean visible) {
        IWorkbenchWindow[] windows;
        IPreferenceStore store = CollaborationUIPlugin.getInstance().getPreferenceStore();
        store.setDefault("com.ibm.team.collaboration.show.presence.trim", true);
        store.setValue("com.ibm.team.collaboration.show.presence.trim", visible);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWindowTrim trim;
            WorkbenchWindow extended;
            ITrimManager manager;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window instanceof WorkbenchWindow && (manager = (extended = (WorkbenchWindow)window).getTrimManager()) != null && (trim = manager.getTrim("com.ibm.team.collaboration.rcp.ui.ChangePresenceGroup")) != null) {
                manager.setTrimVisible(trim, visible);
                trim.getControl().getParent().layout(true);
            }
            ++n2;
        }
    }
}

